/*
 * Decompiled with CFR 0.152.
 */
package com.stimulsoft.report.infographics.gauge.scales;

import com.stimulsoft.base.StiJsonSaveMode;
import com.stimulsoft.base.json.JProperty;
import com.stimulsoft.base.json.JSONException;
import com.stimulsoft.base.json.JSONObject;
import com.stimulsoft.base.serializing.annotations.StiSerializable;
import com.stimulsoft.report.enums.StiComponentId;
import com.stimulsoft.report.enums.StiOrientation;
import com.stimulsoft.report.events.MouseEventArgs;
import com.stimulsoft.report.infographics.gauge.StiGaugeElemenType;
import com.stimulsoft.report.infographics.gauge.primitives.base.StiGaugeElement;
import com.stimulsoft.report.infographics.gauge.primitives.scalebargeometry.StiLinearBarGeometry;
import com.stimulsoft.report.infographics.gauge.primitives.scales.StiScaleBase;
import com.stimulsoft.report.infographics.gauge.styles.IStiGaugeStyle;

public class StiLinearScale
extends StiScaleBase {
    private StiOrientation orientation = StiOrientation.Vertical;
    private double relativeHeight = 0.9;

    @Override
    public JSONObject SaveToJsonObject(StiJsonSaveMode mode) throws JSONException {
        JSONObject jObject = super.SaveToJsonObject(mode);
        jObject.AddPropertyIdent("Ident", this.getClass().getName());
        jObject.AddPropertyEnum("Orientation", (Enum)this.orientation);
        jObject.AddPropertyFloat("RelativeHeight", this.relativeHeight, 0.9);
        return jObject;
    }

    @Override
    public void LoadFromJsonObject(JSONObject jObject) throws JSONException {
        super.LoadFromJsonObject(jObject);
        for (JProperty property : jObject.Properties()) {
            if ("Orientation".equals(property.Name)) {
                this.setOrientation(StiOrientation.valueOf(property.Value.toString()));
                continue;
            }
            if (!"RelativeHeight".equals(property.Name)) continue;
            this.setRelativeHeight(Double.parseDouble(property.Value.toString()));
        }
    }

    @Override
    public StiComponentId getComponentId() {
        return StiComponentId.StiLinearScale;
    }

    @Override
    public void applyStyle(IStiGaugeStyle style) {
        for (int index = 0; index < this.getItems().size(); ++index) {
            ((StiGaugeElement)this.getItems().get(index)).applyStyle(style);
        }
    }

    @Override
    public Object clone() {
        StiLinearScale scale = (StiLinearScale)super.clone();
        scale.orientation = this.orientation;
        scale.relativeHeight = this.relativeHeight;
        return scale;
    }

    @StiSerializable
    public StiOrientation getOrientation() {
        return this.orientation;
    }

    public void setOrientation(StiOrientation orientation) {
        this.orientation = orientation;
    }

    @StiSerializable
    public double getRelativeHeight() {
        return this.relativeHeight;
    }

    public void setRelativeHeight(double relativeHeight) {
        this.relativeHeight = relativeHeight;
    }

    @Override
    public StiGaugeElemenType getScaleType() {
        return StiGaugeElemenType.LinearElement;
    }

    protected void interactiveClick(MouseEventArgs e) {
    }

    @Override
    public StiScaleBase createNew() {
        return new StiLinearScale();
    }

    public StiLinearScale() {
        this.barGeometry = new StiLinearBarGeometry(this);
    }
}

