/*
 * Decompiled with CFR 0.152.
 */
package com.stimulsoft.report.infographics.gauge.skins.needleindicator;

import com.stimulsoft.base.StiEnumSet;
import com.stimulsoft.base.drawing.StiBrush;
import com.stimulsoft.base.drawing.StiColor;
import com.stimulsoft.base.drawing.StiColorEnum;
import com.stimulsoft.base.drawing.StiEmptyBrush;
import com.stimulsoft.base.drawing.StiSolidBrush;
import com.stimulsoft.base.drawing.enums.StiStringAlignment;
import com.stimulsoft.base.drawing.enums.StiStringFormatFlags;
import com.stimulsoft.base.system.StiFont;
import com.stimulsoft.base.system.StiSize;
import com.stimulsoft.base.system.StringFormat;
import com.stimulsoft.base.system.geometry.StiPoint;
import com.stimulsoft.base.system.geometry.StiRectangle;
import com.stimulsoft.lib.utils.StiStringUtil;
import com.stimulsoft.report.infographics.gauge.indicators.StiNeedle;
import com.stimulsoft.report.infographics.gauge.primitives.base.StiGaugeElement;
import com.stimulsoft.report.infographics.gauge.skins.StiGaugeElementSkin;
import com.stimulsoft.report.painters.StiGaugeContextPainter;
import com.stimulsoft.report.painters.context.gauge.geoms.StiGraphicsPathGaugeGeom;

public class StiNeedleIndicator2Skin
extends StiGaugeElementSkin {
    @Override
    public void draw(StiGaugeContextPainter context, StiGaugeElement element, StiRectangle rect, Double angle, StiPoint centerPoint) {
        boolean rotate;
        StiPoint[] points;
        StiNeedle indicator = (StiNeedle)element;
        double minumum = Math.min(rect.width, rect.height);
        double value = minumum / 3.0;
        StiRectangle arrayRect = new StiRectangle(rect.getLeft() + 1.0, rect.getTop() + (rect.height - value) / 2.0, rect.width - 1.0, value);
        StiGraphicsPathGaugeGeom pathGeom = new StiGraphicsPathGaugeGeom(arrayRect, arrayRect.getLocation(), indicator.getBrush(), indicator.getBorderBrush(), indicator.getBorderWidth());
        value = minumum / 7.0;
        points = new StiPoint[]{arrayRect.getLocation(), new StiPoint(arrayRect.getRight(), arrayRect.getTop() + (arrayRect.height - value) / 2.0), new StiPoint(arrayRect.getRight(), arrayRect.getBottom() - (arrayRect.height - value) / 2.0), new StiPoint(arrayRect.getLeft(), arrayRect.getBottom()), points[0]};
        pathGeom.addGraphicsPathLinesGaugeGeom(points);
        boolean bl = rotate = angle != null && centerPoint != null;
        if (rotate) {
            context.addPushMatrixGaugeGeom(angle, centerPoint.getValue());
        }
        if (element.getAnimation() != null) {
            pathGeom.setAnimation(element.getAnimation());
        }
        context.addGraphicsPathGaugeGeom(pathGeom);
        StiRectangle ellipseRect = new StiRectangle(rect.getLocation(), new StiSize(minumum, minumum));
        StiSolidBrush ellipseBrush = new StiSolidBrush(StiColor.fromArgb((int)175, (int)175, (int)175));
        context.addEllipseGaugeGeom(ellipseRect, (StiBrush)ellipseBrush, indicator.getBorderBrush(), 1.5);
        double offset = minumum * (double)0.15f;
        StiRectangle internalEllipseRect = new StiRectangle(ellipseRect.x + offset, ellipseRect.getTop() + offset, minumum - offset * 2.0, minumum - offset * 2.0);
        context.addEllipseGaugeGeom(internalEllipseRect, (StiBrush)new StiEmptyBrush(), (StiBrush)new StiSolidBrush(StiColorEnum.White.color()), 2.0);
        if (rotate) {
            context.addPopTranformGaugeGeom();
        }
        if (indicator.isShowValue()) {
            StringFormat sf = new StringFormat();
            sf.Alignment = StiStringAlignment.Center;
            sf.LineAlignment = StiStringAlignment.Center;
            sf.FormatFlags = StiEnumSet.of((Enum)StiStringFormatFlags.NoWrap);
            StiFont zoomFont = StiGaugeContextPainter.changeFontSize(indicator.getFont(), context.zoom);
            context.addTextGaugeGeom(StiStringUtil.format((String)indicator.getFormat(), (Object)indicator.getValueObj()), zoomFont, indicator.getTextBrush(), ellipseRect, sf);
        }
    }
}

