/*
 * Decompiled with CFR 0.152.
 */
package com.stimulsoft.report.infographics.gauge.skins.needleindicator;

import com.stimulsoft.base.StiEnumSet;
import com.stimulsoft.base.drawing.enums.StiStringAlignment;
import com.stimulsoft.base.drawing.enums.StiStringFormatFlags;
import com.stimulsoft.base.system.StiFont;
import com.stimulsoft.base.system.StiSize;
import com.stimulsoft.base.system.StringFormat;
import com.stimulsoft.base.system.geometry.StiPoint;
import com.stimulsoft.base.system.geometry.StiRectangle;
import com.stimulsoft.lib.utils.StiStringUtil;
import com.stimulsoft.report.Func;
import com.stimulsoft.report.engine.parser.StiParser;
import com.stimulsoft.report.infographics.gauge.indicators.StiNeedle;
import com.stimulsoft.report.infographics.gauge.primitives.base.StiGaugeElement;
import com.stimulsoft.report.infographics.gauge.skins.StiGaugeElementSkin;
import com.stimulsoft.report.painters.StiGaugeContextPainter;
import com.stimulsoft.report.painters.context.gauge.geoms.StiGraphicsPathGaugeGeom;

public class StiNeedleIndicator4Skin
extends StiGaugeElementSkin {
    @Override
    public void draw(StiGaugeContextPainter context, StiGaugeElement element, StiRectangle rect, Double angle, StiPoint centerPoint) {
        boolean rotate;
        StiPoint[] points;
        StiNeedle indicator = (StiNeedle)element;
        double minumum = Math.min(rect.width, rect.height);
        StiPoint needlePointLocation = new StiPoint(rect.getLocation().x + minumum / 2.0 - indicator.getOffsetNeedle() * rect.width, rect.getLocation().y + rect.height / 2.0 - minumum / 2.0);
        StiRectangle needleRect = new StiRectangle(needlePointLocation, new StiSize(rect.width - minumum / 2.0, minumum));
        points = new StiPoint[]{new StiPoint(needleRect.x, needleRect.y + needleRect.height / 2.0 - needleRect.height * indicator.getEndWidth() / 2.0), new StiPoint(needleRect.getRight(), needleRect.y + needleRect.height / 2.0 - needleRect.height * indicator.getStartWidth() / 2.0), new StiPoint(needleRect.getRight(), needleRect.y + needleRect.height / 2.0 + needleRect.height * indicator.getStartWidth() / 2.0), new StiPoint(needleRect.x, needleRect.y + needleRect.height / 2.0 + needleRect.height * indicator.getEndWidth() / 2.0), points[0]};
        StiGraphicsPathGaugeGeom pathGeom = new StiGraphicsPathGaugeGeom(needleRect, points[0], indicator.getBrush(), indicator.getBorderBrush(), indicator.getBorderWidth());
        pathGeom.addGraphicsPathLinesGaugeGeom(points);
        boolean bl = rotate = angle != null && centerPoint != null;
        if (rotate) {
            context.addPushMatrixGaugeGeom(angle, centerPoint.getValue());
        }
        context.addGraphicsPathGaugeGeom(pathGeom);
        StiPoint capPointLocation = new StiPoint(rect.getLocation().x, rect.getLocation().y + rect.height / 2.0 - minumum / 2.0);
        StiRectangle capRect = new StiRectangle(capPointLocation, new StiSize(minumum, minumum));
        context.addEllipseGaugeGeom(capRect, indicator.getCapBrush(), indicator.getCapBorderBrush(), indicator.getCapBorderWidth());
        if (rotate) {
            context.addPopTranformGaugeGeom();
        }
        if (element.getAnimation() != null) {
            pathGeom.setAnimation(element.getAnimation());
        }
        if (indicator.isShowValue()) {
            StringFormat sf = new StringFormat();
            sf.Alignment = StiStringAlignment.Center;
            sf.LineAlignment = StiStringAlignment.Center;
            sf.FormatFlags = StiEnumSet.of((Enum)StiStringFormatFlags.NoWrap);
            StiFont zoomFont = StiGaugeContextPainter.changeFontSize(indicator.getFont(), context.zoom);
            Double value = context.gauge.getReport().getIsDesigning() ? Func.Convert.toSingle(StiParser.ParseTextValue("{" + indicator.getValue().getValue() + "}", context.gauge)) : indicator.getValueObj();
            context.addTextGaugeGeom(StiStringUtil.format((String)indicator.getFormat(), (Object)value), zoomFont, indicator.getTextBrush(), capRect, sf);
        }
    }
}

