/*
 * Decompiled with CFR 0.152.
 */
package com.stimulsoft.report.maps.helpers;

import com.stimulsoft.lib.utils.StiValidationUtil;
import com.stimulsoft.report.maps.StiMap;
import com.stimulsoft.report.maps.helpers.StiCacheItem;
import java.util.concurrent.ConcurrentHashMap;

public class StiMapDrawingCache {
    private static ConcurrentHashMap<StiMap, StiCacheItem> lastImageCache = new ConcurrentHashMap();

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void removeImage(StiMap map) {
        ConcurrentHashMap<StiMap, StiCacheItem> concurrentHashMap = lastImageCache;
        synchronized (concurrentHashMap) {
            if (lastImageCache.containsKey(map)) {
                lastImageCache.remove(map);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static Object getLastImage(StiMap map) {
        ConcurrentHashMap<StiMap, StiCacheItem> concurrentHashMap = lastImageCache;
        synchronized (concurrentHashMap) {
            if (!lastImageCache.containsKey(map)) {
                return null;
            }
            StiCacheItem item = lastImageCache.get(map);
            if (item.isDesigning != map.isDesigning() || !StiValidationUtil.equals((Object)item.latitude, (Object)map.getLatitude()) || !StiValidationUtil.equals((Object)item.longitude, (Object)map.getLongitude())) {
                lastImageCache.remove(map);
                return null;
            }
            return item.image;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void storeLastImage(StiMap map, Object image) {
        ConcurrentHashMap<StiMap, StiCacheItem> concurrentHashMap = lastImageCache;
        synchronized (concurrentHashMap) {
            StiCacheItem item = new StiCacheItem();
            item.image = image;
            item.size = map.getClientRectangle().getSize();
            item.isDesigning = map.isDesigning();
            item.latitude = map.getLatitude();
            item.longitude = map.getLongitude();
            lastImageCache.put(map, item);
        }
    }
}

