/*
 * Decompiled with CFR 0.152.
 */
package com.stimulsoft.report.painters.components;

import com.stimulsoft.base.IStiEnum;
import com.stimulsoft.base.drawing.StiBrush;
import com.stimulsoft.base.drawing.StiColor;
import com.stimulsoft.base.drawing.StiColorEnum;
import com.stimulsoft.base.drawing.StiGraphics;
import com.stimulsoft.base.drawing.StiPen;
import com.stimulsoft.base.drawing.StiSolidBrush;
import com.stimulsoft.base.drawing.enums.StiBorderSides;
import com.stimulsoft.base.drawing.enums.StiPenStyle;
import com.stimulsoft.base.drawing.enums.StiTextHorAlignment;
import com.stimulsoft.base.drawing.enums.StiVertAlignment;
import com.stimulsoft.base.enums.StiHighlightState;
import com.stimulsoft.base.system.StiFont;
import com.stimulsoft.base.system.geometry.StiRectangle;
import com.stimulsoft.report.components.StiComponent;
import com.stimulsoft.report.components.StiComponentsCollection;
import com.stimulsoft.report.components.bands.StiBand;
import com.stimulsoft.report.components.bands.StiDataBand;
import com.stimulsoft.report.components.complexcomponents.StiContainer;
import com.stimulsoft.report.components.complexcomponents.StiPanel;
import com.stimulsoft.report.components.simplecomponents.StiPrimitive;
import com.stimulsoft.report.dialogs.StiForm;
import com.stimulsoft.report.painters.StiPaintArgs;
import com.stimulsoft.report.painters.components.StiComponentPainter;
import com.stimulsoft.report.units.StiToolTipHelper;

public class StiContainerPainter
extends StiComponentPainter {
    public void paintColumns(StiContainer container, StiGraphics g) {
        StiContainer panel;
        StiContainer cont = container;
        int columns = 0;
        double cColumnGaps = 0.0;
        double cColumnWidth = 0.0;
        if (container instanceof StiPanel) {
            panel = (StiPanel)container;
            columns = ((StiPanel)panel).getColumns();
            cColumnGaps = ((StiPanel)panel).getColumnGaps();
            cColumnWidth = ((StiPanel)panel).getColumnWidthM();
        } else if (container instanceof StiDataBand) {
            panel = (StiDataBand)container;
            columns = ((StiDataBand)panel).getColumns();
            cColumnGaps = ((StiDataBand)panel).getColumnGaps();
            cColumnWidth = ((StiDataBand)panel).getColumnWidth();
        } else {
            cont = null;
        }
        if (cont != null && container.getIsDesigning() && columns > 1) {
            Double zoom = container.getPage().getZoom();
            Double pageZoom = container.getReport().getInfo().getZoom();
            StiRectangle rect = container.getPaintRectangle();
            Double columnWidth = container.getPage().ConvertToHInches(container.getPage().getUnit(), cColumnWidth) * zoom;
            Double columnGaps = container.getPage().ConvertToHInches(container.getPage().getUnit(), cColumnGaps) * zoom;
            Double pos = columnWidth + rect.getLeft();
            StiPen pen = new StiPen(1.0, StiColorEnum.Red.color(), StiPenStyle.Dash);
            int countOfColumns = columns;
            if (cColumnWidth == 0.0 && cColumnGaps == 0.0) {
                --countOfColumns;
            }
            for (int index = 1; index < countOfColumns; ++index) {
                g.drawLineXY(pos, Double.valueOf(rect.getTop()), pos, Double.valueOf(rect.getBottom()), pen, zoom);
                g.drawLineXY(Double.valueOf(pos + columnGaps), Double.valueOf(rect.getTop()), Double.valueOf(pos + columnGaps), Double.valueOf(rect.getBottom()), pen, zoom);
                pos = pos + (columnWidth + columnGaps);
            }
            g.drawLineXY(pos, Double.valueOf(rect.getTop()), pos, Double.valueOf(rect.getBottom()), pen, zoom);
            rect.setX(rect.getX() + columnWidth + columnGaps);
            StiComponentsCollection comps = container.getComponents();
            for (StiComponent comp : comps) {
                StiRectangle compRect = comp.getPaintRectangle();
                if (!(compRect.getWidth() > 0.0) || !(compRect.getHeight() > 0.0)) continue;
                StiPen compPen = new StiPen(1.0, StiColorEnum.Blue.color(), StiPenStyle.Dash);
                StiSolidBrush compBrush = new StiSolidBrush(StiColor.fromAColor((int)20, (StiColor)StiColorEnum.Blue.color()));
                for (int id = 0; id < columns - 1; ++id) {
                    compRect.setX(compRect.getX() + columnWidth + columnGaps);
                    g.drawRectangle(compRect, null, (StiBrush)compBrush, zoom, pageZoom);
                    g.drawRectangle(compRect, compPen, null, zoom, pageZoom);
                }
            }
        }
    }

    public void paintComponents(StiContainer container, StiPaintArgs args) {
        if (container.getPage() instanceof StiForm) {
            for (StiComponent component : container.getComponents()) {
                component.paint(args);
            }
        } else if (container.getIsPrinting()) {
            for (StiComponent component : container.getComponents()) {
                if (!component.getPrintable() || component instanceof StiBand) continue;
                component.paint(args);
            }
            for (StiComponent component : container.getComponents()) {
                if (!component.getPrintable() || !(component instanceof StiBand)) continue;
                component.paint(args);
            }
        } else {
            Boolean isDesigning = container.getIsDesigning();
            Boolean isOffsetNotEmpty = !container.getPage().getOffsetRectangle().getIsEmpty();
            for (StiComponent component : container.getComponents()) {
                if (component.getHyperlinkValue() != null && !component.getHyperlinkValue().equals("")) {
                    StiToolTipHelper.addToolTip(component, component.getHyperlinkValue(), true);
                } else if (component.getToolTipValue() != null && !component.getToolTipValue().equals("")) {
                    StiToolTipHelper.addToolTip(component, component.getToolTipValue(), false);
                }
                if (component instanceof StiPrimitive || component instanceof StiBand) continue;
                if (component.getIsSelected() && isDesigning.booleanValue() && isOffsetNotEmpty.booleanValue()) {
                    container.getPage().getSelectedComponents().add(component);
                    continue;
                }
                component.paint(args);
            }
            for (StiComponent component : container.getComponents()) {
                if (!(component instanceof StiBand)) continue;
                if (component.getIsSelected() && isDesigning.booleanValue() && isOffsetNotEmpty.booleanValue()) {
                    container.getPage().getSelectedComponents().add(component);
                    continue;
                }
                component.paint(args);
            }
            for (StiComponent component : container.getComponents()) {
                if (!(component instanceof StiPrimitive)) continue;
                if (component.getIsSelected() && isDesigning.booleanValue() && isOffsetNotEmpty.booleanValue()) {
                    container.getPage().getSelectedComponents().add(component);
                    continue;
                }
                component.paint(args);
            }
            if (!container.getIsDesigning()) {
                // empty if block
            }
        }
    }

    @Override
    public void paint(StiComponent component, StiPaintArgs args) {
        StiRectangle rect;
        if ((component.getEnabled() || component.getIsDesigning()) && (rect = component.getPaintRectangle()).getWidth() > 0.0 && rect.getHeight() > 0.0 && args.intersectsWith(rect).booleanValue()) {
            StiGraphics g = args.getG();
            StiContainer container = (StiContainer)component;
            Double zoom = container.getReport().getInfo().getZoom();
            Double pageZoom = container.getReport().getInfo().getPageZoom();
            Boolean topMost = args.getDrawTopmostBorderSides();
            if (!topMost.booleanValue()) {
                if (container.getBrush() instanceof StiSolidBrush && StiColorEnum.Transparent.color().equals(StiSolidBrush.ToColor((StiBrush)container.brush)) && container.getReport().getInfo().getFillComponent() && container.getIsDesigning()) {
                    StiColor color = StiColor.fromArgb((int)150, (int)255, (int)255, (int)255);
                    g.drawRectangle(rect, null, (StiBrush)new StiSolidBrush(color), zoom, pageZoom);
                } else {
                    g.drawRectangle(rect, null, container.brush, zoom, pageZoom);
                }
                if (container.getIsDesigning()) {
                    StiFont font = new StiFont("Arial", 15.0);
                    g.drawText(container.getName(), rect, font, (StiBrush)new StiSolidBrush(StiColorEnum.Gray.color()), StiTextHorAlignment.Center, StiVertAlignment.Center, Boolean.valueOf(false), zoom, null, null, null);
                }
                if (container.getHighlightState() == StiHighlightState.Hide && !container.getBorder().getSide().contains((IStiEnum)StiBorderSides.All)) {
                    this.paintMarkers(container, g, rect, zoom, pageZoom);
                }
                if (container.getIsDesigning() && container.getBorder().getSide().containsOnly((IStiEnum)StiBorderSides.None)) {
                    StiPen pen = new StiPen(1.0, StiColorEnum.Gray.color(), StiPenStyle.Dash);
                    g.drawRectangle(rect, pen, null, zoom, pageZoom);
                }
                super.paintBorder(container, g, rect, topMost, args.isThumbPaint(), zoom, pageZoom);
            } else {
                super.paintBorder(container, g, rect, topMost, args.isThumbPaint(), zoom, pageZoom);
            }
        }
        this.paintColumns((StiContainer)component, args.getG());
        this.paintComponents((StiContainer)component, args);
    }
}

