/*
 * Decompiled with CFR 0.152.
 */
package com.stimulsoft.report.painters.components;

import com.stimulsoft.base.IStiEnum;
import com.stimulsoft.base.drawing.StiBrush;
import com.stimulsoft.base.drawing.StiColor;
import com.stimulsoft.base.drawing.StiColorEnum;
import com.stimulsoft.base.drawing.StiGraphics;
import com.stimulsoft.base.drawing.StiSolidBrush;
import com.stimulsoft.base.drawing.enums.StiBorderSides;
import com.stimulsoft.base.enums.StiHighlightState;
import com.stimulsoft.base.system.geometry.StiRectangle;
import com.stimulsoft.lib.utils.StiValidationUtil;
import com.stimulsoft.report.StiOptions;
import com.stimulsoft.report.components.StiComponent;
import com.stimulsoft.report.enums.StiExportFormat;
import com.stimulsoft.report.maps.StiMap;
import com.stimulsoft.report.maps.helpers.StiMapHelper;
import com.stimulsoft.report.painters.StiGdiMapContextPainter;
import com.stimulsoft.report.painters.StiPaintArgs;
import com.stimulsoft.report.painters.components.StiComponentPainter;
import com.stimulsoft.report.styles.StiMapStyle;
import java.awt.image.BufferedImage;

public class StiMapPainter
extends StiComponentPainter {
    public void drawMap(StiMap map, StiGraphics g, StiRectangle rect, boolean useMargins, boolean useBackground, boolean useZoom) throws Exception {
        double pageZoom;
        double zoom = map != null && map.getReport() != null && map.getReport().getInfo() != null ? map.getReport().getInfo().getZoom() : 1.0;
        double d = pageZoom = map != null && map.getReport() != null && map.getReport().getInfo() != null ? map.getReport().getInfo().getPageZoom() : 1.0;
        if (useBackground) {
            StiMapStyle style = null;
            style = !StiValidationUtil.isNullOrEmpty((String)map.getComponentStyle()) ? (StiMapStyle)map.getReport().getStyles().get(map.getComponentStyle()) : StiMap.getMapStyle(map.getMapStyle());
            if (style != null) {
                g.drawRectangle(rect, null, (StiBrush)new StiSolidBrush(style.getBackColor()), Double.valueOf(zoom), Double.valueOf(pageZoom));
            } else if (map.getBrush() instanceof StiSolidBrush && StiColorEnum.Transparent.color().equals(((StiSolidBrush)map.getBrush()).getColor()) && map.getReport().getInfo().getFillComponent() && map.isDesigning()) {
                StiColor color = StiColor.FromArgb((int)150, (StiColor)StiColorEnum.White.color());
                g.drawRectangle(rect, null, (StiBrush)new StiSolidBrush(color), Double.valueOf(zoom), Double.valueOf(pageZoom));
            } else {
                g.drawRectangle(rect, null, map.getStyleBackground(), Double.valueOf(zoom), Double.valueOf(pageZoom));
            }
        }
        g.setTransformedClip(rect);
        g.setOffset((double)((int)rect.x), (double)((int)rect.y));
        rect.x = 0.0;
        rect.y = 0.0;
        if (!useMargins) {
            rect.width -= 1.0;
            rect.height -= 1.0;
        }
        map.GetMapData();
        StiMap drawMap = map;
        if (map.isHashDataEmpty()) {
            drawMap = StiMapHelper.getMapSample();
            drawMap.getReport().getInfo().setZoom(zoom);
            drawMap.setMapStyle(map.getMapStyle());
            drawMap.setMapType(map.getMapType());
            drawMap.setShowLegend(map.isShowLegend());
            drawMap.setMapID(map.getMapID());
            drawMap.setShowValue(map.isShowValue());
            drawMap.setStretch(map.isStretch());
            drawMap.setClientRectangle(map.getClientRectangle());
        }
        StiGdiMapContextPainter context = new StiGdiMapContextPainter(map, zoom, pageZoom);
        context.render(g, useZoom);
        g.restoreClip();
        g.clearOffset();
    }

    @Override
    public void paint(StiComponent component, StiPaintArgs e) {
        StiMap map = (StiMap)component;
        double zoom = map != null && map.getReport() != null && map.getReport().getInfo() != null ? map.getReport().getInfo().getZoom() : 1.0;
        double pageZoom = map != null && map.getReport() != null && map.getReport().getInfo() != null ? map.getReport().getInfo().getPageZoom() : 1.0;
        Boolean topMost = e.getDrawTopmostBorderSides();
        if ((map.getEnabled() || map.isDesigning()) && !topMost.booleanValue()) {
            StiGraphics g = e.getG();
            StiRectangle rect = map.getPaintRectangle();
            if (rect.width > 0.0 && rect.height > 0.0 && (e.getClipRectangles().isEmpty() || rect.intersectsWith(rect).booleanValue())) {
                if (StiOptions.Print.getChartAsBitmap() && map.getIsPrinting()) {
                    double zoom1 = 1.0;
                    BufferedImage image = this.getImage(map, zoom1, StiExportFormat.None);
                    g.drawImage(image, rect.clone(), Boolean.valueOf(false), Boolean.valueOf(false), zoom1);
                } else {
                    try {
                        this.drawMap(map, g, rect.clone(), e.getDrawTopmostBorderSides(), false, true);
                    }
                    catch (Exception e1) {
                        e1.printStackTrace();
                    }
                }
                if (map.getHighlightState() == StiHighlightState.Hide && !map.getBorder().side.contains((IStiEnum)StiBorderSides.All)) {
                    this.paintMarkers(map, g, rect, zoom, pageZoom);
                }
            }
            this.paintQuickButtons(map, e.getG());
            this.paintEvents(map, e.getG(), rect);
        }
    }
}

