/*
 * Decompiled with CFR 0.152.
 */
package com.stimulsoft.report.painters.components;

import com.stimulsoft.base.drawing.StiBrush;
import com.stimulsoft.base.drawing.StiColor;
import com.stimulsoft.base.drawing.StiColorEnum;
import com.stimulsoft.base.drawing.StiGraphics;
import com.stimulsoft.base.drawing.StiPen;
import com.stimulsoft.base.drawing.StiRectangleUtils;
import com.stimulsoft.base.drawing.StiSolidBrush;
import com.stimulsoft.base.drawing.StiTextOptions;
import com.stimulsoft.base.drawing.enums.StiAction;
import com.stimulsoft.base.drawing.enums.StiPenStyle;
import com.stimulsoft.base.drawing.enums.StiTextHorAlignment;
import com.stimulsoft.base.drawing.enums.StiVertAlignment;
import com.stimulsoft.base.enums.StiContentAlignment;
import com.stimulsoft.base.licenses.StiLicenseKeyValidator;
import com.stimulsoft.base.localization.StiLocalization;
import com.stimulsoft.base.system.StiFont;
import com.stimulsoft.base.system.StiFontStyle;
import com.stimulsoft.base.system.StiSize;
import com.stimulsoft.base.system.geometry.StiRectangle;
import com.stimulsoft.lib.utils.StiValidationUtil;
import com.stimulsoft.report.StiOptions;
import com.stimulsoft.report.StiReport;
import com.stimulsoft.report.components.StiComponent;
import com.stimulsoft.report.components.StiPage;
import com.stimulsoft.report.components.StiWatermark;
import com.stimulsoft.report.components.bands.StiBand;
import com.stimulsoft.report.painters.StiPaintArgs;
import com.stimulsoft.report.painters.components.StiContainerPainter;
import com.stimulsoft.report.units.StiUnit;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.image.BufferedImage;

public class StiPagePainter
extends StiContainerPainter {
    public void drawPageNumber(StiPage page, StiGraphics g, Integer pageNumber, StiRectangle pageRect, Double zoom, Double pageZoom) {
        if (page.getZoom() > 0.1) {
            StiFont font = new StiFont("Arial", 14.0 / pageZoom);
            g.drawText(StiLocalization.getValue((String)"Components", (String)"StiPage") + pageNumber.toString(), pageRect, font, (StiBrush)new StiSolidBrush(StiColor.fromAColor((int)80, (StiColor)StiColorEnum.Blue.color())), StiTextHorAlignment.Center, StiVertAlignment.Center, Boolean.valueOf(false), zoom, null, null, null);
        }
    }

    public void paintTableLines(StiPage page, StiGraphics g) {
    }

    public void paintText(StiWatermark watermark, StiGraphics g, StiRectangle rect, double zoom, boolean isPrinting) {
        if (watermark.getEnabled() && !StiValidationUtil.isNullOrEmpty((String)watermark.getText())) {
            StiTextOptions textOptions = new StiTextOptions();
            textOptions.setAngle((float)watermark.getAngle());
            textOptions.setRightToLeft(watermark.getRightToLeft());
            g.drawText(watermark.getText(), rect, watermark.getFont(), watermark.getTextBrush(), StiTextHorAlignment.Center, StiVertAlignment.Center, Boolean.valueOf(false), Double.valueOf(zoom), null, null, textOptions);
        }
    }

    public void paintImage(StiReport report, StiWatermark watermark, StiGraphics g, StiRectangle rect, Double zoom) {
        BufferedImage image;
        if (watermark.getEnabled() && (image = watermark.getBufferedImage(report, rect)) != null) {
            if (watermark.getImageStretch()) {
                StiRectangle destRect = rect.clone();
                if (watermark.getAspectRatio()) {
                    double yRatio;
                    double xRatio = destRect.getWidth() / (double)image.getWidth();
                    if (xRatio > (yRatio = destRect.getHeight() / (double)image.getHeight())) {
                        destRect.x = (destRect.width - (double)image.getWidth() * yRatio) / 2.0;
                        destRect.width = (double)image.getWidth() * yRatio;
                    } else {
                        destRect.y = (destRect.height - (double)image.getHeight() * xRatio) / 2.0;
                        destRect.height = (double)image.getHeight() * xRatio;
                    }
                }
                g.drawImage(image, destRect, Boolean.valueOf(true), Boolean.valueOf(true), Boolean.valueOf(true), watermark.getImageTransparency() > 0 ? 1.0f - (float)watermark.getImageTransparency() / 255.0f : 1.0f, zoom);
            } else {
                zoom = zoom * watermark.getImageMultipleFactor();
                StiSize imageSize = new StiSize((double)image.getWidth() * zoom, (double)image.getHeight() * zoom);
                if (watermark.getImageTiling()) {
                    this.paintTileImage(image, g, rect, imageSize, zoom, report);
                } else {
                    StiRectangle imageRect = StiRectangleUtils.alignSizeInRect((StiRectangle)rect, (StiSize)imageSize, (StiContentAlignment)watermark.getImageAlignment());
                    g.drawImage(image, imageRect, Boolean.valueOf(true), Boolean.valueOf(true), Boolean.valueOf(true), watermark.getImageTransparency() > 0 ? 1.0f - (float)watermark.getImageTransparency() / 255.0f : 1.0f, zoom);
                }
            }
        }
    }

    public void paintTileImage(BufferedImage watermarkImage, StiGraphics g, StiRectangle rect, StiSize imageSize, Double zoom, StiReport report) {
        Double y = rect.getY();
        while (y < rect.getBottom()) {
            Double x = rect.getX();
            while (x < rect.getRight()) {
                g.drawImage(watermarkImage, new StiRectangle(x.doubleValue(), y.doubleValue(), imageSize.getWidth(), imageSize.getHeight()), Boolean.valueOf(true), Boolean.valueOf(true), Boolean.valueOf(true), 1.0f, zoom);
                x = x + imageSize.getWidth();
            }
            y = y + imageSize.getHeight();
        }
    }

    public BufferedImage getWatermarkImage(StiPage page, double zoom, boolean useMargins) {
        return this.getWatermarkImage(page, zoom, useMargins, 2);
    }

    public BufferedImage getWatermarkImage(StiPage page, double zoom, boolean useMargins, int imageType) {
        int imgWidth = (int)Math.round(page.getUnit().ConvertToHInches(page.getWidth() + (useMargins ? page.getMargins().getLeft() + page.getMargins().getRight() : 0.0)) * zoom);
        int imgHeight = (int)Math.round(page.getUnit().ConvertToHInches(page.getHeight() + (useMargins ? page.getMargins().getTop() + page.getMargins().getBottom() : 0.0)) * zoom);
        BufferedImage image = new BufferedImage(imgWidth, imgHeight, imageType);
        Graphics2D imageGraphics = image.createGraphics();
        StiGraphics graphics = new StiGraphics((Graphics)imageGraphics);
        StiPaintArgs args = new StiPaintArgs(graphics);
        StiBrush selectedBrush = page.getBrush();
        if (StiBrush.ToColor((StiBrush)page.getBrush()).equals(StiColorEnum.Transparent.color())) {
            selectedBrush = new StiSolidBrush(StiColorEnum.White.color());
        }
        graphics.drawRectangle(new StiRectangle(0L, 0L, (long)imgWidth, (long)imgHeight), null, selectedBrush, Double.valueOf(1.0), Double.valueOf(1.0));
        this.paintImage(page.getReport(), page.getWatermark(), graphics, new StiRectangle(0L, 0L, (long)imgWidth, (long)imgHeight), zoom);
        this.paintText(page.getWatermark(), graphics, new StiRectangle(0L, 0L, (long)imgWidth, (long)imgHeight), zoom, false);
        return image;
    }

    private void paintWatermark(StiPage page, StiGraphics g, Boolean isBehind) {
        double pgWidth = page.getUnit().ConvertToHInches(page.getDisplayRectangle().width);
        double pgHeight = page.getUnit().ConvertToHInches(page.getDisplayRectangle().height);
        StiRectangle rect = new StiRectangle(0.0, 0.0, pgWidth * page.getZoom(), pgHeight * page.getZoom());
        if (page.getWatermark().getShowImageBehind() == isBehind.booleanValue()) {
            this.paintImage(page.getReport(), page.getWatermark(), g, rect, page.getZoom());
        }
        if (page.getWatermark().getShowBehind() == isBehind.booleanValue()) {
            this.paintText(page.getWatermark(), g, rect, page.getZoom(), page.getIsPrinting());
        }
        if (!isBehind.booleanValue() && !StiLicenseKeyValidator.isValidOnJavaFramework(null)) {
            StiTextOptions textOptions = new StiTextOptions();
            textOptions.setAngle(45.0f);
            g.drawText("Trial", rect, new StiFont("Arial", 150.0, StiFontStyle.Bold), (StiBrush)new StiSolidBrush(StiColor.fromArgb((int)30, (int)100, (int)100, (int)100)), StiTextHorAlignment.Center, StiVertAlignment.Center, Boolean.valueOf(false), Double.valueOf(page.getZoom()), null, null, textOptions);
        }
    }

    private void paintDemo(StiGraphics g, Double pgWidth, Double pgHeight, Double zoom) {
    }

    @Override
    public void paint(StiComponent component, StiPaintArgs args) {
        StiPage page = (StiPage)component;
        if (page.getReport() == null) {
            return;
        }
        if (page.getIsDesigning()) {
            page.getSelectedComponents().clear();
        }
        StiGraphics g = args.getG();
        StiUnit unit = page.getUnit();
        Double zoom = page.getZoom();
        Double mgLeft = unit.ConvertToHInches(page.getMargins().getLeft()) * zoom;
        Double mgTop = unit.ConvertToHInches(page.getMargins().getTop()) * zoom;
        Double pgWidth = unit.ConvertToHInches(page.getDisplayRectangle().getWidth()) * zoom;
        Double pgHeight = unit.ConvertToHInches(page.getDisplayRectangle().getHeight()) * zoom;
        Double wd = unit.ConvertToHInches(page.getWidth()) * zoom;
        Double ht = unit.ConvertToHInches(page.getHeight()) * zoom;
        this.paintWatermark(page, args.getG(), true);
        g.setOffset(mgLeft.doubleValue(), mgTop.doubleValue());
        if (page.getIsDesigning() && page.getColumns() > 1) {
            Double columnWidth = unit.ConvertToHInches(page.getColumnWidthM()) * zoom;
            Double columnGaps = unit.ConvertToHInches(page.getColumnGaps()) * zoom;
            Double pos = columnWidth;
            StiPen pen = new StiPen(1.0, StiColorEnum.Red.color(), StiPenStyle.Dash);
            for (int index = 1; index < page.getColumns(); ++index) {
                g.drawLineXY(pos, Double.valueOf(0.0), pos, ht, pen, zoom);
                if (columnGaps > 0.0) {
                    g.drawLineXY(Double.valueOf(pos + columnGaps), Double.valueOf(0.0), Double.valueOf(pos + columnGaps), ht, pen, zoom);
                }
                pos = pos + (columnWidth + columnGaps);
            }
            g.drawLineXY(pos, Double.valueOf(0.0), pos, ht, pen, zoom);
        }
        this.paintComponents(page, args);
        this.paintBorder(page, g, new StiRectangle(0.0, 0.0, (double)Math.round(wd), (double)Math.round(ht)), args.getDrawTopmostBorderSides(), args.isThumbPaint(), zoom, page.getReport().getInfo().getPageZoom());
        args.setDrawTopmostBorderSides(true);
        this.paintComponents(page, args);
        this.paintBorder(page, g, new StiRectangle(0.0, 0.0, (double)Math.round(wd), (double)Math.round(ht)), args.getDrawTopmostBorderSides(), args.isThumbPaint(), zoom, page.getReport().getInfo().getPageZoom());
        if (page.getIsDesigning()) {
            for (StiComponent component_ : page.getSelectedComponents()) {
                if (!(component_ instanceof StiBand)) continue;
                component_.paint(args);
            }
            for (StiComponent component_ : page.getSelectedComponents()) {
                if (component_ instanceof StiBand) continue;
                component_.paint(args);
            }
        }
        if (!page.getIsDesigning() || page.getReport().getInfo().getCurrentAction() != StiAction.None) {
            // empty if block
        }
        Double pageZoom = component.getReport().getInfo().getPageZoom();
        g.clearOffset();
        this.paintWatermark(page, args.getG(), false);
        this.paintDemo(g, pgWidth, pgHeight, zoom);
        g.setOffset(mgLeft.doubleValue(), mgTop.doubleValue());
        if (!(page.getDenyDrawSegmentMode() || !StiOptions.Viewer.getAllowDrawSegmentMode() || page.getIsPrinting() || page.getSegmentPerWidth() <= 1 && page.getSegmentPerHeight() <= 1)) {
            if (page.getSegmentPerWidth() > 1 || page.getSegmentPerHeight() > 1) {
                Double widthStep = unit.ConvertToHInches(page.getWidth() / (double)page.getSegmentPerWidth());
                Double heightStep = unit.ConvertToHInches(page.getHeight() / (double)page.getSegmentPerHeight());
                StiPen linePen = new StiPen(2.0 / pageZoom, StiColor.fromArgb((int)180, (StiColor)StiColorEnum.Blue.color()), StiPenStyle.Dash);
                Double py = 0.0;
                Integer startPageNumber = 1;
                if (!page.getIsDesigning() && page.getReport().getRenderedPages().size() > 0) {
                    startPageNumber = page.getReport().getPageIndex(page.getReport().getRenderedPages().indexOf(page));
                }
                for (int dy = 0; dy < page.getSegmentPerHeight(); ++dy) {
                    Double px = 0.0;
                    py = py + heightStep;
                    for (int dx = 0; dx < page.getSegmentPerWidth(); ++dx) {
                        px = px + widthStep;
                        if (dx < page.getSegmentPerWidth() - 1) {
                            g.drawLineXY(Double.valueOf(px * zoom), Double.valueOf(0.0), Double.valueOf(px * zoom), Double.valueOf(unit.ConvertToHInches(page.getHeight()) * zoom), linePen, zoom);
                        }
                        StiRectangle pageRect = new StiRectangle((px - widthStep) * zoom, (py - heightStep) * zoom, widthStep * zoom, heightStep * zoom);
                        this.drawPageNumber(page, g, startPageNumber, pageRect, zoom, pageZoom);
                        Integer n = startPageNumber;
                        Integer n2 = startPageNumber = Integer.valueOf(startPageNumber + 1);
                    }
                    if (dy >= page.getSegmentPerHeight() - 1) continue;
                    g.drawLineXY(Double.valueOf(0.0), Double.valueOf(py * zoom), Double.valueOf(unit.ConvertToHInches(page.getWidth()) * zoom), Double.valueOf(py * zoom), linePen, zoom);
                }
            } else {
                this.drawPageNumber(page, g, 1, new StiRectangle(0.0, 0.0, wd * zoom, ht * zoom), zoom, pageZoom);
            }
            StiPen rectPen = new StiPen(2.0 / pageZoom, StiColor.fromAColor((int)180, (StiColor)StiColorEnum.Blue.color()));
            g.drawRectangle(new StiRectangle(0.0, 0.0, wd.doubleValue(), ht.doubleValue()), rectPen, null, zoom, pageZoom);
        }
        g.clearOffset();
    }
}

