/*
 * Decompiled with CFR 0.152.
 */
package com.stimulsoft.report.painters.components;

import com.stimulsoft.base.drawing.StiBrush;
import com.stimulsoft.base.drawing.StiColor;
import com.stimulsoft.base.drawing.StiColorEnum;
import com.stimulsoft.base.drawing.StiGraphics;
import com.stimulsoft.base.drawing.StiSolidBrush;
import com.stimulsoft.base.drawing.enums.StiPenStyle;
import com.stimulsoft.base.drawing.enums.StiStringAlignment;
import com.stimulsoft.base.drawing.enums.StiTextHorAlignment;
import com.stimulsoft.base.system.StiFont;
import com.stimulsoft.base.system.StiSize;
import com.stimulsoft.base.system.StringFormat;
import com.stimulsoft.base.system.geometry.StiRectangle;
import com.stimulsoft.lib.utils.StiStringUtil;
import com.stimulsoft.report.StiDpiHelper;
import com.stimulsoft.report.components.StiComponent;
import com.stimulsoft.report.components.simplecomponents.StiText;
import com.stimulsoft.report.components.simplecomponents.StiTextInCells;
import com.stimulsoft.report.components.simplecomponents.StiTextInCellsHelper;
import com.stimulsoft.report.painters.components.StiTextPainter;
import com.stimulsoft.report.units.StiUnit;
import java.util.ArrayList;

public class StiTextInCellsPainter
extends StiTextPainter {
    @Override
    public void paintBorder(StiComponent textComp, StiGraphics g, StiRectangle rect, Boolean drawBorderFormatting, Boolean drawTopmostBorderSides, Double zoom) {
        if (!textComp.isDesigning() || textComp.getReport().getIsPageDesigner()) {
            super.paintBorder(textComp, g, rect, drawBorderFormatting, drawTopmostBorderSides, zoom);
            return;
        }
    }

    @Override
    public void paintBackground(StiText textComp, StiGraphics g, StiRectangle rect, Double zoom, Double pageZoom) {
        if (textComp.isDesigning()) {
            StiColor color = StiColor.FromArgb((int)0, (StiColor)StiColorEnum.White.color());
            g.drawRectangle(rect, null, (StiBrush)new StiSolidBrush(color), zoom, pageZoom);
        }
        if (!textComp.isDesigning() || textComp.getReport().getIsPageDesigner()) {
            super.paintBackground(textComp, g, rect, zoom, pageZoom);
            return;
        }
    }

    @Override
    public void paintText(StiText textComp, StiGraphics g, StiRectangle rect, Double zoom) {
        StiTextInCells textInCells = (StiTextInCells)textComp;
        double pageZoom = textInCells.getReport().getInfo().getPageZoom();
        if (zoom == null) {
            zoom = textInCells.getPage().getZoom();
        }
        if (!textComp.isDesigning() || textComp.getReport().getIsPageDesigner()) {
            super.paintText(textComp, g, rect, zoom);
            return;
        }
        boolean isExporting = textInCells.getReport().getInfo().isExporting();
        textInCells.getReport().getInfo().setExporting(false);
        double borderSize = textInCells.getBorder().getSize() / 2.0 * zoom;
        g.setTransformedClip(rect);
        String text = textInCells.getTextForPaint();
        StiUnit unit = textInCells.getPage().getUnit();
        double horSpacing = unit.ConvertToHInches((double)textInCells.getHorSpacing() * zoom);
        double vertSpacing = unit.ConvertToHInches((double)textInCells.getVertSpacing() * zoom);
        double cellWidth = unit.ConvertToHInches((double)textInCells.getCellWidth() * zoom);
        double cellHeight = unit.ConvertToHInches((double)textInCells.getCellHeight() * zoom);
        if (textInCells.getCellWidth() == 0.0f) {
            cellWidth = textInCells.getFont().getHeight() * 1.5 * zoom * StiDpiHelper.DeviceCapsScale();
        }
        if (textInCells.getCellHeight() == 0.0f) {
            cellHeight = textInCells.getFont().getHeight() * 1.5 * zoom * StiDpiHelper.DeviceCapsScale();
        }
        double fontSize = textInCells.getFont().getSize() * zoom * StiDpiHelper.DeviceCapsScale();
        StringFormat sf = new StringFormat();
        StiFont font = textInCells.getFont();
        sf.LineAlignment = StiStringAlignment.Center;
        sf.Alignment = StiStringAlignment.Center;
        if (!textInCells.getContinuousText()) {
            StiSize textSize = new StiSize(1, 1);
            double posX = rect.x + borderSize + cellWidth;
            while (posX + horSpacing + cellWidth < rect.getRight()) {
                posX += horSpacing + cellWidth;
                textSize.width += 1.0;
            }
            double posY = rect.y + borderSize + cellHeight;
            while (posY + vertSpacing + cellHeight < rect.getBottom()) {
                posY += vertSpacing + cellHeight;
                textSize.height += 1.0;
            }
            if (!textInCells.getWordWrap()) {
                textSize.height = 1.0;
            }
            ArrayList<String> stringList = new ArrayList<String>();
            String st = "";
            if (text == null) {
                text = "";
            }
            for (int i = 0; i < text.length(); ++i) {
                char ch = text.charAt(i);
                if (Character.isISOControl(ch)) {
                    if (ch != '\n') continue;
                    stringList.add(StiTextInCellsHelper.TrimEndWhiteSpace(st));
                    st = "";
                    continue;
                }
                st = st + ch;
            }
            if (!"".equals(st)) {
                stringList.add(StiTextInCellsHelper.TrimEndWhiteSpace(st));
            }
            if (stringList.size() == 0) {
                stringList.add(st);
            }
            if (textInCells.getWordWrap()) {
                for (int indexLine = 0; indexLine < stringList.size(); ++indexLine) {
                    String stt = (String)stringList.get(indexLine);
                    if (!((double)stt.length() > textSize.width)) continue;
                    int[] wordarr = new int[stt.length()];
                    int wordCounter = 0;
                    for (int tempIndexSpace = 0; tempIndexSpace < stt.length() && Character.isWhitespace(stt.charAt(tempIndexSpace)); ++tempIndexSpace) {
                        wordarr[tempIndexSpace] = wordCounter;
                    }
                    for (int tempIndex = tempIndexSpace; tempIndex < stt.length(); ++tempIndex) {
                        if (Character.isWhitespace(stt.charAt(tempIndex))) {
                            // empty if block
                        }
                        wordarr[tempIndex] = ++wordCounter;
                    }
                    int index = (int)textSize.width;
                    int index2 = index - 1;
                    if (wordarr[index] > 0) {
                        if (wordarr[index] != wordarr[index2]) {
                            while (Character.isWhitespace(stt.charAt(index))) {
                                ++index;
                            }
                        } else {
                            while (!Character.isWhitespace(stt.charAt(index))) {
                                --index;
                            }
                            index2 = index++;
                            while (Character.isWhitespace(stt.charAt(index2))) {
                                --index2;
                            }
                        }
                    }
                    stringList.set(indexLine, stt.substring(0, index2 + 1));
                    stringList.add(indexLine + 1, stt.substring(index, stt.length()));
                }
            }
            posY = rect.y + borderSize;
            int indexY = 0;
            while ((double)indexY < textSize.height) {
                String currentLineText = indexY < stringList.size() ? (String)stringList.get(indexY) : "";
                int textOffset = 0;
                if (textInCells.getHorAlignment() == StiTextHorAlignment.Center) {
                    textOffset = (int)(textSize.width - (double)currentLineText.length()) / 2;
                }
                if (textInCells.getHorAlignment() == StiTextHorAlignment.Right) {
                    textOffset = (int)(textSize.width - (double)currentLineText.length());
                }
                if (textOffset > 0) {
                    currentLineText = StiStringUtil.createCopies((char)' ', (int)textOffset) + currentLineText;
                }
                posX = rect.x + borderSize;
                int indexX = 0;
                while ((double)indexX < textSize.width) {
                    StiRectangle cellRect = new StiRectangle(posX, posY, cellWidth, cellHeight);
                    StiBrush backBrush = StiBrush.getBrush((StiBrush)textInCells.getBrush(), (StiRectangle)cellRect);
                    g.drawRectangle(cellRect, null, backBrush, zoom, Double.valueOf(pageZoom));
                    int indexText = (int)(textInCells.getRightToLeft() ? textSize.width - (double)indexX - 1.0 : (double)indexX);
                    if (indexText < currentLineText.length()) {
                        StiBrush brush = StiBrush.getBrush((StiBrush)textInCells.getTextBrush(), (StiRectangle)cellRect);
                        g.drawText(StiStringUtil.createCopies((char)currentLineText.charAt(indexText), (int)1), cellRect, font, brush, sf.getHorAlignment(), sf.getVertsAlignment(), Boolean.valueOf(false), zoom, StiPenStyle.Solid, null, null);
                    }
                    super.paintBorder(textInCells, g, cellRect.clone(), false, false, zoom);
                    posX += cellWidth + horSpacing;
                    ++indexX;
                }
                posY += cellHeight + vertSpacing;
                ++indexY;
            }
        } else {
            double posX = rect.x + borderSize;
            double posY = rect.y + borderSize;
            boolean first = true;
            int index = 0;
            while (true) {
                StiRectangle cellRect;
                if ((cellRect = new StiRectangle(posX, posY, cellWidth, cellHeight)).getRight() + horSpacing < rect.getRight() || first) {
                    StiBrush backBrush = StiBrush.getBrush((StiBrush)textInCells.getBrush(), (StiRectangle)cellRect);
                    g.drawRectangle(cellRect, null, backBrush, zoom, Double.valueOf(pageZoom));
                    if (text != null && index < text.length()) {
                        StiBrush brush = StiBrush.getBrush((StiBrush)textInCells.getTextBrush(), (StiRectangle)cellRect);
                        g.drawText(StiStringUtil.createCopies((char)text.charAt(index), (int)1), cellRect, font, brush, sf.getHorAlignment(), sf.getVertsAlignment(), Boolean.valueOf(false), zoom, StiPenStyle.Solid, null, null);
                    }
                    super.paintBorder(textInCells, g, cellRect.clone(), false, false, zoom);
                    posX += cellWidth + horSpacing;
                    ++index;
                    first = false;
                    continue;
                }
                posX = rect.x + borderSize;
                first = true;
                if (!textInCells.getWordWrap() || rect.getBottom() < (posY += cellHeight + vertSpacing) + cellHeight + vertSpacing) break;
            }
        }
        g.restoreClip();
        textInCells.getReport().getInfo().setExporting(isExporting);
    }
}

