/*
 * Decompiled with CFR 0.152.
 */
package com.stimulsoft.report.styles;

import com.stimulsoft.base.StiEnumSet;
import com.stimulsoft.base.StiJsonReportObjectHelper;
import com.stimulsoft.base.StiJsonSaveMode;
import com.stimulsoft.base.drawing.StiBorder;
import com.stimulsoft.base.drawing.StiBrush;
import com.stimulsoft.base.drawing.StiColor;
import com.stimulsoft.base.drawing.StiSolidBrush;
import com.stimulsoft.base.drawing.StiTextOptions;
import com.stimulsoft.base.drawing.enums.StiHorAlignment;
import com.stimulsoft.base.drawing.enums.StiTextHorAlignment;
import com.stimulsoft.base.drawing.enums.StiVertAlignment;
import com.stimulsoft.base.json.JProperty;
import com.stimulsoft.base.json.JSONException;
import com.stimulsoft.base.json.JSONObject;
import com.stimulsoft.base.serializing.annotations.StiDefaulValue;
import com.stimulsoft.base.serializing.annotations.StiSerializable;
import com.stimulsoft.base.system.StiFont;
import com.stimulsoft.report.StiOptions;
import com.stimulsoft.report.StiReport;
import com.stimulsoft.report.chart.StiChart;
import com.stimulsoft.report.components.StiComponent;
import com.stimulsoft.report.components.interfaces.IStiBackColor;
import com.stimulsoft.report.components.interfaces.IStiBorder;
import com.stimulsoft.report.components.interfaces.IStiBrush;
import com.stimulsoft.report.components.interfaces.IStiFont;
import com.stimulsoft.report.components.interfaces.IStiForeColor;
import com.stimulsoft.report.components.interfaces.IStiHorAlignment;
import com.stimulsoft.report.components.interfaces.IStiTextBrush;
import com.stimulsoft.report.components.interfaces.IStiTextHorAlignment;
import com.stimulsoft.report.components.interfaces.IStiVertAlignment;
import com.stimulsoft.report.components.simplecomponents.StiImage;
import com.stimulsoft.report.components.simplecomponents.StiLinePrimitive;
import com.stimulsoft.report.crossTab.StiCrossTab;
import com.stimulsoft.report.enums.StiStyleElements;
import com.stimulsoft.report.styles.StiBaseStyle;
import com.stimulsoft.report.styles.StiStylesHelper;
import com.stimulsoft.report.styles.conditions.StiStyleConditionsCollection;
import com.stimulsoft.report.styles.enums.StiStyleCode;

public class StiStyle
extends StiBaseStyle {
    private StiTextHorAlignment horAlignment = StiTextHorAlignment.Left;
    private StiVertAlignment vertAlignment = StiVertAlignment.Top;
    private StiFont font = new StiFont("Arial", 8.0);
    private StiBorder border = new StiBorder();
    private StiBrush brush = new StiSolidBrush(StiColor.Transparent);
    private StiBrush textBrush = new StiSolidBrush(StiColor.Black);
    private StiTextOptions textOptions = new StiTextOptions();
    private boolean allowUseHorAlignment;
    private boolean allowUseVertAlignment;
    private boolean allowUseImage;
    private boolean allowUseFont = true;
    private boolean allowUseBorderFormatting = true;
    private boolean allowUseborderSidesFromLocation;
    private boolean allowUseBorderSides = true;
    private boolean allowUseBrush = true;
    private boolean allowUseTextBrush = true;
    private boolean allowUseTextOptions = true;
    private StiStyleCode styleCode = StiStyleCode.None;
    private StiImage image;

    public StiStyle(String name, String description, StiReport report) {
        super(name, description, report);
    }

    public StiStyle(String name, String description) {
        this(name, description, null);
    }

    public StiStyle(String name) {
        this(name, "");
    }

    public StiStyle() {
        this("");
    }

    @Override
    public Object clone() {
        StiStyle style = new StiStyle();
        style.setAllowUseBorderFormatting(this.allowUseBorderFormatting);
        style.setAllowUseBorderSides(this.allowUseBorderSides);
        style.setAllowUseborderSidesFromLocation(this.allowUseborderSidesFromLocation);
        style.setAllowUseBrush(this.allowUseBrush);
        style.setAllowUseFont(this.allowUseFont);
        style.setAllowUseHorAlignment(this.allowUseHorAlignment);
        style.setAllowUseImage(this.allowUseImage);
        style.setAllowUseTextBrush(this.allowUseTextBrush);
        style.setAllowUseTextOptions(this.allowUseTextOptions);
        style.setAllowUseVertAlignment(this.allowUseVertAlignment);
        style.setBorder((StiBorder)this.getBorder().clone());
        style.setBrush((StiBrush)this.getBrush().clone());
        style.setCollectionName(this.getCollectionName());
        style.setConditions((StiStyleConditionsCollection)this.getConditions().clone());
        style.setDescription(this.getDescription());
        style.setFont((StiFont)this.getFont().clone());
        style.setHorAlignment(this.getHorAlignment());
        style.setImage(this.getImage());
        style.setName(this.getName());
        style.setStyleCode(this.getStyleCode());
        style.setTextBrush((StiBrush)this.getTextBrush().clone());
        style.setTextOptions((StiTextOptions)this.getTextOptions().clone());
        style.setVertAlignment(this.getVertAlignment());
        return style;
    }

    @StiDefaulValue(value="Left")
    @StiSerializable(shortName="ha")
    public StiTextHorAlignment getHorAlignment() {
        return this.horAlignment;
    }

    public void setHorAlignment(StiTextHorAlignment value) {
        this.horAlignment = value;
    }

    @StiDefaulValue(value="Top")
    @StiSerializable(shortName="va")
    public StiVertAlignment getVertAlignment() {
        return this.vertAlignment;
    }

    public void setVertAlignment(StiVertAlignment value) {
        this.vertAlignment = value;
    }

    @StiSerializable(shortName="fn")
    public final StiFont getFont() {
        return this.font;
    }

    public final void setFont(StiFont value) {
        this.font = value;
    }

    @StiSerializable(shortName="br")
    public final StiBorder getBorder() {
        return this.border;
    }

    public final void setBorder(StiBorder value) {
        this.border = value;
    }

    @StiSerializable(shortName="bh")
    public final StiBrush getBrush() {
        return this.brush;
    }

    public final void setBrush(StiBrush value) {
        this.brush = value;
    }

    @StiSerializable(shortName="tb")
    public final StiBrush getTextBrush() {
        return this.textBrush;
    }

    public final void setTextBrush(StiBrush value) {
        this.textBrush = value;
    }

    public final StiTextOptions getTextOptions() {
        return this.textOptions;
    }

    public final void setTextOptions(StiTextOptions value) {
        this.textOptions = value;
    }

    @StiDefaulValue(value="false")
    @StiSerializable
    public final boolean getAllowUseHorAlignment() {
        return this.allowUseHorAlignment;
    }

    public final void setAllowUseHorAlignment(boolean value) {
        this.allowUseHorAlignment = value;
    }

    @StiDefaulValue(value="false")
    @StiSerializable
    public final boolean getAllowUseVertAlignment() {
        return this.allowUseVertAlignment;
    }

    public final void setAllowUseVertAlignment(boolean value) {
        this.allowUseVertAlignment = value;
    }

    @StiDefaulValue(value="false")
    @StiSerializable
    public final boolean getAllowUseImage() {
        return this.allowUseImage;
    }

    public final void setAllowUseImage(boolean value) {
        this.allowUseImage = value;
    }

    @StiDefaulValue(value="true")
    @StiSerializable
    public final boolean getAllowUseFont() {
        return this.allowUseFont;
    }

    public final void setAllowUseFont(boolean value) {
        this.allowUseFont = value;
    }

    @StiDefaulValue(value="true")
    @StiSerializable
    public final boolean getAllowUseBorderFormatting() {
        return this.allowUseBorderFormatting;
    }

    public final void setAllowUseBorderFormatting(boolean value) {
        this.allowUseBorderFormatting = value;
    }

    public void setAllowUseborderSidesFromLocation(boolean allowUseborderSidesFromLocation) {
        this.allowUseborderSidesFromLocation = allowUseborderSidesFromLocation;
    }

    @StiSerializable
    public boolean getAllowUseborderSidesFromLocation() {
        return this.allowUseborderSidesFromLocation;
    }

    @StiDefaulValue(value="true")
    @StiSerializable
    public final boolean getAllowUseBorderSides() {
        return this.allowUseBorderSides;
    }

    public final void setAllowUseBorderSides(boolean value) {
        this.allowUseBorderSides = value;
    }

    @StiDefaulValue(value="true")
    @StiSerializable
    public final boolean getAllowUseBrush() {
        return this.allowUseBrush;
    }

    public final void setAllowUseBrush(boolean value) {
        this.allowUseBrush = value;
    }

    @StiDefaulValue(value="true")
    @StiSerializable
    public final boolean getAllowUseTextBrush() {
        return this.allowUseTextBrush;
    }

    public final void setAllowUseTextBrush(boolean value) {
        this.allowUseTextBrush = value;
    }

    @StiDefaulValue(value="true")
    @StiSerializable
    public final boolean getAllowUseTextOptions() {
        return this.allowUseTextOptions;
    }

    public final void setAllowUseTextOptions(boolean value) {
        this.allowUseTextOptions = value;
    }

    @Override
    public void GetStyleFromComponent(StiComponent component, StiStyleElements styleElements) {
        this.GetStyleFromComponent(component, styleElements, null);
    }

    public final void GetStyleFromComponent(StiComponent component, StiStyleElements styleElements, StiBaseStyle componentStyle) {
        StiLinePrimitive primitive;
        Object cmp;
        boolean useComponentStyleProperty;
        StiStyle compStyle = (StiStyle)(componentStyle instanceof StiStyle ? componentStyle : null);
        this.allowUseBorderFormatting = false;
        this.allowUseBorderSides = false;
        this.allowUseborderSidesFromLocation = false;
        this.allowUseBrush = false;
        this.allowUseTextBrush = false;
        this.allowUseFont = false;
        this.allowUseHorAlignment = false;
        this.allowUseVertAlignment = false;
        boolean bl = useComponentStyleProperty = !StiOptions.Engine.getUseParentStylesOldMode();
        if (compStyle == null) {
            useComponentStyleProperty = false;
        }
        if ((styleElements.getValue() & StiStyleElements.Font.getValue()) > 0) {
            if (component instanceof IStiFont) {
                cmp = (IStiFont)((Object)(component instanceof IStiFont ? component : null));
                Object tempVar = cmp.getFont().clone();
                this.setFont((StiFont)(tempVar instanceof StiFont ? tempVar : null));
                this.setAllowUseFont(true);
            } else if (useComponentStyleProperty) {
                Object tempVar2 = compStyle.getFont().clone();
                this.setFont((StiFont)(tempVar2 instanceof StiFont ? tempVar2 : null));
                this.setAllowUseFont(true);
            }
        }
        if ((styleElements.getValue() & StiStyleElements.Border.getValue()) > 0) {
            if (component instanceof IStiBorder) {
                cmp = (IStiBorder)((Object)(component instanceof IStiBorder ? component : null));
                Object tempVar3 = cmp.getBorder().clone();
                this.setBorder((StiBorder)(tempVar3 instanceof StiBorder ? tempVar3 : null));
                this.setAllowUseBorderFormatting(true);
                this.setAllowUseBorderSides(true);
            } else if (useComponentStyleProperty) {
                Object tempVar4 = compStyle.getBorder().clone();
                this.setBorder((StiBorder)(tempVar4 instanceof StiBorder ? tempVar4 : null));
                this.allowUseBorderFormatting = true;
                this.allowUseBorderSides = true;
            }
        }
        if ((styleElements.getValue() & StiStyleElements.Brush.getValue()) > 0) {
            if (component instanceof IStiBrush) {
                cmp = (IStiBrush)((Object)component);
                Object tempVar5 = cmp.getBrush().clone();
                this.setBrush((StiBrush)(tempVar5 instanceof StiBrush ? tempVar5 : null));
                this.setAllowUseBrush(true);
            } else if (useComponentStyleProperty) {
                Object tempVar6 = compStyle.getBrush().clone();
                this.setBrush((StiBrush)(tempVar6 instanceof StiBrush ? tempVar6 : null));
                this.setAllowUseBrush(true);
            }
        }
        if ((styleElements.getValue() & StiStyleElements.TextBrush.getValue()) > 0) {
            if (component instanceof IStiTextBrush) {
                cmp = (IStiTextBrush)((Object)component);
                Object tempVar7 = cmp.getTextBrush().clone();
                this.setTextBrush((StiBrush)(tempVar7 instanceof StiBrush ? tempVar7 : null));
                this.setAllowUseTextBrush(true);
            } else if (useComponentStyleProperty) {
                Object tempVar8 = compStyle.getTextBrush().clone();
                this.setTextBrush((StiBrush)(tempVar8 instanceof StiBrush ? tempVar8 : null));
                this.setAllowUseTextBrush(true);
            }
        }
        if (component instanceof IStiBackColor && (styleElements.getValue() & StiStyleElements.Brush.getValue()) > 0) {
            cmp = (IStiBackColor)((Object)component);
            this.setBrush((StiBrush)new StiSolidBrush(cmp.getBackColor().clone()));
            this.setAllowUseBrush(true);
        }
        if (component instanceof IStiForeColor && (styleElements.getValue() & StiStyleElements.TextBrush.getValue()) > 0) {
            cmp = (IStiForeColor)((Object)component);
            this.setTextBrush((StiBrush)new StiSolidBrush(cmp.getForeColor().clone()));
            this.setAllowUseTextBrush(true);
        }
        if ((styleElements.getValue() & StiStyleElements.HorAlignment.getValue()) > 0) {
            if (component instanceof IStiTextHorAlignment) {
                cmp = (IStiTextHorAlignment)((Object)component);
                this.setHorAlignment(cmp.getHorAlignment());
                this.setAllowUseHorAlignment(true);
            } else if (useComponentStyleProperty) {
                this.setHorAlignment(compStyle.getHorAlignment());
                this.setAllowUseHorAlignment(true);
            }
        }
        if (component instanceof IStiHorAlignment && (styleElements.getValue() & StiStyleElements.HorAlignment.getValue()) > 0) {
            cmp = (IStiHorAlignment)((Object)component);
            switch (cmp.getHorAlignment()) {
                case Center: {
                    this.setHorAlignment(StiTextHorAlignment.Center);
                    break;
                }
                case Left: {
                    this.setHorAlignment(StiTextHorAlignment.Left);
                    break;
                }
                case Right: {
                    this.setHorAlignment(StiTextHorAlignment.Right);
                }
            }
            this.setAllowUseHorAlignment(true);
        }
        if ((styleElements.getValue() & StiStyleElements.VertAlignment.getValue()) > 0) {
            if (component instanceof IStiVertAlignment) {
                cmp = (IStiVertAlignment)((Object)(component instanceof IStiVertAlignment ? component : null));
                this.setVertAlignment(cmp.getVertAlignment());
                this.setAllowUseVertAlignment(true);
            } else if (useComponentStyleProperty) {
                this.setVertAlignment(compStyle.getVertAlignment());
                this.setAllowUseVertAlignment(true);
            }
        }
        if ((primitive = (StiLinePrimitive)(component instanceof StiLinePrimitive ? component : null)) != null) {
            this.setBorder(new StiBorder(this.getBorder().getSide(), primitive.getColor(), primitive.getSize(), primitive.getStyle()));
            this.setAllowUseBorderFormatting(true);
            this.setAllowUseBorderSides(true);
        }
    }

    @Override
    public void SetStyleToComponent(StiComponent component) {
        StiLinePrimitive primitive;
        Object cmp;
        if (component instanceof StiChart) {
            return;
        }
        if (component instanceof StiCrossTab) {
            return;
        }
        if (component instanceof IStiFont && this.getAllowUseFont()) {
            cmp = (IStiFont)((Object)(component instanceof IStiFont ? component : null));
            Object tempVar = this.getFont().clone();
            cmp.setFont((StiFont)(tempVar instanceof StiFont ? tempVar : null));
        }
        if (component instanceof IStiBorder && (this.getAllowUseBorderFormatting() || this.getAllowUseBorderSides())) {
            cmp = (IStiBorder)((Object)(component instanceof IStiBorder ? component : null));
            StiEnumSet sides = cmp.getBorder().getSide();
            if (this.getAllowUseBorderFormatting()) {
                Object tempVar2 = this.getBorder().clone();
                cmp.setBorder((StiBorder)(tempVar2 instanceof StiBorder ? tempVar2 : null));
                cmp.getBorder().setSide(sides);
            }
            if (this.getAllowUseBorderSides()) {
                cmp.getBorder().side = this.allowUseborderSidesFromLocation && component.parent != null ? StiStylesHelper.getBorderSidesFromLocation(component) : this.border.side;
                cmp.getBorder().setSide(this.getBorder().getSide());
            }
        }
        if (component instanceof IStiBrush && this.getAllowUseBrush()) {
            cmp = (IStiBrush)((Object)(component instanceof IStiBrush ? component : null));
            Object tempVar3 = this.getBrush().clone();
            cmp.setBrush((StiBrush)(tempVar3 instanceof StiBrush ? tempVar3 : null));
        }
        if (component instanceof IStiTextBrush && this.getAllowUseTextBrush()) {
            cmp = (IStiTextBrush)((Object)(component instanceof IStiTextBrush ? component : null));
            Object tempVar4 = this.getTextBrush().clone();
            cmp.setTextBrush((StiBrush)(tempVar4 instanceof StiBrush ? tempVar4 : null));
        }
        if (component instanceof IStiBackColor && this.getAllowUseBrush()) {
            cmp = (IStiBackColor)((Object)(component instanceof IStiBackColor ? component : null));
            cmp.setBackColor(StiBrush.ToColor((StiBrush)this.getBrush()));
        }
        if (component instanceof IStiForeColor && this.getAllowUseTextBrush()) {
            cmp = (IStiForeColor)((Object)(component instanceof IStiForeColor ? component : null));
            cmp.setForeColor(StiBrush.ToColor((StiBrush)this.getTextBrush()));
        }
        if (component instanceof IStiTextHorAlignment && this.getAllowUseHorAlignment()) {
            cmp = (IStiTextHorAlignment)((Object)(component instanceof IStiTextHorAlignment ? component : null));
            cmp.setHorAlignment(this.getHorAlignment());
        }
        if (component instanceof IStiHorAlignment && this.getAllowUseHorAlignment()) {
            cmp = (IStiHorAlignment)((Object)(component instanceof IStiHorAlignment ? component : null));
            switch (this.getHorAlignment()) {
                case Center: {
                    cmp.setHorAlignment(StiHorAlignment.Center);
                    break;
                }
                case Left: {
                    cmp.setHorAlignment(StiHorAlignment.Left);
                    break;
                }
                case Right: {
                    cmp.setHorAlignment(StiHorAlignment.Right);
                    break;
                }
            }
        }
        if (component instanceof IStiVertAlignment && this.getAllowUseVertAlignment()) {
            cmp = (IStiVertAlignment)((Object)(component instanceof IStiVertAlignment ? component : null));
            cmp.setVertAlignment(this.getVertAlignment());
        }
        if (component instanceof StiImage && this.getAllowUseImage()) {
            cmp = (StiImage)(component instanceof StiImage ? component : null);
            ((StiImage)cmp).setImage(this.getImage());
        }
        if ((primitive = (StiLinePrimitive)(component instanceof StiLinePrimitive ? component : null)) != null && this.getAllowUseBorderFormatting()) {
            primitive.setColor(this.getBorder().getColor());
            primitive.setSize((float)this.getBorder().getSize());
            primitive.setStyle(this.getBorder().getStyle());
        }
    }

    @StiDefaulValue(value="None")
    @StiSerializable
    public final StiStyleCode getStyleCode() {
        return this.styleCode;
    }

    public final void setStyleCode(StiStyleCode value) {
        this.styleCode = value;
    }

    @StiSerializable
    public final StiImage getImage() {
        return this.image;
    }

    public final void setImage(StiImage value) {
        if (this.image != value) {
            this.image = value;
        }
    }

    @Override
    public JSONObject SaveToJsonObject(StiJsonSaveMode mode) throws JSONException {
        JSONObject jObject = super.SaveToJsonObject(mode);
        jObject.AddPropertyEnum("HorAlignment", (Enum)this.getHorAlignment(), (Enum)StiTextHorAlignment.Left);
        jObject.AddPropertyEnum("VertAlignment", (Enum)this.getVertAlignment(), (Enum)StiVertAlignment.Top);
        jObject.AddPropertyStringNullOfEmpty("Font", StiJsonReportObjectHelper.Serialize.fontDefault((StiFont)this.getFont()));
        jObject.AddPropertyStringNullOfEmpty("Border", StiJsonReportObjectHelper.Serialize.JBorder((StiBorder)this.getBorder()));
        jObject.AddPropertyStringNullOfEmpty("Brush", StiJsonReportObjectHelper.Serialize.JBrush((StiBrush)this.getBrush()));
        jObject.AddPropertyStringNullOfEmpty("TextBrush", StiJsonReportObjectHelper.Serialize.JBrush((StiBrush)this.getTextBrush()));
        jObject.AddPropertyBool("AllowUseHorAlignment", this.getAllowUseHorAlignment());
        jObject.AddPropertyBool("AllowUseVertAlignment", this.getAllowUseVertAlignment());
        jObject.AddPropertyBool("AllowUseImage", this.getAllowUseImage());
        jObject.AddPropertyBool("AllowUseFont", this.getAllowUseFont(), true);
        jObject.AddPropertyBool("AllowUseBorderFormatting", this.getAllowUseBorderFormatting(), true);
        jObject.AddPropertyBool("AllowUseBorderSides", this.getAllowUseBorderSides(), true);
        jObject.AddPropertyBool("AllowUseBorderSidesFromLocation", this.getAllowUseborderSidesFromLocation());
        jObject.AddPropertyBool("AllowUseBrush", this.getAllowUseBrush(), true);
        jObject.AddPropertyBool("AllowUseTextBrush", this.getAllowUseTextBrush(), true);
        jObject.AddPropertyStringNullOfEmpty("Image", this.getImage() != null ? this.getImage().GetImageFromSource() : null);
        return jObject;
    }

    @Override
    public void LoadFromJsonObject(JSONObject jObject) throws JSONException {
        super.LoadFromJsonObject(jObject);
        for (JProperty property : jObject.Properties()) {
            if (property.Name.equals("HorAlignment")) {
                this.horAlignment = StiTextHorAlignment.valueOf((String)((String)property.Value));
                continue;
            }
            if (property.Name.equals("VertAlignment")) {
                this.vertAlignment = StiVertAlignment.valueOf((String)((String)property.Value));
                continue;
            }
            if (property.Name.equals("Font")) {
                this.font = StiJsonReportObjectHelper.Deserialize.Font((JProperty)property, (StiFont)this.font);
                continue;
            }
            if (property.Name.equals("Border")) {
                this.border = StiJsonReportObjectHelper.Deserialize.Border((JProperty)property);
                continue;
            }
            if (property.Name.equals("Brush")) {
                this.brush = StiJsonReportObjectHelper.Deserialize.Brush((JProperty)property);
                continue;
            }
            if (property.Name.equals("TextBrush")) {
                this.textBrush = StiJsonReportObjectHelper.Deserialize.Brush((JProperty)property);
                continue;
            }
            if (property.Name.equals("AllowUseHorAlignment")) {
                this.allowUseHorAlignment = (Boolean)property.Value;
                continue;
            }
            if (property.Name.equals("AllowUseVertAlignment")) {
                this.allowUseVertAlignment = (Boolean)property.Value;
                continue;
            }
            if (property.Name.equals("AllowUseImage")) {
                this.allowUseImage = (Boolean)property.Value;
                continue;
            }
            if (property.Name.equals("AllowUseFont")) {
                this.allowUseFont = (Boolean)property.Value;
                continue;
            }
            if (property.Name.equals("AllowUseBorderFormatting")) {
                this.allowUseBorderFormatting = (Boolean)property.Value;
                continue;
            }
            if (property.Name.equals("AllowUseBorderSides")) {
                this.allowUseBorderSides = (Boolean)property.Value;
                continue;
            }
            if (property.Name.equals("AllowUseBorderSidesFromLocation")) {
                this.allowUseborderSidesFromLocation = (Boolean)property.Value;
                continue;
            }
            if (property.Name.equals("AllowUseBrush")) {
                this.allowUseBrush = (Boolean)property.Value;
                continue;
            }
            if (property.Name.equals("AllowUseTextBrush")) {
                this.allowUseTextBrush = (Boolean)property.Value;
                continue;
            }
            if (!property.Name.equals("Image")) continue;
            this.image = new StiImage((String)property.Value);
        }
    }
}

