/*
 * Decompiled with CFR 0.152.
 */
package com.stimulsoft.report.styles;

import com.stimulsoft.base.IStiEnum;
import com.stimulsoft.base.StiEnumSet;
import com.stimulsoft.base.drawing.StiBorder;
import com.stimulsoft.base.drawing.StiBrush;
import com.stimulsoft.base.drawing.StiColor;
import com.stimulsoft.base.drawing.StiColorEnum;
import com.stimulsoft.base.drawing.StiColorUtils;
import com.stimulsoft.base.drawing.StiSolidBrush;
import com.stimulsoft.base.drawing.enums.StiBorderSides;
import com.stimulsoft.base.drawing.enums.StiPenStyle;
import com.stimulsoft.base.localization.StiLocalization;
import com.stimulsoft.base.system.StiFont;
import com.stimulsoft.base.system.StiFontStyle;
import com.stimulsoft.report.StiReport;
import com.stimulsoft.report.dictionary.StiFunctionsStrings;
import com.stimulsoft.report.styles.StiBaseStyle;
import com.stimulsoft.report.styles.StiStyle;
import com.stimulsoft.report.styles.conditions.elements.StiStyleConditionComponentTypeElement;
import com.stimulsoft.report.styles.conditions.elements.StiStyleConditionElement;
import com.stimulsoft.report.styles.conditions.elements.StiStyleConditionPlacementElement;
import com.stimulsoft.report.styles.conditions.elements.StiStyleConditionPlacementNestedLevelElement;
import com.stimulsoft.report.styles.enums.StiNestedFactor;
import com.stimulsoft.report.styles.enums.StiStyleComponentPlacement;
import com.stimulsoft.report.styles.enums.StiStyleComponentType;
import com.stimulsoft.report.styles.enums.StiStyleConditionOperation;
import java.util.ArrayList;
import java.util.List;

public class StiStylesCreator {
    private StiNestedFactor nestedFactor = StiNestedFactor.Normal;
    private boolean showReportTitles = true;
    private StiReport report;
    private boolean showReportSummaries = true;
    private boolean showPageHeaders = true;
    private boolean showPageFooters = true;
    private boolean showGroupHeaders = true;
    private boolean showGroupFooters = true;
    private boolean showHeaders = true;
    private boolean showDatas = true;
    private boolean showFooters = true;
    private boolean showBorders = false;
    private int maxNestedLevel = 3;

    public StiStylesCreator(StiReport report) {
        this.report = report;
    }

    private float getColorFactor() {
        if (this.nestedFactor == StiNestedFactor.High) {
            return 1.5f;
        }
        if (this.nestedFactor == StiNestedFactor.Normal) {
            return 1.0f;
        }
        return 0.5f;
    }

    public List<StiBaseStyle> createStyles(String collectionName, StiColor baseColor) {
        StiColor foreColor;
        String name;
        StiEnumSet operation;
        String name2;
        StiColor foreColor2;
        if (baseColor.equals(StiColorEnum.Empty.color()) || baseColor.equals(StiColor.fromArgb((int)0, (int)0, (int)0, (int)0))) {
            baseColor = StiColorEnum.White.color();
        }
        float factor = (float)(baseColor.getR() + baseColor.getG() + baseColor.getB()) / 3.0f;
        StiColor borderColor = StiColorUtils.dark((StiColor)baseColor, (int)((byte)(100.0f * this.getColorFactor())));
        StiBorder border = new StiBorder(StiBorderSides.None, borderColor, 1.0, StiPenStyle.Solid);
        StiEnumSet simpleCompTypes = new StiEnumSet((Enum)StiStyleComponentType.Text, (Enum[])new StiStyleComponentType[]{StiStyleComponentType.Image, StiStyleComponentType.Primitive, StiStyleComponentType.CheckBox});
        ArrayList<StiBaseStyle> styles = new ArrayList<StiBaseStyle>();
        if (this.showReportTitles) {
            StiFont reportTitleFont = new StiFont("Arial", 14.0, StiFontStyle.Bold);
            foreColor2 = factor > 150.0f ? StiColorUtils.dark((StiColor)baseColor, (int)200) : baseColor;
            StiSolidBrush reportTitleBrush = new StiSolidBrush(StiColor.Transparent);
            StiSolidBrush reportTitleForeBrush = new StiSolidBrush(foreColor2);
            name2 = StiFunctionsStrings.toProperCase(StiLocalization.getValue((String)"Components", (String)"StiReportTitleBand")).replace(' ', '_');
            String nameTitle1 = String.format("%s_%s1", collectionName, name2);
            this.createStyles(nameTitle1, this.showBorders, reportTitleFont, (StiBrush)reportTitleBrush, (StiBrush)reportTitleForeBrush, border, (StiEnumSet<StiStyleComponentType>)simpleCompTypes, StiStyleComponentPlacement.ReportTitle, 1, (StiEnumSet<StiStyleConditionOperation>)new StiEnumSet((Enum)StiStyleConditionOperation.EqualTo), styles);
            reportTitleFont = new StiFont("Arial", 10.0, StiFontStyle.Bold);
            String nameTitle2 = String.format("%s_%s2", collectionName, name2);
            this.createStyles(nameTitle2, this.showBorders, reportTitleFont, (StiBrush)reportTitleBrush, (StiBrush)reportTitleForeBrush, border, (StiEnumSet<StiStyleComponentType>)simpleCompTypes, StiStyleComponentPlacement.ReportTitle, 2, (StiEnumSet<StiStyleConditionOperation>)new StiEnumSet((Enum)StiStyleConditionOperation.GreaterThanOrEqualTo), styles);
        }
        if (this.showReportSummaries) {
            StiFont reportSummaryFont = new StiFont("Arial", 12.0, StiFontStyle.Bold);
            foreColor2 = factor > 150.0f ? StiColorUtils.dark((StiColor)baseColor, (int)200) : baseColor;
            StiSolidBrush reportSummaryBrush = new StiSolidBrush(StiColor.Transparent);
            StiSolidBrush reportSummaryForeBrush = new StiSolidBrush(foreColor2);
            name2 = StiFunctionsStrings.toProperCase(StiLocalization.getValue((String)"Components", (String)"StiReportSummaryBand")).replace(' ', '_');
            String nameSummary1 = String.format("%s_%s1", collectionName, name2);
            this.createStyles(nameSummary1, this.showBorders, reportSummaryFont, (StiBrush)reportSummaryBrush, (StiBrush)reportSummaryForeBrush, border, (StiEnumSet<StiStyleComponentType>)simpleCompTypes, StiStyleComponentPlacement.ReportSummary, 1, (StiEnumSet<StiStyleConditionOperation>)new StiEnumSet((Enum)StiStyleConditionOperation.EqualTo), styles);
            reportSummaryFont = new StiFont("Arial", 10.0, StiFontStyle.Bold);
            String nameSummary2 = String.format("%s_%s2", collectionName, name2);
            this.createStyles(nameSummary2, this.showBorders, reportSummaryFont, (StiBrush)reportSummaryBrush, (StiBrush)reportSummaryForeBrush, border, (StiEnumSet<StiStyleComponentType>)simpleCompTypes, StiStyleComponentPlacement.ReportSummary, 2, (StiEnumSet<StiStyleConditionOperation>)new StiEnumSet((Enum)StiStyleConditionOperation.GreaterThanOrEqualTo), styles);
        }
        if (this.showPageHeaders) {
            StiFont pageHeadersFont = new StiFont("Arial", 10.0);
            foreColor2 = factor > 150.0f ? StiColorUtils.dark((StiColor)baseColor, (int)200) : baseColor;
            StiSolidBrush pageHeadersBrush = new StiSolidBrush(StiColor.Transparent);
            StiSolidBrush pageHeadersForeBrush = new StiSolidBrush(foreColor2);
            name2 = StiFunctionsStrings.toProperCase(StiLocalization.getValue((String)"Components", (String)"StiPageHeaderBand")).replace(' ', '_');
            name2 = String.format("%s_%s", collectionName, name2);
            this.createStyles(name2, this.showBorders, pageHeadersFont, (StiBrush)pageHeadersBrush, (StiBrush)pageHeadersForeBrush, border, (StiEnumSet<StiStyleComponentType>)simpleCompTypes, StiStyleComponentPlacement.PageHeader, null, (StiEnumSet<StiStyleConditionOperation>)new StiEnumSet(StiStyleConditionOperation.class), styles);
        }
        if (this.showPageFooters) {
            StiFont pageFootersFont = new StiFont("Arial", 10.0);
            foreColor2 = factor > 150.0f ? StiColorUtils.dark((StiColor)baseColor, (int)200) : baseColor;
            StiSolidBrush pageFootersBrush = new StiSolidBrush(StiColor.Transparent);
            StiSolidBrush pageFootersForeBrush = new StiSolidBrush(foreColor2);
            name2 = StiFunctionsStrings.toProperCase(StiLocalization.getValue((String)"Components", (String)"StiPageFooterBand")).replace(' ', '_');
            name2 = String.format("%s_%s", collectionName, name2);
            this.createStyles(name2, this.showBorders, pageFootersFont, (StiBrush)pageFootersBrush, (StiBrush)pageFootersForeBrush, border, (StiEnumSet<StiStyleComponentType>)simpleCompTypes, StiStyleComponentPlacement.PageFooter, null, (StiEnumSet<StiStyleConditionOperation>)new StiEnumSet(StiStyleConditionOperation.class), styles);
        }
        if (this.showGroupHeaders) {
            float fontPerLevel = 4.0f / (float)this.maxNestedLevel;
            foreColor2 = factor > 150.0f ? StiColorUtils.dark((StiColor)baseColor, (int)150) : baseColor;
            StiSolidBrush groupHeaderForeBrush = new StiSolidBrush(foreColor2);
            for (int index = 1; index <= this.maxNestedLevel; ++index) {
                int fontFactor = (int)(fontPerLevel * (float)(index - 1));
                StiFont groupHeaderFont = new StiFont("Arial", (double)(13 - fontFactor), StiFontStyle.Bold);
                StiSolidBrush groupHeaderBrush = new StiSolidBrush(StiColor.Transparent);
                operation = new StiEnumSet((Enum)(index == this.maxNestedLevel ? StiStyleConditionOperation.GreaterThanOrEqualTo : StiStyleConditionOperation.EqualTo));
                name = StiFunctionsStrings.toProperCase(StiLocalization.getValue((String)"Components", (String)"StiGroupHeaderBand")).replace(' ', '_');
                name = String.format("%s_%s%s", collectionName, name, index);
                this.createStyles(name, this.showBorders, groupHeaderFont, (StiBrush)groupHeaderBrush, (StiBrush)groupHeaderForeBrush, border, (StiEnumSet<StiStyleComponentType>)simpleCompTypes, StiStyleComponentPlacement.GroupHeader, index, (StiEnumSet<StiStyleConditionOperation>)operation, styles);
            }
        }
        if (this.showGroupFooters) {
            float fontPerLevel = 4.0f / (float)this.maxNestedLevel;
            foreColor2 = factor > 150.0f ? StiColorUtils.dark((StiColor)baseColor, (int)150) : baseColor;
            StiSolidBrush groupFooterForeBrush = new StiSolidBrush(foreColor2);
            for (int index = 1; index <= this.maxNestedLevel; ++index) {
                int fontFactor = (int)(fontPerLevel * (float)(index - 1));
                StiFont groupFooterFont = new StiFont("Arial", (double)(13 - fontFactor), StiFontStyle.Bold);
                StiSolidBrush groupFooterBrush = new StiSolidBrush(StiColor.Transparent);
                operation = new StiEnumSet((Enum)(index == 0 ? StiStyleConditionOperation.GreaterThanOrEqualTo : StiStyleConditionOperation.EqualTo));
                name = StiFunctionsStrings.toProperCase(StiLocalization.getValue((String)"Components", (String)"StiGroupFooterBand")).replace(' ', '_');
                name = String.format("%s_%s%s", collectionName, name, index);
                this.createStyles(name, this.showBorders, groupFooterFont, (StiBrush)groupFooterBrush, (StiBrush)groupFooterForeBrush, border, (StiEnumSet<StiStyleComponentType>)simpleCompTypes, StiStyleComponentPlacement.GroupFooter, index, (StiEnumSet<StiStyleConditionOperation>)operation, styles);
            }
        }
        if (this.showHeaders) {
            float colorPerLevel = 100 / this.maxNestedLevel;
            StiFont headerFont = new StiFont("Arial", 8.0, StiFontStyle.Bold);
            foreColor = StiColorUtils.dark((StiColor)baseColor, (int)-56);
            StiSolidBrush headerForeBrush = new StiSolidBrush(foreColor);
            border.setTopmost(true);
            for (int index = 1; index <= this.maxNestedLevel; ++index) {
                int colorFactor = (int)(colorPerLevel * (float)(index - 1) * this.getColorFactor());
                if (colorFactor > 255) {
                    colorFactor = 255;
                }
                StiSolidBrush headerBrush = new StiSolidBrush(StiColorUtils.light((StiColor)baseColor, (int)((byte)colorFactor)));
                operation = new StiEnumSet((Enum)(index == this.maxNestedLevel ? StiStyleConditionOperation.GreaterThanOrEqualTo : StiStyleConditionOperation.EqualTo));
                name = StiFunctionsStrings.toProperCase(StiLocalization.getValue((String)"Components", (String)"StiHeaderBand")).replace(' ', '_');
                name = String.format("%s_%s%s", collectionName, name, index);
                this.createStyles(name, this.showBorders, headerFont, (StiBrush)headerBrush, (StiBrush)headerForeBrush, border, (StiEnumSet<StiStyleComponentType>)simpleCompTypes, StiStyleComponentPlacement.Header, index, (StiEnumSet<StiStyleConditionOperation>)operation, styles);
            }
        }
        if (this.showDatas) {
            float colorPerLevel = 60 / this.maxNestedLevel;
            StiFont dataFont = new StiFont("Arial", 8.0);
            foreColor = StiColorUtils.dark((StiColor)baseColor, (int)-56);
            StiSolidBrush dataForeBrush = new StiSolidBrush(foreColor);
            for (int index = 1; index <= this.maxNestedLevel; ++index) {
                int colorFactor = (int)((150.0f + colorPerLevel * (float)(index - 1)) * this.getColorFactor());
                if (colorFactor > 255) {
                    colorFactor = 255;
                }
                StiSolidBrush dataBrush = new StiSolidBrush(StiColorUtils.light((StiColor)baseColor, (int)((byte)colorFactor)));
                StiSolidBrush dataBrushEven = new StiSolidBrush(StiColorUtils.light((StiColor)baseColor, (int)((byte)((double)colorFactor * 0.5))));
                StiEnumSet operation2 = new StiEnumSet((Enum)(index == this.maxNestedLevel ? StiStyleConditionOperation.GreaterThanOrEqualTo : StiStyleConditionOperation.EqualTo));
                String name3 = StiFunctionsStrings.toProperCase(StiLocalization.getValue((String)"Components", (String)"StiDataBand")).replace(' ', '_');
                name3 = String.format("%s_%s%s", collectionName, name3, index);
                this.createStyles(name3, this.showBorders, dataFont, (StiBrush)new StiSolidBrush(StiColor.Transparent), (StiBrush)dataForeBrush, border, (StiEnumSet<StiStyleComponentType>)simpleCompTypes, StiStyleComponentPlacement.Data, index, (StiEnumSet<StiStyleConditionOperation>)operation2, styles);
                name3 = StiFunctionsStrings.toProperCase(StiLocalization.getValue((String)"Components", (String)"StiDataBand")).replace(' ', '_');
                String odd = StiLocalization.getValue((String)"PropertyMain", (String)"OddStyle");
                name3 = String.format("%s_%s%s_%s", collectionName, name3, index, odd);
                this.createStyles(name3, this.showBorders, dataFont, (StiBrush)dataBrush, (StiBrush)dataForeBrush, border, null, StiStyleComponentPlacement.DataOddStyle, index, (StiEnumSet<StiStyleConditionOperation>)operation2, styles);
                name3 = StiFunctionsStrings.toProperCase(StiLocalization.getValue((String)"Components", (String)"StiDataBand")).replace(' ', '_');
                String even = StiLocalization.getValue((String)"PropertyMain", (String)"EvenStyle");
                name3 = String.format("%s_%s%s_%s", collectionName, name3, index, even);
                this.createStyles(name3, this.showBorders, dataFont, (StiBrush)dataBrushEven, (StiBrush)dataForeBrush, border, null, StiStyleComponentPlacement.DataEvenStyle, index, (StiEnumSet<StiStyleConditionOperation>)operation2, styles);
            }
        }
        if (this.showFooters) {
            float colorPerLevel = 100 / this.maxNestedLevel;
            StiFont footerFont = new StiFont("Arial", 8.0);
            foreColor = StiColorUtils.dark((StiColor)baseColor, (int)-56);
            StiSolidBrush footerForeBrush = new StiSolidBrush(foreColor);
            for (int index = 1; index <= this.maxNestedLevel; ++index) {
                int colorFactor = (int)((colorPerLevel * (float)(index - 1) + 20.0f) * this.getColorFactor());
                if (colorFactor > 255) {
                    colorFactor = 255;
                }
                StiSolidBrush footerBrush = new StiSolidBrush(StiColorUtils.light((StiColor)baseColor, (int)((byte)colorFactor)));
                operation = new StiEnumSet((Enum)(index == 0 ? StiStyleConditionOperation.GreaterThanOrEqualTo : StiStyleConditionOperation.EqualTo));
                name = StiFunctionsStrings.toProperCase(StiLocalization.getValue((String)"Components", (String)"StiFooterBand")).replace(' ', '_');
                name = String.format("%s_%s%s", collectionName, name, index);
                this.createStyles(name, this.showBorders, footerFont, (StiBrush)footerBrush, (StiBrush)footerForeBrush, border, (StiEnumSet<StiStyleComponentType>)simpleCompTypes, StiStyleComponentPlacement.Footer, index, (StiEnumSet<StiStyleConditionOperation>)operation, styles);
            }
        }
        for (StiBaseStyle style : styles) {
            style.setCollectionName(collectionName);
        }
        return styles;
    }

    private List<StiBaseStyle> createStyles(String name, boolean showBorders, StiFont font, StiBrush headerBrush1, StiBrush headerForeBrush, StiBorder border, StiEnumSet<StiStyleComponentType> simpleCompTypes, StiStyleComponentPlacement placement, Integer placementNestedLevel, StiEnumSet<StiStyleConditionOperation> operation, List<StiBaseStyle> styles) {
        List<StiBaseStyle> headerStyles = this.createStyles(name, font, headerBrush1, headerForeBrush, border, (StiEnumSet<StiStyleComponentPlacement>)StiEnumSet.of((Enum)placement), placementNestedLevel, operation, simpleCompTypes, showBorders);
        for (StiBaseStyle style : headerStyles) {
            styles.add(style);
        }
        return headerStyles;
    }

    private List<StiBaseStyle> createStyles(String name, StiFont font, StiBrush brush, StiBrush textBrush, StiBorder border, StiEnumSet<StiStyleComponentPlacement> placement, Integer placementNestedLevel, StiEnumSet<StiStyleConditionOperation> placementNestedLevelOperation, StiEnumSet<StiStyleComponentType> componentType, boolean showBorders) {
        ArrayList<StiBaseStyle> styles = new ArrayList<StiBaseStyle>();
        border = new StiBorder(new StiEnumSet((Enum)StiBorderSides.None), border.getColor(), border.getSize(), border.getStyle(), border.getDropShadow(), border.getShadowSize(), border.getShadowBrush(), border.getTopmost());
        StiStyle style = this.createStyle(name, font, brush, textBrush, border, placement, placementNestedLevel, placementNestedLevelOperation, componentType);
        if (placement.containsOnly((IStiEnum)StiStyleComponentPlacement.ReportTitle) || placement.containsOnly((IStiEnum)StiStyleComponentPlacement.ReportSummary) || placement.containsOnly((IStiEnum)StiStyleComponentPlacement.PageFooter) || placement.containsOnly((IStiEnum)StiStyleComponentPlacement.PageHeader)) {
            style.setAllowUseborderSidesFromLocation(false);
        } else {
            style.setAllowUseborderSidesFromLocation(showBorders);
        }
        styles.add(style);
        return styles;
    }

    private StiStyle createStyle(String name, StiFont font, StiBrush brush, StiBrush textBrush, StiBorder border, StiEnumSet<StiStyleComponentPlacement> placement, Integer placementNestedLevel, StiEnumSet<StiStyleConditionOperation> placementNesterLevelOperation, StiEnumSet<StiStyleComponentType> componentType) {
        StiStyle style = new StiStyle(this.getStyleName(name));
        style.setFont(font);
        style.setBrush(brush);
        style.setTextBrush(textBrush);
        style.setBorder(border);
        ArrayList<StiStyleConditionElement> elements = new ArrayList<StiStyleConditionElement>();
        if (placementNesterLevelOperation.size() > 0 && placementNestedLevel != null) {
            elements.add(new StiStyleConditionPlacementNestedLevelElement(placementNestedLevel, (StiStyleConditionOperation)((Object)placementNesterLevelOperation.iterator().next())));
        }
        if (componentType != null) {
            elements.add(new StiStyleConditionComponentTypeElement(componentType));
        }
        elements.add(new StiStyleConditionPlacementElement(placement));
        style.getConditions().add(elements.toArray(new StiStyleConditionElement[0]));
        return style;
    }

    private String getStyleName(String baseName) {
        String name = baseName;
        int index = 2;
        while (true) {
            boolean finded = false;
            for (StiBaseStyle style : this.report.getStyles()) {
                if (!style.getName().equals(name)) continue;
                finded = true;
                break;
            }
            if (!finded) {
                return name;
            }
            name = String.format("%s_%s", baseName, index);
            ++index;
        }
    }

    public StiNestedFactor getNestedFactor() {
        return this.nestedFactor;
    }

    public void setNestedFactor(StiNestedFactor nestedFactor) {
        this.nestedFactor = nestedFactor;
    }

    public boolean isShowReportTitles() {
        return this.showReportTitles;
    }

    public void setShowReportTitles(boolean showReportTitles) {
        this.showReportTitles = showReportTitles;
    }

    public StiReport getReport() {
        return this.report;
    }

    public void setReport(StiReport report) {
        this.report = report;
    }

    public boolean isShowReportSummaries() {
        return this.showReportSummaries;
    }

    public void setShowReportSummaries(boolean showReportSummaries) {
        this.showReportSummaries = showReportSummaries;
    }

    public boolean isShowPageHeaders() {
        return this.showPageHeaders;
    }

    public void setShowPageHeaders(boolean showPageHeaders) {
        this.showPageHeaders = showPageHeaders;
    }

    public boolean isShowPageFooters() {
        return this.showPageFooters;
    }

    public void setShowPageFooters(boolean showPageFooters) {
        this.showPageFooters = showPageFooters;
    }

    public boolean isShowGroupHeaders() {
        return this.showGroupHeaders;
    }

    public void setShowGroupHeaders(boolean showGroupHeaders) {
        this.showGroupHeaders = showGroupHeaders;
    }

    public boolean isShowGroupFooters() {
        return this.showGroupFooters;
    }

    public void setShowGroupFooters(boolean showGroupFooters) {
        this.showGroupFooters = showGroupFooters;
    }

    public boolean isShowHeaders() {
        return this.showHeaders;
    }

    public void setShowHeaders(boolean showHeaders) {
        this.showHeaders = showHeaders;
    }

    public boolean isShowDatas() {
        return this.showDatas;
    }

    public void setShowDatas(boolean showDatas) {
        this.showDatas = showDatas;
    }

    public boolean isShowFooters() {
        return this.showFooters;
    }

    public void setShowFooters(boolean showFooters) {
        this.showFooters = showFooters;
    }

    public boolean isShowBorders() {
        return this.showBorders;
    }

    public void setShowBorders(boolean showBorders) {
        this.showBorders = showBorders;
    }

    public int getMaxNestedLevel() {
        return this.maxNestedLevel;
    }

    public void setMaxNestedLevel(int maxNestedLevel) {
        this.maxNestedLevel = maxNestedLevel;
    }
}

