/*
 * Decompiled with CFR 0.152.
 */
package com.stimulsoft.report.units;

import com.stimulsoft.report.components.StiComponent;
import com.stimulsoft.report.components.StiPage;
import com.stimulsoft.report.viewer.visual.StiVisual;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.swing.SwingUtilities;
import javax.swing.ToolTipManager;

public class StiToolTipHelper {
    private static Map<String, List<StiToolTipHelper>> pagesToolTip = new HashMap<String, List<StiToolTipHelper>>();
    private static StiVisual currenTip;
    private static int toolTipInitialDelay;
    private static int toolTipDimissDelay;
    private StiComponent component;
    private String text;
    private Boolean hyperlink = false;

    public StiToolTipHelper(StiComponent component, String text, Boolean hyperlink) {
        this.component = component;
        this.text = text;
        this.hyperlink = hyperlink;
    }

    public static void addToolTip(StiComponent component, String text, Boolean isHyperlink) {
        StiToolTipHelper toolTipHelper;
        List<StiToolTipHelper> toolTipArray = pagesToolTip.get(component.getPage().getGuid());
        if (toolTipArray == null) {
            toolTipArray = new ArrayList<StiToolTipHelper>();
            pagesToolTip.put(component.getPage().getGuid(), toolTipArray);
        }
        if (!toolTipArray.contains(toolTipHelper = new StiToolTipHelper(component, text, isHyperlink))) {
            toolTipArray.add(toolTipHelper);
        }
    }

    public static List<StiToolTipHelper> getToolTips(StiPage page) {
        List<StiToolTipHelper> toolTipArray = pagesToolTip.get(page.getGuid());
        if (toolTipArray == null) {
            return new ArrayList<StiToolTipHelper>();
        }
        return toolTipArray;
    }

    public static void clearAll() {
        pagesToolTip.clear();
    }

    public static void showToolTip(StiVisual pageVisual, String text, Double x, Double y) {
        if (currenTip != null && !currenTip.equals(pageVisual)) {
            currenTip.setToolTipText(null);
        }
        pageVisual.setToolTipText(text);
        ToolTipManager.sharedInstance().setInitialDelay(0);
        currenTip = pageVisual;
    }

    public static void hideToolTip() {
        ToolTipManager.sharedInstance().setInitialDelay(toolTipInitialDelay);
        if (currenTip != null) {
            currenTip.setToolTipText(null);
            ToolTipManager.sharedInstance().setDismissDelay(0);
            SwingUtilities.invokeLater(new Runnable(){

                @Override
                public void run() {
                    ToolTipManager.sharedInstance().setDismissDelay(toolTipDimissDelay);
                }
            });
            currenTip = null;
        }
    }

    public int hashCode() {
        int prime = 31;
        int result = 1;
        result = 31 * result + (this.component == null ? 0 : this.component.hashCode());
        return result;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        StiToolTipHelper other = (StiToolTipHelper)obj;
        return !(this.component == null ? other.component != null : !this.component.equals(other.component));
    }

    public StiComponent getComponent() {
        return this.component;
    }

    public String getText() {
        return this.text;
    }

    public Boolean getHyperlink() {
        return this.hyperlink;
    }

    static {
        toolTipInitialDelay = ToolTipManager.sharedInstance().getInitialDelay();
        toolTipDimissDelay = ToolTipManager.sharedInstance().getDismissDelay();
    }
}

