/*
 * Decompiled with CFR 0.152.
 */
package com.stimulsoft.report.utils.data;

import com.stimulsoft.base.exception.StiException;
import com.stimulsoft.base.serializing.utils.StiXMLConvert;
import com.stimulsoft.base.system.type.StiSystemBoolean;
import com.stimulsoft.base.system.type.StiSystemByte;
import com.stimulsoft.base.system.type.StiSystemByteArray;
import com.stimulsoft.base.system.type.StiSystemDateTime;
import com.stimulsoft.base.system.type.StiSystemDecimal;
import com.stimulsoft.base.system.type.StiSystemDouble;
import com.stimulsoft.base.system.type.StiSystemInt16;
import com.stimulsoft.base.system.type.StiSystemInt32;
import com.stimulsoft.base.system.type.StiSystemInt64;
import com.stimulsoft.base.system.type.StiSystemObject;
import com.stimulsoft.base.system.type.StiSystemSingle;
import com.stimulsoft.base.system.type.StiSystemString;
import com.stimulsoft.base.system.type.StiSystemTimeSpan;
import com.stimulsoft.base.system.type.StiSystemType;
import com.stimulsoft.base.system.type.StiSystemTypeEnum;
import com.stimulsoft.lib.io.StiCloseUtil;
import com.stimulsoft.lib.utils.StiValidationUtil;
import com.stimulsoft.lib.utils.StiXmlUtil;
import com.stimulsoft.report.StiOptions;
import com.stimulsoft.report.components.StiComponent;
import com.stimulsoft.report.components.simplecomponents.StiText;
import com.stimulsoft.report.dictionary.StiDataColumn;
import com.stimulsoft.report.dictionary.StiDataParameter;
import com.stimulsoft.report.dictionary.StiVariable;
import com.stimulsoft.report.dictionary.StiVariableAsParameterHelper;
import com.stimulsoft.report.dictionary.data.DataRow;
import com.stimulsoft.report.dictionary.dataSources.StiDataSource;
import com.stimulsoft.report.dictionary.dataSources.StiOracleSource;
import com.stimulsoft.report.dictionary.databases.QueryParameter;
import com.stimulsoft.report.dictionary.databases.StiJDBCDatabase;
import com.stimulsoft.report.dictionary.enums.StiSqlSourceType;
import com.stimulsoft.report.engine.parser.StiParser;
import com.stimulsoft.report.utils.data.StiSqlField;
import com.stimulsoft.report.utils.data.StiTableFieldsRequest;
import com.stimulsoft.report.utils.data.StiXmlTable;
import com.stimulsoft.report.utils.data.StiXmlTableFieldsRequest;
import java.io.InputStream;
import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.ResultSetMetaData;
import java.sql.SQLException;
import java.sql.Statement;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import org.w3c.dom.Document;
import org.w3c.dom.NamedNodeMap;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;

public class StiDataColumnsUtil {
    public static StiXmlTableFieldsRequest parceXSDSchema(InputStream is) {
        return StiDataColumnsUtil.parceXSDSchema(is, true);
    }

    public static StiXmlTableFieldsRequest parceXMLSchema(InputStream is, boolean decodeName) {
        StiXmlTableFieldsRequest result = new StiXmlTableFieldsRequest();
        if (is == null) {
            return result;
        }
        Document document = StiXmlUtil.parseXmlInputStream((InputStream)is);
        NodeList xmlRows = document.getFirstChild().getChildNodes();
        int length = xmlRows.getLength();
        for (int i = 0; i < length; ++i) {
            Node xmlRow = xmlRows.item(i);
            if (!StiXmlUtil.isElementNode((Node)xmlRow)) continue;
            StiXmlTable table = StiDataColumnsUtil.xmlTable(xmlRow, decodeName);
            boolean exists = false;
            for (StiXmlTable tabl : result.getTables()) {
                if (!StiValidationUtil.equals((Object)table.getName(), (Object)tabl.getName())) continue;
                tabl.merge(table);
                exists = true;
            }
            if (exists) continue;
            result.add(table);
        }
        return result;
    }

    public static StiXmlTableFieldsRequest parceXSDSchema(InputStream is, boolean decodeName) {
        Document document = StiXmlUtil.parseXmlInputStream((InputStream)is);
        NodeList xmlRows = document.getElementsByTagName("xs:choice").item(0).getChildNodes();
        int length = xmlRows.getLength();
        StiXmlTableFieldsRequest result = new StiXmlTableFieldsRequest();
        for (int i = 0; i < length; ++i) {
            Node xmlRow = xmlRows.item(i);
            if (!StiXmlUtil.isElementNode((Node)xmlRow)) continue;
            result.add(StiDataColumnsUtil.table(xmlRow, decodeName));
        }
        return result;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public static StiTableFieldsRequest getFields(Connection con, String query, StiDataSource source) throws StiException {
        PreparedStatement ps = null;
        if (StiOptions.Dictionary.isIgnoreLastSemicolonQuery() && query != null && query.endsWith(";")) {
            query = query.substring(0, query.length() - 1);
        }
        Statement st = null;
        try {
            StiTableFieldsRequest tableFilds;
            ResultSet rs;
            block24: {
                Iterator i$;
                block26: {
                    Iterator<StiVariable> i$2;
                    block27: {
                        block25: {
                            if (source == null || source.getDictionary() == null || source.getDictionary().getReport() == null) break block25;
                            source.getVariableParameters().clear();
                            List<StiVariable> variables = StiVariableAsParameterHelper.fetchAll(query, source.getParameters(), source.getDictionary().getReport());
                            if (variables == null || variables.size() <= 0) break block26;
                            i$2 = variables.iterator();
                            break block27;
                        }
                        st = con.createStatement();
                        rs = st.executeQuery(query);
                        break block24;
                    }
                    while (i$2.hasNext()) {
                        StiVariable variable = i$2.next();
                        try {
                            Object value = source.getDictionary().getReport().get(variable.getName());
                            if (value == null) {
                                value = variable.eval(source.getDictionary().getReport());
                            }
                            StiDataParameter param = new StiDataParameter(variable.getName(), 0, 0);
                            param.setParameterValue(value);
                            source.getVariableParameters().add(param);
                        }
                        catch (Exception e) {
                            if (StiOptions.Engine.logLevel < 10) continue;
                            e.printStackTrace();
                        }
                    }
                }
                List<Object> queryResult = StiJDBCDatabase.getQueryParameter(query, con, source);
                ArrayList queryParameters = (ArrayList)queryResult.get(0);
                query = (String)queryResult.get(1);
                StiText tempText = new StiText();
                tempText.setName("**DataSourceSqlCommand**");
                tempText.setPage(source.getDictionary().getReport().getPages().get(0));
                if (!(source instanceof StiOracleSource) || ((StiOracleSource)source).getType() != StiSqlSourceType.StoredProcedure) {
                    ps = con.prepareStatement((String)StiParser.ParseTextValue(query, (StiComponent)tempText));
                    i$ = queryParameters.iterator();
                } else {
                    StiDataColumn column;
                    String parsedValue = (String)StiParser.ParseTextValue(query, (StiComponent)tempText);
                    ps = parsedValue.startsWith("?") ? con.prepareCall("{" + parsedValue + "}") : con.prepareCall(parsedValue);
                    int refCursorIndex = -1;
                    ArrayList<QueryParameter> outParameters = new ArrayList<QueryParameter>();
                    for (QueryParameter queryParameter : queryParameters) {
                        if (queryParameter.name.toLowerCase().indexOf("refcursor") >= 0) {
                            refCursorIndex = queryParameter.index;
                            StiJDBCDatabase.registerOutParameterOracle(ps, refCursorIndex, -10);
                            continue;
                        }
                        StiDataParameter reportParameter = source.getParameters().getByName(queryParameter.name.substring(1));
                        if (reportParameter == null) {
                            reportParameter = source.getVariableParameterByName(queryParameter.name.substring(1));
                        }
                        if (reportParameter != null) {
                            ps.setObject(queryParameter.index, reportParameter.getParameterValueByDatabace());
                            continue;
                        }
                        column = source.getColumns().get(queryParameter.name.substring(1));
                        if (column == null) {
                            throw new StiException("Parameter " + queryParameter.name.substring(1) + " not found");
                        }
                        StiJDBCDatabase.registerOutParameterOracle(ps, queryParameter.index, StiDataColumnsUtil.getSqlType(column.getType()));
                        outParameters.add(queryParameter);
                    }
                    ps.executeUpdate();
                    if (refCursorIndex >= 0) {
                        rs = (ResultSet)DataRow.getValue("getObject", refCursorIndex, ps);
                        break block24;
                    } else {
                        if (outParameters.size() <= 0) throw new StiException("Output parameters not defined: " + query);
                        StiTableFieldsRequest tableFilds2 = new StiTableFieldsRequest();
                        for (QueryParameter queryParameter : outParameters) {
                            column = source.getColumns().get(queryParameter.name.substring(1));
                            tableFilds2.add(column.getName(), column.getType().name());
                        }
                        StiTableFieldsRequest stiTableFieldsRequest = tableFilds2;
                        StiCloseUtil.close((Statement)st, (Connection)con);
                        StiCloseUtil.close((Statement)ps, (Connection)con);
                        return stiTableFieldsRequest;
                    }
                }
                while (i$.hasNext()) {
                    QueryParameter queryParameter = (QueryParameter)i$.next();
                    StiDataParameter reportParameter = source.getParameters().getByName(queryParameter.name.substring(1));
                    if (reportParameter == null) {
                        reportParameter = source.getVariableParameterByName(queryParameter.name.substring(1));
                    }
                    if (reportParameter == null) {
                        throw new StiException("Paramater " + queryParameter.name.substring(1) + " not found");
                    }
                    ps.setObject(queryParameter.index, reportParameter.getParameterValueByDatabace());
                }
                rs = ps.executeQuery();
            }
            StiTableFieldsRequest stiTableFieldsRequest = tableFilds = StiDataColumnsUtil.getTableFields(rs);
            return stiTableFieldsRequest;
        }
        catch (Exception e) {
            throw new StiException((Throwable)e);
        }
        finally {
            StiCloseUtil.close((Statement)st, (Connection)con);
            StiCloseUtil.close(ps, (Connection)con);
        }
    }

    private static StiXmlTable xmlTable(Node node, boolean decodeName) {
        String name = decodeName ? StiXMLConvert.decodeName((String)node.getNodeName()) : node.getNodeName();
        StiXmlTable result = new StiXmlTable(name);
        NodeList fieldsNodes = node.getChildNodes();
        result.setColumns(StiDataColumnsUtil.xmlFields(fieldsNodes, decodeName));
        result.getColumns().addAll(StiDataColumnsUtil.xmlAttributes(node.getAttributes(), decodeName));
        return result;
    }

    private static StiXmlTable table(Node node, boolean decodeName) {
        String name = decodeName ? StiXMLConvert.decodeName((String)node.getAttributes().getNamedItem("name").getNodeValue()) : node.getAttributes().getNamedItem("name").getNodeValue();
        StiXmlTable result = new StiXmlTable(name);
        NodeList fieldsNodes = node.getChildNodes().item(1).getChildNodes().item(1).getChildNodes();
        result.setColumns(StiDataColumnsUtil.fields(fieldsNodes, decodeName));
        result.getColumns().addAll(StiDataColumnsUtil.attributes(node.getChildNodes().item(1).getChildNodes(), decodeName));
        return result;
    }

    private static List<StiSqlField> attributes(NodeList xmlCell, boolean decodeName) {
        ArrayList<StiSqlField> result = new ArrayList<StiSqlField>();
        int length = xmlCell.getLength();
        for (int index = 0; index < length; ++index) {
            Node node = xmlCell.item(index);
            if (!StiXmlUtil.isElementNode((Node)node) || !node.getNodeName().equals("xs:attribute")) continue;
            String name = decodeName ? StiXMLConvert.decodeName((String)node.getAttributes().getNamedItem("name").getNodeValue()) : node.getAttributes().getNamedItem("name").getNodeValue();
            String type = node.getAttributes().getNamedItem("type").getNodeValue().substring(3);
            result.add(new StiSqlField(name, type));
        }
        return result;
    }

    private static List<StiSqlField> xmlAttributes(NamedNodeMap xmlCell, boolean decodeName) {
        ArrayList<StiSqlField> result = new ArrayList<StiSqlField>();
        int length = xmlCell.getLength();
        for (int index = 0; index < length; ++index) {
            Node node = xmlCell.item(index);
            if (!StiXmlUtil.isAttributeNode((Node)node)) continue;
            String name = decodeName ? StiXMLConvert.decodeName((String)node.getNodeName()) : node.getNodeName();
            result.add(new StiSqlField(name, "string"));
        }
        return result;
    }

    private static List<StiSqlField> xmlFields(NodeList xmlCell, boolean decodeName) {
        ArrayList<StiSqlField> result = new ArrayList<StiSqlField>();
        int length = xmlCell.getLength();
        for (int index = 0; index < length; ++index) {
            Node node = xmlCell.item(index);
            if (!StiXmlUtil.isElementNode((Node)node)) continue;
            String name = decodeName ? StiXMLConvert.decodeName((String)node.getNodeName()) : node.getNodeName();
            result.add(new StiSqlField(name, "string"));
        }
        return result;
    }

    private static List<StiSqlField> fields(NodeList xmlCell, boolean decodeName) {
        ArrayList<StiSqlField> result = new ArrayList<StiSqlField>();
        int length = xmlCell.getLength();
        for (int index = 0; index < length; ++index) {
            Node node = xmlCell.item(index);
            if (!StiXmlUtil.isElementNode((Node)node)) continue;
            String name = decodeName ? StiXMLConvert.decodeName((String)node.getAttributes().getNamedItem("name").getNodeValue()) : node.getAttributes().getNamedItem("name").getNodeValue();
            String type = node.getAttributes().getNamedItem("type").getNodeValue().substring(3);
            result.add(new StiSqlField(name, type));
        }
        return result;
    }

    private static StiTableFieldsRequest getTableFields(ResultSet rs) throws SQLException {
        ResultSetMetaData rsmd = rs.getMetaData();
        StiTableFieldsRequest tableFilds = new StiTableFieldsRequest();
        for (int i = 1; i < rsmd.getColumnCount() + 1; ++i) {
            String columnName = rsmd.getColumnLabel(i);
            int columnType = rsmd.getColumnType(i);
            tableFilds.add(columnName, StiDataColumnsUtil.getType(columnType));
        }
        return tableFilds;
    }

    public static String getType(int columnType) {
        return StiDataColumnsUtil.getSystemType(columnType).getEnumType().name();
    }

    public static StiSystemType getSystemType(int columnType) {
        switch (columnType) {
            case -16: 
            case -15: 
            case -9: 
            case -1: 
            case 1: 
            case 12: 
            case 2005: 
            case 2011: {
                return new StiSystemString();
            }
            case -7: 
            case 16: {
                return new StiSystemBoolean();
            }
            case 4: {
                return new StiSystemInt32();
            }
            case -5: {
                return new StiSystemInt64();
            }
            case 5: {
                return new StiSystemInt16();
            }
            case -6: {
                return new StiSystemByte();
            }
            case -101: 
            case 91: 
            case 93: {
                return new StiSystemDateTime();
            }
            case 92: {
                return new StiSystemTimeSpan();
            }
            case 3: {
                return new StiSystemDecimal();
            }
            case 2: 
            case 6: 
            case 8: {
                return new StiSystemDouble();
            }
            case 7: {
                return new StiSystemSingle();
            }
            case -4: 
            case -3: 
            case -2: 
            case 0: 
            case 70: 
            case 1111: 
            case 2000: 
            case 2002: 
            case 2003: 
            case 2004: 
            case 2006: 
            case 2009: {
                return new StiSystemByteArray();
            }
        }
        return new StiSystemObject();
    }

    public static int getSqlType(StiSystemTypeEnum columnType) {
        switch (columnType) {
            case SystemString: {
                return 12;
            }
            case SystemBoolean: {
                return 16;
            }
            case SystemInt32: {
                return 4;
            }
            case SystemInt64: {
                return -5;
            }
            case SystemInt16: {
                return 5;
            }
            case SystemByte: {
                return -6;
            }
            case SystemDateTime: {
                return 93;
            }
            case SystemTimeSpan: {
                return 92;
            }
            case SystemDecimal: {
                return 3;
            }
            case SystemDouble: {
                return 2;
            }
            case SystemSingle: {
                return 7;
            }
        }
        return 2004;
    }
}

