/*
 * Decompiled with CFR 0.152.
 */
package com.stonecobra.connectors.rightnow;

import com.stonecobra.connectors.rightnow.RequestErrorFault;
import com.stonecobra.connectors.rightnow.RightNowException;
import com.stonecobra.connectors.rightnow.RightNowProxyClient;
import com.stonecobra.connectors.rightnow.ServerErrorFault;
import com.stonecobra.connectors.rightnow.UnexpectedErrorFault;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.UUID;
import javax.xml.datatype.DatatypeConfigurationException;
import org.apache.log4j.Logger;
import org.mule.api.ConnectionException;
import org.mule.api.ConnectionExceptionCode;
import org.mule.common.metadata.MetaData;
import org.mule.common.metadata.MetaDataKey;

public class RightNowConnector {
    private static final Logger log = Logger.getLogger((String)RightNowConnector.class.getName());
    private RightNowProxyClient rnClient = null;

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public void connect(String username, String password, String url) throws ConnectionException {
        log.debug((Object)("Connecting to RightNow as " + username + "."));
        if (username != null && !username.isEmpty() && password != null && !password.isEmpty()) {
            if (url != null && !url.isEmpty()) {
                try {
                    this.rnClient = new RightNowProxyClient();
                    this.rnClient.initialize(username, password, url);
                    return;
                }
                catch (Exception e) {
                    String message = String.format("RightNow connection failed.  Error initializing connection to RightNow: %s", e.toString());
                    log.error((Object)message);
                    throw new ConnectionException(ConnectionExceptionCode.UNKNOWN, "", message, (Throwable)e);
                }
            }
            log.error((Object)"RightNow connection failed.  URL is blank.  This field is required.");
            throw new ConnectionException(ConnectionExceptionCode.UNKNOWN_HOST, "", "RightNow connection failed.  URL is blank.  This field is required.");
        }
        log.error((Object)"RightNow connection failed.  User name, password, or URL is blank.  These fields are required.");
        throw new ConnectionException(ConnectionExceptionCode.INCORRECT_CREDENTIALS, "", "RightNow connection failed.  User name, password, or URL is blank.  These fields are required.");
    }

    public void disconnect() {
        log.debug((Object)"Disconnecting from RightNow.");
        this.rnClient = null;
    }

    public boolean isConnected() {
        return this.rnClient != null;
    }

    public String connectionId() {
        return "RightNow-" + UUID.randomUUID().toString();
    }

    public List<Map<String, Object>> get(String type, List<Long> ids) throws UnexpectedErrorFault, RequestErrorFault, ServerErrorFault, RightNowException {
        ArrayList<Map<String, Object>> results = new ArrayList<Map<String, Object>>();
        results.addAll(this.rnClient.get(type, ids));
        return results;
    }

    public List<Map<String, Object>> query(String type, String query) throws UnexpectedErrorFault, RequestErrorFault, ServerErrorFault, RightNowException {
        ArrayList<Map<String, Object>> results = new ArrayList<Map<String, Object>>();
        results.addAll(this.rnClient.query(type, query, 1000));
        return results;
    }

    public List<Map<String, Object>> create(String type, List<Map<String, Object>> objects) throws UnexpectedErrorFault, RequestErrorFault, ServerErrorFault, DatatypeConfigurationException, RightNowException {
        ArrayList<Map<String, Object>> results = new ArrayList<Map<String, Object>>();
        results.addAll(this.rnClient.create(type, objects));
        return results;
    }

    public List<Map<String, Object>> upsert(String type, List<Map<String, Object>> objects) throws UnexpectedErrorFault, RequestErrorFault, ServerErrorFault, DatatypeConfigurationException, RightNowException {
        ArrayList<Map<String, Object>> results = new ArrayList<Map<String, Object>>();
        results.addAll(this.rnClient.upsert(type, objects));
        return results;
    }

    public void update(String type, List<Map<String, Object>> objects) throws UnexpectedErrorFault, RequestErrorFault, ServerErrorFault, DatatypeConfigurationException, RightNowException {
        this.rnClient.update(type, objects);
    }

    public void delete(String type, List<Long> ids) throws UnexpectedErrorFault, RequestErrorFault, ServerErrorFault, RightNowException {
        this.rnClient.destroy(type, ids);
    }

    public List<MetaDataKey> getEntities() {
        return this.rnClient.getMetaDataEntityKeys();
    }

    public MetaData describeEntity(MetaDataKey entityKey) throws RightNowException {
        return this.rnClient.getMetaDataEntity(entityKey);
    }
}

