/*
 * Decompiled with CFR 0.152.
 */
package com.stonecobra.connectors.rightnow;

import com.stonecobra.connectors.rightnow.DataTypeEnum;
import com.stonecobra.connectors.rightnow.DataValue;
import com.stonecobra.connectors.rightnow.GenericField;
import com.stonecobra.connectors.rightnow.GenericObject;
import com.stonecobra.connectors.rightnow.ID;
import com.stonecobra.connectors.rightnow.MetaDataAttribute;
import com.stonecobra.connectors.rightnow.MetaDataClass;
import com.stonecobra.connectors.rightnow.NamedID;
import com.stonecobra.connectors.rightnow.NamedIDDelta;
import com.stonecobra.connectors.rightnow.NamedIDHierarchy;
import com.stonecobra.connectors.rightnow.RNObjectType;
import com.stonecobra.connectors.rightnow.RightNowAction;
import com.stonecobra.connectors.rightnow.RightNowException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Calendar;
import java.util.Collection;
import java.util.Date;
import java.util.GregorianCalendar;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import javax.xml.datatype.DatatypeConfigurationException;
import javax.xml.datatype.DatatypeFactory;
import javax.xml.datatype.XMLGregorianCalendar;
import org.apache.commons.lang.ArrayUtils;
import org.apache.commons.lang.StringUtils;
import org.apache.log4j.Logger;
import org.mule.common.metadata.DefaultMetaData;
import org.mule.common.metadata.MetaData;
import org.mule.common.metadata.builder.DefaultMetaDataBuilder;
import org.mule.common.metadata.builder.DynamicObjectBuilder;
import org.mule.common.metadata.builder.DynamicObjectFieldBuilder;
import org.mule.common.metadata.datatype.DataType;

public class RightNowConverter {
    private static final Logger log = Logger.getLogger((String)RightNowConverter.class.getName());
    private static final String RIGHTNOW_ID = "ID";
    private static final String RIGHTNOW_ID_NAME = "Name";
    private static final String RIGHTNOW_NAMEDID = "NamedID";
    private static final String RIGHTNOW_NAMEDID_DELTA = "NamedIDDelta";
    private static final String RIGHTNOW_NAMEDID_HIERARCHY = "NamedIDHierarchy";
    private static final String RIGHTNOW_ENUM_SUFFIX = "enum";
    private Map<String, String> primaryObjectTypeNames = null;
    private Map<String, MetaDataClass> metaDataClasses = new HashMap<String, MetaDataClass>();

    public Collection<String> getPrimaryObjectTypeNames() {
        return this.primaryObjectTypeNames.values();
    }

    public RightNowConverter(List<MetaDataClass> metaDataList) throws RightNowException {
        this.primaryObjectTypeNames = this.getPrimaryObjectNameMap();
        if (metaDataList != null && !metaDataList.isEmpty()) {
            for (MetaDataClass classMetaData : metaDataList) {
                this.metaDataClasses.put(classMetaData.getName().getTypeName().toLowerCase(), classMetaData);
            }
        } else {
            throw new RightNowException("Unable to create RightNow converter since a null or empty list of RightNow metadata classes was provided.");
        }
    }

    private Map<String, String> getPrimaryObjectNameMap() {
        HashMap<String, String> primaryObjects = new HashMap<String, String>();
        primaryObjects.put("account", "Account");
        primaryObjects.put("answer", "Answer");
        primaryObjects.put("asset", "Asset");
        primaryObjects.put("channeltype", "ChannelType");
        primaryObjects.put("configuration", "Configuration");
        primaryObjects.put("contact", "Contact");
        primaryObjects.put("country", "Country");
        primaryObjects.put("holiday", "Holiday");
        primaryObjects.put("incident", "Incident");
        primaryObjects.put("mailbox", "Mailbox");
        primaryObjects.put("marketingmailbox", "MarketingMailbox");
        primaryObjects.put("messagebase", "MessageBase");
        primaryObjects.put("opportunity", "Opportunity");
        primaryObjects.put("organization", "Organization");
        primaryObjects.put("purchasedproduct", "PurchasedProduct");
        primaryObjects.put("salesproduct", "SalesProduct");
        primaryObjects.put("salesterritory", "SalesTerritory");
        primaryObjects.put("servicecategory", "ServiceCategory");
        primaryObjects.put("servicedisposition", "ServiceDisposition");
        primaryObjects.put("servicemailbox", "ServiceMailbox");
        primaryObjects.put("serviceproduct", "ServiceProduct");
        primaryObjects.put("siteinterface", "SiteInterface");
        primaryObjects.put("standardcontent", "StandardContent");
        primaryObjects.put("task", "Task");
        primaryObjects.put("variable", "Variable");
        return primaryObjects;
    }

    public static Boolean isListType(DataTypeEnum dataType) {
        Boolean isList = false;
        switch (dataType) {
            case BOOLEAN_LIST: 
            case DATE_LIST: 
            case DATETIME_LIST: 
            case DECIMAL_LIST: 
            case ID_LIST: 
            case INTEGER_LIST: 
            case LONG_LIST: 
            case NAMED_ID_LIST: 
            case NAMED_ID_DELTA_LIST: 
            case NAMED_ID_HIERARCHY_LIST: 
            case OBJECT_LIST: 
            case STRING_LIST: {
                isList = true;
                break;
            }
            default: {
                isList = false;
            }
        }
        return isList;
    }

    public static Boolean isObjectType(DataTypeEnum dataType) {
        Boolean isObject = false;
        switch (dataType) {
            case ID: 
            case OBJECT: 
            case NAMED_ID: 
            case NAMED_ID_HIERARCHY: {
                isObject = true;
                break;
            }
            default: {
                isObject = false;
            }
        }
        return isObject;
    }

    public static Boolean isTypeValidForMule(String typeName) {
        Boolean isValid = false;
        if (!(!StringUtils.isNotBlank((String)typeName) || typeName.equalsIgnoreCase("GenericField") || typeName.equalsIgnoreCase("GenericObject") || typeName.equalsIgnoreCase("RNObject") || typeName.equalsIgnoreCase("RNObjectType") || typeName.endsWith("NullFields"))) {
            isValid = true;
        }
        return isValid;
    }

    public static MetaDataAttribute getMetaDataAttribute(String name, List<MetaDataAttribute> attributes) {
        MetaDataAttribute attribute = null;
        for (MetaDataAttribute current : attributes) {
            if (!current.getName().equalsIgnoreCase(name)) continue;
            attribute = current;
            break;
        }
        return attribute;
    }

    public static String getMetaDataAttributeProperName(String name, List<MetaDataAttribute> attributes) {
        String properName = null;
        for (MetaDataAttribute current : attributes) {
            String currentName = current.getName();
            if (!currentName.equalsIgnoreCase(name)) continue;
            properName = currentName;
            break;
        }
        return properName;
    }

    public static String getDataTypeName(MetaDataAttribute attribute) {
        String typeName = null;
        DataTypeEnum dataType = attribute.getDataType();
        switch (dataType) {
            case ID_LIST: 
            case ID: {
                typeName = RIGHTNOW_ID;
                break;
            }
            case OBJECT_LIST: 
            case OBJECT: {
                typeName = attribute.getDataTypeName();
                break;
            }
            case NAMED_ID_LIST: 
            case NAMED_ID: {
                typeName = RIGHTNOW_NAMEDID;
                break;
            }
            case NAMED_ID_HIERARCHY_LIST: 
            case NAMED_ID_HIERARCHY: {
                typeName = RIGHTNOW_NAMEDID_HIERARCHY;
                break;
            }
            case NAMED_ID_DELTA_LIST: {
                typeName = RIGHTNOW_NAMEDID_DELTA;
                break;
            }
        }
        return typeName;
    }

    public MetaData toMuleMetaData(String typeName) {
        DefaultMetaData muleMetaData = null;
        if (StringUtils.isNotBlank((String)typeName) && this.primaryObjectTypeNames.containsKey(typeName.toLowerCase())) {
            String properTypeName = this.primaryObjectTypeNames.get(typeName.toLowerCase());
            DefaultMetaDataBuilder metaDataBuilder = new DefaultMetaDataBuilder();
            DynamicObjectBuilder objectBuilder = metaDataBuilder.createDynamicObject(properTypeName);
            this.addMuleMetaDataFields(properTypeName, objectBuilder);
            muleMetaData = new DefaultMetaData(metaDataBuilder.build());
        }
        return muleMetaData;
    }

    private void addMuleMetaDataFields(String typeName, DynamicObjectBuilder<?> objectBuilder) {
        if (StringUtils.isNotBlank((String)typeName) && objectBuilder != null) {
            MetaDataClass classMetaData = this.metaDataClasses.get(typeName.toLowerCase());
            if (classMetaData != null) {
                block19: for (MetaDataAttribute attribute : classMetaData.getAttributes().getMetaDataAttributeList()) {
                    String name = attribute.getName();
                    DataTypeEnum dataType = attribute.getDataType();
                    if (!RightNowAction.GET.isAttributeValid(attribute).booleanValue() || !RightNowConverter.isTypeValidForMule(RightNowConverter.getDataTypeName(attribute)).booleanValue()) continue;
                    DynamicObjectFieldBuilder fieldBuilder = null;
                    String subTypeName = null;
                    switch (dataType) {
                        case BASE_64_BINARY: {
                            objectBuilder.addList(name).ofSimpleField(DataType.BYTE);
                            continue block19;
                        }
                        case BOOLEAN: {
                            objectBuilder.addSimpleField(name, DataType.BOOLEAN);
                            continue block19;
                        }
                        case BOOLEAN_LIST: {
                            objectBuilder.addList(name).ofSimpleField(DataType.BOOLEAN);
                            continue block19;
                        }
                        case DATE: {
                            objectBuilder.addSimpleField(name, DataType.DATE);
                            continue block19;
                        }
                        case DATE_LIST: {
                            objectBuilder.addList(name).ofSimpleField(DataType.DATE);
                            continue block19;
                        }
                        case DATETIME: {
                            objectBuilder.addSimpleField(name, DataType.DATE_TIME);
                            continue block19;
                        }
                        case DATETIME_LIST: {
                            objectBuilder.addList(name).ofSimpleField(DataType.DATE_TIME);
                            continue block19;
                        }
                        case DECIMAL: {
                            objectBuilder.addSimpleField(name, DataType.DOUBLE);
                            continue block19;
                        }
                        case DECIMAL_LIST: {
                            objectBuilder.addList(name).ofSimpleField(DataType.DOUBLE);
                            continue block19;
                        }
                        case INTEGER: {
                            objectBuilder.addSimpleField(name, DataType.INTEGER);
                            continue block19;
                        }
                        case INTEGER_LIST: {
                            objectBuilder.addList(name).ofSimpleField(DataType.INTEGER);
                            continue block19;
                        }
                        case LONG: {
                            objectBuilder.addSimpleField(name, DataType.LONG);
                            continue block19;
                        }
                        case LONG_LIST: {
                            objectBuilder.addList(name).ofSimpleField(DataType.LONG);
                            continue block19;
                        }
                        case ID: 
                        case OBJECT: 
                        case NAMED_ID: 
                        case NAMED_ID_HIERARCHY: {
                            subTypeName = RightNowConverter.getDataTypeName(attribute);
                            fieldBuilder = objectBuilder.addDynamicObjectField(name);
                            this.addMuleMetaDataFields(subTypeName, (DynamicObjectBuilder<?>)fieldBuilder);
                            continue block19;
                        }
                        case ID_LIST: 
                        case NAMED_ID_LIST: 
                        case NAMED_ID_DELTA_LIST: 
                        case NAMED_ID_HIERARCHY_LIST: 
                        case OBJECT_LIST: {
                            subTypeName = RightNowConverter.getDataTypeName(attribute);
                            fieldBuilder = objectBuilder.addList(name).ofDynamicObject(subTypeName);
                            this.addMuleMetaDataFields(subTypeName, (DynamicObjectBuilder<?>)fieldBuilder);
                            continue block19;
                        }
                        case STRING: {
                            objectBuilder.addSimpleField(name, DataType.STRING);
                            continue block19;
                        }
                        case STRING_LIST: {
                            objectBuilder.addList(name).ofSimpleField(DataType.STRING);
                            continue block19;
                        }
                    }
                    log.error((Object)String.format("Unable to create Mule metadata field: No matching RightNow type for ID %s.", dataType.toString()));
                }
            } else {
                log.error((Object)String.format("Unable to create Mule metadata fields: Unable to get RightNow metadata for %s.", typeName));
            }
        } else {
            log.error((Object)"Unable to create Mule metadata fields: Null parameters provided.");
        }
    }

    /*
     * Enabled aggressive block sorting
     */
    public GenericObject toGenericObject(String typeName, Map<String, Object> map) throws DatatypeConfigurationException, RightNowException {
        GenericObject genericObject = null;
        if (StringUtils.isNotBlank((String)typeName) && map != null) {
            MetaDataClass classMetaData = this.metaDataClasses.get(typeName.toLowerCase());
            if (classMetaData == null) {
                String message = String.format("Unable to create generic version of object {%s} because RightNow does not recognize the type.", typeName);
                log.error((Object)message);
                throw new RightNowException(message);
            }
            genericObject = new GenericObject();
            RNObjectType objectType = new RNObjectType();
            objectType.setTypeName(classMetaData.getName().getTypeName());
            objectType.setNamespace(classMetaData.getName().getNamespace());
            genericObject.setObjectType(objectType);
            List<MetaDataAttribute> attributes = classMetaData.getAttributes().getMetaDataAttributeList();
            List<GenericField> fields = genericObject.getGenericFields();
            Iterator<Map.Entry<String, Object>> i$ = map.entrySet().iterator();
            while (true) {
                ID id;
                if (!i$.hasNext()) {
                    return genericObject;
                }
                Map.Entry<String, Object> mField = i$.next();
                GenericField rField = new GenericField();
                String attributeName = RightNowConverter.getMetaDataAttributeProperName(mField.getKey(), attributes);
                rField.setName(attributeName);
                MetaDataAttribute attribute = RightNowConverter.getMetaDataAttribute(attributeName, attributes);
                DataTypeEnum dataType = attribute.getDataType();
                rField.setDataType(dataType);
                Boolean setId = false;
                if (dataType == DataTypeEnum.ID && (id = this.toID((Map)mField.getValue())) != null) {
                    genericObject.setID(id);
                    setId = true;
                }
                if (!setId.booleanValue()) {
                    rField.setDataValue(this.toDataValue(dataType, RightNowConverter.getDataTypeName(attribute), mField.getValue()));
                }
                fields.add(rField);
            }
        }
        String message = String.format("Unable to create generic version of object {%s} because no type or list of RightNow meta data was provided.", StringUtils.isNotBlank((String)typeName) ? typeName : "null");
        log.error((Object)message);
        throw new RightNowException(message);
    }

    /*
     * Enabled aggressive block sorting
     */
    public GenericObject toGenericObject(String typeName, RightNowAction action) throws RightNowException {
        GenericObject genericObject = null;
        if (StringUtils.isNotBlank((String)typeName) && action != null) {
            MetaDataClass classMetaData = this.metaDataClasses.get(typeName.toLowerCase());
            if (classMetaData == null) {
                String message = String.format("Unable to create generic version of object {%s} because RightNow does not recognize the type.", typeName);
                log.error((Object)message);
                throw new RightNowException(message);
            }
            genericObject = new GenericObject();
            RNObjectType objectType = new RNObjectType();
            objectType.setTypeName(classMetaData.getName().getTypeName());
            objectType.setNamespace(classMetaData.getName().getNamespace());
            genericObject.setObjectType(objectType);
            List<GenericField> fields = genericObject.getGenericFields();
            Iterator<MetaDataAttribute> i$ = classMetaData.getAttributes().getMetaDataAttributeList().iterator();
            while (true) {
                if (!i$.hasNext()) {
                    return genericObject;
                }
                MetaDataAttribute attribute = i$.next();
                DataTypeEnum attributedataType = attribute.getDataType();
                if (!RightNowConverter.isObjectType(attributedataType).booleanValue() || !action.isAttributeValid(attribute).booleanValue()) continue;
                GenericField rField = new GenericField();
                rField.setName(attribute.getName());
                rField.setDataType(attributedataType);
                String attributeTypeName = RightNowConverter.getDataTypeName(attribute);
                DataValue dataValue = new DataValue();
                dataValue.setObjectValue(this.toGenericObject(attributeTypeName, action));
                rField.setDataValue(dataValue);
                fields.add(rField);
            }
        }
        String message = String.format("Unable to create generic version of object {%s} because no type or list of RightNow meta data was provided.", StringUtils.isNotBlank((String)typeName) ? typeName : "null");
        log.error((Object)message);
        throw new RightNowException(message);
    }

    public Map<String, Object> toMap(GenericObject object) {
        HashMap<String, Object> map = new HashMap<String, Object>();
        if (object != null) {
            ID genericID = object.getID();
            if (genericID != null && genericID.getId() != null && genericID.getId() != 0L) {
                map.put(RIGHTNOW_ID, genericID.getId());
            }
            for (GenericField field : object.getGenericFields()) {
                map.put(field.getName(), this.toObject(field.getDataType(), field.getDataValue()));
            }
        }
        return map;
    }

    public DataValue toDataValue(DataTypeEnum dataType, String typeName, Object object) throws DatatypeConfigurationException, RightNowException {
        DataValue returnValue = new DataValue();
        if (dataType != null && object != null) {
            switch (dataType) {
                case BASE_64_BINARY: {
                    returnValue.setBase64BinaryValue(this.toByteArray((List)object));
                    break;
                }
                case BOOLEAN: {
                    returnValue.setBooleanValue((Boolean)object);
                    break;
                }
                case BOOLEAN_LIST: {
                    returnValue.getBooleanValueList().addAll((List)object);
                    break;
                }
                case DATE: {
                    returnValue.setDateValue(this.toXMLGregorianCalendar((Date)object));
                    break;
                }
                case DATE_LIST: {
                    returnValue.getDateValueList().addAll(this.toXMLGregorianCalendarListFromDateList((List)object));
                    break;
                }
                case DATETIME: {
                    returnValue.setDateTimeValue(this.toXMLGregorianCalendar((Calendar)object));
                    break;
                }
                case DATETIME_LIST: {
                    returnValue.getDateTimeValueList().addAll(this.toXMLGregorianCalendarListFromCalendarList((List)object));
                    break;
                }
                case DECIMAL: {
                    returnValue.setDecimalValue((Double)object);
                    break;
                }
                case DECIMAL_LIST: {
                    returnValue.getDecimalValueList().addAll((List)object);
                    break;
                }
                case ID: {
                    returnValue.setIDValue(this.toID((Map)object));
                    break;
                }
                case ID_LIST: {
                    returnValue.getIDValueList().addAll(this.toIDList((List)object));
                    break;
                }
                case INTEGER: {
                    returnValue.setIntegerValue((Integer)object);
                    break;
                }
                case INTEGER_LIST: {
                    returnValue.getIntegerValueList().addAll((List)object);
                    break;
                }
                case LONG: {
                    returnValue.setLongValue((Long)object);
                    break;
                }
                case LONG_LIST: {
                    returnValue.getLongValueList().addAll((List)object);
                    break;
                }
                case NAMED_ID: {
                    returnValue.setNamedIDValue(this.toNamedID((Map)object));
                    break;
                }
                case NAMED_ID_LIST: {
                    returnValue.getNamedIDValueList().addAll(this.toNamedIDList((List)object));
                    break;
                }
                case NAMED_ID_HIERARCHY: {
                    returnValue.setNamedIDHierarchyValue(this.toNamedIDHierarchy((Map)object));
                    break;
                }
                case NAMED_ID_HIERARCHY_LIST: {
                    returnValue.getNamedIDHierarchyValueList().addAll(this.toNamedIDHierarchyList((List)object));
                    break;
                }
                case NAMED_ID_DELTA_LIST: {
                    returnValue.getNamedIDDeltaValueList().addAll(this.toNamedIDDeltaList((List)object));
                    break;
                }
                case OBJECT: {
                    returnValue.setObjectValue(this.toGenericObject(typeName, (Map)object));
                    break;
                }
                case OBJECT_LIST: {
                    returnValue.getObjectValueList().addAll(this.toGenericObjectList(typeName, (List)object));
                    break;
                }
                case STRING: {
                    returnValue.setStringValue((String)object);
                    break;
                }
                case STRING_LIST: {
                    returnValue.getStringValueList().addAll((List)object);
                    break;
                }
                default: {
                    log.error((Object)String.format("Unable to create RightNow DataValue: No matching RightNow type for ID %s.", dataType.toString()));
                }
            }
        }
        return returnValue;
    }

    public Object toObject(DataTypeEnum dataType, DataValue dataValue) {
        List<Map<String, Object>> returnValue = null;
        if (dataType != null && dataValue != null) {
            switch (dataType) {
                case BASE_64_BINARY: {
                    returnValue = this.toByteList(dataValue.getBase64BinaryValue());
                    break;
                }
                case BOOLEAN: {
                    returnValue = dataValue.getBooleanValue();
                    break;
                }
                case BOOLEAN_LIST: {
                    returnValue = dataValue.getBooleanValueList();
                    break;
                }
                case DATE: {
                    returnValue = this.toDate(dataValue.getDateValue());
                    break;
                }
                case DATE_LIST: {
                    returnValue = this.toDateList(dataValue.getDateValueList());
                    break;
                }
                case DATETIME: {
                    returnValue = this.toCalendar(dataValue.getDateTimeValue());
                    break;
                }
                case DATETIME_LIST: {
                    returnValue = this.toCalendarList(dataValue.getDateTimeValueList());
                    break;
                }
                case DECIMAL: {
                    returnValue = dataValue.getDecimalValue();
                    break;
                }
                case DECIMAL_LIST: {
                    returnValue = dataValue.getDecimalValueList();
                    break;
                }
                case ID: {
                    returnValue = this.toMap(dataValue.getIDValue());
                    break;
                }
                case ID_LIST: {
                    returnValue = this.toMapListFromIDList(dataValue.getIDValueList());
                    break;
                }
                case INTEGER: {
                    returnValue = dataValue.getIntegerValue();
                    break;
                }
                case INTEGER_LIST: {
                    returnValue = dataValue.getIntegerValueList();
                    break;
                }
                case LONG: {
                    returnValue = dataValue.getLongValue();
                    break;
                }
                case LONG_LIST: {
                    returnValue = dataValue.getLongValueList();
                    break;
                }
                case NAMED_ID: {
                    returnValue = this.toMap(dataValue.getNamedIDValue());
                    break;
                }
                case NAMED_ID_LIST: {
                    returnValue = this.toMapListFromNamedIDList(dataValue.getNamedIDValueList());
                    break;
                }
                case NAMED_ID_DELTA_LIST: {
                    returnValue = this.toMapListFromNamedIDDeltaList(dataValue.getNamedIDDeltaValueList());
                    break;
                }
                case NAMED_ID_HIERARCHY: {
                    returnValue = this.toMap(dataValue.getNamedIDHierarchyValue());
                    break;
                }
                case NAMED_ID_HIERARCHY_LIST: {
                    returnValue = this.toMapListFromNamedIDHierarchyList(dataValue.getNamedIDHierarchyValueList());
                    break;
                }
                case OBJECT: {
                    returnValue = this.toMap(dataValue.getObjectValue());
                    break;
                }
                case OBJECT_LIST: {
                    returnValue = this.toMapListFromGenericObjectList(dataValue.getObjectValueList());
                    break;
                }
                case STRING: {
                    returnValue = dataValue.getStringValue();
                    break;
                }
                case STRING_LIST: {
                    returnValue = dataValue.getStringValueList();
                    break;
                }
                default: {
                    log.error((Object)String.format("Unable to get value for RightNow DataValue: No matching RightNow type for ID %s.", dataType.toString()));
                }
            }
        }
        return returnValue;
    }

    public List<GenericObject> toGenericObjectList(String typeName, List<Map<String, Object>> maps) throws DatatypeConfigurationException, RightNowException {
        ArrayList<GenericObject> objects = new ArrayList<GenericObject>();
        if (typeName != null && maps != null) {
            for (int i = 0; i < maps.size(); ++i) {
                Map<String, Object> map = maps.get(i);
                objects.add(this.toGenericObject(typeName, map));
            }
        }
        return objects;
    }

    public Map<String, Object> toMap(ID id) {
        HashMap<String, Object> map = new HashMap<String, Object>();
        if (id != null) {
            map.put(RIGHTNOW_ID, id.getId());
        }
        return map;
    }

    public Map<String, Object> toMap(NamedID id) {
        HashMap<String, Object> map = new HashMap<String, Object>();
        if (id != null) {
            map.put(RIGHTNOW_ID, id.getID().getId());
            String name = id.getName();
            if (StringUtils.isNotBlank((String)name)) {
                map.put(RIGHTNOW_ID_NAME, name);
            }
        }
        return map;
    }

    public Map<String, Object> toMap(NamedIDDelta id) {
        HashMap<String, Object> map = new HashMap<String, Object>();
        if (id != null) {
            map.put(RIGHTNOW_ID, id.getID().getId());
            String name = id.getName();
            if (StringUtils.isNotBlank((String)name)) {
                map.put(RIGHTNOW_ID_NAME, name);
            }
        }
        return map;
    }

    public Map<String, Object> toMap(NamedIDHierarchy id) {
        HashMap<String, Object> map = new HashMap<String, Object>();
        if (id != null) {
            map.put(RIGHTNOW_ID, id.getID().getId());
            String name = id.getName();
            if (StringUtils.isNotBlank((String)name)) {
                map.put(RIGHTNOW_ID_NAME, name);
            }
        }
        return map;
    }

    public List<Byte> toByteList(byte[] bytes) {
        List<Byte> byteList = null;
        byteList = bytes != null ? Arrays.asList(ArrayUtils.toObject((byte[])bytes)) : new ArrayList<Byte>();
        return byteList;
    }

    public byte[] toByteArray(List<Byte> byteList) {
        byte[] bytes = null;
        if (byteList != null) {
            bytes = ArrayUtils.toPrimitive((Byte[])byteList.toArray(new Byte[byteList.size()]));
        }
        return bytes;
    }

    public Date toDate(XMLGregorianCalendar calendar) {
        Date date = null;
        if (calendar != null) {
            date = calendar.toGregorianCalendar().getTime();
        }
        return date;
    }

    public Calendar toCalendar(XMLGregorianCalendar xCalendar) {
        GregorianCalendar calendar = null;
        if (xCalendar != null) {
            calendar = xCalendar.toGregorianCalendar();
        }
        return calendar;
    }

    public XMLGregorianCalendar toXMLGregorianCalendar(Date date) throws DatatypeConfigurationException {
        XMLGregorianCalendar xCalendar = null;
        if (date != null) {
            GregorianCalendar gCalendar = new GregorianCalendar();
            gCalendar.setTime(date);
            xCalendar = DatatypeFactory.newInstance().newXMLGregorianCalendar(gCalendar);
        }
        return xCalendar;
    }

    public XMLGregorianCalendar toXMLGregorianCalendar(Calendar calendar) throws DatatypeConfigurationException {
        return this.toXMLGregorianCalendar(calendar.getTime());
    }

    public List<Date> toDateList(List<XMLGregorianCalendar> calendars) {
        ArrayList<Date> dates = new ArrayList<Date>();
        if (calendars != null) {
            for (XMLGregorianCalendar calendar : calendars) {
                dates.add(this.toDate(calendar));
            }
        }
        return dates;
    }

    public List<Calendar> toCalendarList(List<XMLGregorianCalendar> xmlCalendars) {
        ArrayList<Calendar> calendars = new ArrayList<Calendar>();
        if (xmlCalendars != null) {
            for (XMLGregorianCalendar xmlCalendar : xmlCalendars) {
                calendars.add(this.toCalendar(xmlCalendar));
            }
        }
        return calendars;
    }

    public List<XMLGregorianCalendar> toXMLGregorianCalendarListFromDateList(List<Date> dates) throws DatatypeConfigurationException {
        ArrayList<XMLGregorianCalendar> calendars = new ArrayList<XMLGregorianCalendar>();
        if (dates != null) {
            for (Date date : dates) {
                calendars.add(this.toXMLGregorianCalendar(date));
            }
        }
        return calendars;
    }

    public List<XMLGregorianCalendar> toXMLGregorianCalendarListFromCalendarList(List<Calendar> calendars) throws DatatypeConfigurationException {
        ArrayList<XMLGregorianCalendar> xCalendars = new ArrayList<XMLGregorianCalendar>();
        if (calendars != null) {
            for (Calendar calendar : calendars) {
                xCalendars.add(this.toXMLGregorianCalendar(calendar));
            }
        }
        return xCalendars;
    }

    public List<Map<String, Object>> toMapListFromGenericObjectList(List<GenericObject> objects) {
        ArrayList<Map<String, Object>> maps = new ArrayList<Map<String, Object>>();
        if (objects != null) {
            for (GenericObject object : objects) {
                maps.add(this.toMap(object));
            }
        }
        return maps;
    }

    public List<Map<String, Object>> toMapListFromIDList(List<ID> objects) {
        ArrayList<Map<String, Object>> maps = new ArrayList<Map<String, Object>>();
        if (objects != null) {
            for (ID object : objects) {
                maps.add(this.toMap(object));
            }
        }
        return maps;
    }

    public List<Map<String, Object>> toMapListFromNamedIDList(List<NamedID> objects) {
        ArrayList<Map<String, Object>> maps = new ArrayList<Map<String, Object>>();
        if (objects != null) {
            for (NamedID object : objects) {
                maps.add(this.toMap(object));
            }
        }
        return maps;
    }

    public List<Map<String, Object>> toMapListFromNamedIDDeltaList(List<NamedIDDelta> objects) {
        ArrayList<Map<String, Object>> maps = new ArrayList<Map<String, Object>>();
        if (objects != null) {
            for (NamedIDDelta object : objects) {
                maps.add(this.toMap(object));
            }
        }
        return maps;
    }

    public List<Map<String, Object>> toMapListFromNamedIDHierarchyList(List<NamedIDHierarchy> objects) {
        ArrayList<Map<String, Object>> maps = new ArrayList<Map<String, Object>>();
        if (objects != null) {
            for (NamedIDHierarchy object : objects) {
                maps.add(this.toMap(object));
            }
        }
        return maps;
    }

    public String toString(GenericObject object) {
        StringBuilder stringResult = new StringBuilder("\n\n----RightNow Object----");
        if (object != null) {
            stringResult.append("\nNamespace: " + object.getObjectType().getNamespace().getName().getNamespaceURI());
            stringResult.append("\nTypeName: " + object.getObjectType().getTypeName());
            stringResult.append("\nID: " + object.getID().getId().toString());
            for (GenericField field : object.getGenericFields()) {
                DataValue value;
                stringResult.append("\n--" + field.getName() + " ");
                DataTypeEnum dataType = field.getDataType();
                if (dataType != null) {
                    stringResult.append("(" + dataType.toString() + "): ");
                }
                if ((value = field.getDataValue()) == null) continue;
                stringResult.append(String.valueOf(this.toObject(dataType, value)));
            }
        }
        return stringResult.toString();
    }

    public ID toID(Long number) {
        ID newID = null;
        if (number != null) {
            newID = new ID();
            newID.setId(number);
        }
        return newID;
    }

    public ID toID(Map<String, Object> map) {
        Object idValue;
        ID id = null;
        if (map != null && (idValue = map.get(RIGHTNOW_ID.toLowerCase())) != null && idValue instanceof Long) {
            id = new ID();
            id.setId((Long)idValue);
        }
        return id;
    }

    public NamedID toNamedID(Map<String, Object> map) {
        NamedID namedId = null;
        if (map != null) {
            Object nameValue;
            Object idValue;
            Object idMap = map.get(RIGHTNOW_ID);
            if (idMap != null && idMap instanceof Map && (idValue = ((Map)idMap).get(RIGHTNOW_ID.toLowerCase())) != null && idValue instanceof Long) {
                ID id = new ID();
                id.setId((Long)idValue);
                namedId = new NamedID();
                namedId.setID(id);
            }
            if ((nameValue = map.get(RIGHTNOW_ID_NAME)) != null && nameValue instanceof String) {
                if (namedId == null) {
                    namedId = new NamedID();
                }
                namedId.setName((String)nameValue);
            }
        }
        return namedId;
    }

    public NamedIDHierarchy toNamedIDHierarchy(Map<String, Object> map) {
        NamedIDHierarchy namedId = null;
        if (map != null) {
            Object nameValue;
            Object idValue;
            Object idMap = map.get(RIGHTNOW_ID);
            if (idMap != null && idMap instanceof Map && (idValue = ((Map)idMap).get(RIGHTNOW_ID.toLowerCase())) != null && idValue instanceof Long) {
                ID id = new ID();
                id.setId((Long)idValue);
                namedId = new NamedIDHierarchy();
                namedId.setID(id);
            }
            if ((nameValue = map.get(RIGHTNOW_ID_NAME)) != null && nameValue instanceof String) {
                if (namedId == null) {
                    namedId = new NamedIDHierarchy();
                }
                namedId.setName((String)nameValue);
            }
        }
        return namedId;
    }

    public NamedIDDelta toNamedIDDelta(Map<String, Object> map) {
        NamedIDDelta namedId = null;
        if (map != null) {
            Object nameValue;
            Object idValue;
            Object idMap = map.get(RIGHTNOW_ID);
            if (idMap != null && idMap instanceof Map && (idValue = ((Map)idMap).get(RIGHTNOW_ID.toLowerCase())) != null && idValue instanceof Long) {
                ID id = new ID();
                id.setId((Long)idValue);
                namedId = new NamedIDDelta();
                namedId.setID(id);
            }
            if ((nameValue = map.get(RIGHTNOW_ID_NAME)) != null && nameValue instanceof String) {
                if (namedId == null) {
                    namedId = new NamedIDDelta();
                }
                namedId.setName((String)nameValue);
            }
        }
        return namedId;
    }

    public List<ID> toIDList(List<Map<String, Object>> maps) {
        ArrayList<ID> ids = new ArrayList<ID>();
        if (maps != null) {
            for (Map<String, Object> map : maps) {
                ids.add(this.toID(map));
            }
        }
        return ids;
    }

    public List<NamedID> toNamedIDList(List<Map<String, Object>> maps) {
        ArrayList<NamedID> namedIds = new ArrayList<NamedID>();
        if (maps != null) {
            for (Map<String, Object> map : maps) {
                namedIds.add(this.toNamedID(map));
            }
        }
        return namedIds;
    }

    public List<NamedIDHierarchy> toNamedIDHierarchyList(List<Map<String, Object>> maps) {
        ArrayList<NamedIDHierarchy> namedIds = new ArrayList<NamedIDHierarchy>();
        if (maps != null) {
            for (Map<String, Object> map : maps) {
                namedIds.add(this.toNamedIDHierarchy(map));
            }
        }
        return namedIds;
    }

    public List<NamedIDDelta> toNamedIDDeltaList(List<Map<String, Object>> maps) {
        ArrayList<NamedIDDelta> namedIds = new ArrayList<NamedIDDelta>();
        if (maps != null) {
            for (Map<String, Object> map : maps) {
                namedIds.add(this.toNamedIDDelta(map));
            }
        }
        return namedIds;
    }
}

