/*
 * Decompiled with CFR 0.152.
 */
package com.stonecobra.connectors.rightnow;

import com.stonecobra.connectors.rightnow.CreateProcessingOptions;
import com.stonecobra.connectors.rightnow.DestroyProcessingOptions;
import com.stonecobra.connectors.rightnow.GenericObject;
import com.stonecobra.connectors.rightnow.GetProcessingOptions;
import com.stonecobra.connectors.rightnow.MetaDataClass;
import com.stonecobra.connectors.rightnow.ObjectNotFoundException;
import com.stonecobra.connectors.rightnow.QueryResultData;
import com.stonecobra.connectors.rightnow.RNObject;
import com.stonecobra.connectors.rightnow.RNObjectsResult;
import com.stonecobra.connectors.rightnow.RequestErrorFault;
import com.stonecobra.connectors.rightnow.RightNowAction;
import com.stonecobra.connectors.rightnow.RightNowConverter;
import com.stonecobra.connectors.rightnow.RightNowException;
import com.stonecobra.connectors.rightnow.RightNowSyncPort;
import com.stonecobra.connectors.rightnow.RightNowSyncService;
import com.stonecobra.connectors.rightnow.ServerErrorFault;
import com.stonecobra.connectors.rightnow.UnexpectedErrorFault;
import com.stonecobra.connectors.rightnow.UpdateProcessingOptions;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.xml.datatype.DatatypeConfigurationException;
import javax.xml.namespace.QName;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.parsers.ParserConfigurationException;
import javax.xml.soap.SOAPException;
import javax.xml.ws.BindingProvider;
import org.apache.commons.lang.StringUtils;
import org.apache.cxf.binding.soap.SoapHeader;
import org.apache.cxf.headers.Header;
import org.apache.log4j.Logger;
import org.mule.common.metadata.DefaultMetaDataKey;
import org.mule.common.metadata.MetaData;
import org.mule.common.metadata.MetaDataKey;
import org.w3c.dom.Document;
import org.w3c.dom.Element;

public class RightNowProxyClient {
    private static final Logger log = Logger.getLogger((String)RightNowProxyClient.class.getName());
    private RightNowSyncPort syncPort;
    private RightNowConverter rightNowConverter;

    public void initialize(String userName, String userPassword, String url) throws SOAPException, UnexpectedErrorFault, RequestErrorFault, ServerErrorFault, ParserConfigurationException, RightNowException {
        log.debug((Object)("Connecting to RightNow as " + userName + " to URL: " + url));
        RightNowSyncService syncService = new RightNowSyncService();
        this.syncPort = syncService.getRightNowSyncPort();
        BindingProvider provider = (BindingProvider)this.syncPort;
        HashMap<String, String> nsmap = new HashMap<String, String>();
        nsmap.put("soapenv", "http://schemas.xmlsoap.org/soap/envelope/");
        nsmap.put("v1", "urn:messages.ws.rightnow.com/v1_2");
        provider.getRequestContext().put("soap.env.ns.map", nsmap);
        this.addSoapHeaders(userName, userPassword, provider);
        provider.getRequestContext().put("javax.xml.ws.service.endpoint.address", url);
        log.debug((Object)"Getting metadata objects:");
        List<MetaDataClass> metaDataClasses = this.syncPort.getMetaData();
        this.rightNowConverter = new RightNowConverter(metaDataClasses);
    }

    protected void addSoapHeaders(String userName, String password, BindingProvider provider) throws SOAPException, ParserConfigurationException {
        ArrayList<SoapHeader> headers = new ArrayList<SoapHeader>();
        DocumentBuilderFactory factory = DocumentBuilderFactory.newInstance();
        Document document = null;
        DocumentBuilder builder = null;
        builder = factory.newDocumentBuilder();
        document = builder.newDocument();
        Element clientInfoElement = document.createElementNS("urn:messages.ws.rightnow.com/v1_2", "ClientInfoHeader");
        clientInfoElement.setPrefix("v1");
        document.appendChild(clientInfoElement);
        Element appId = document.createElement("v1:AppID");
        appId.setTextContent("RN Connector");
        clientInfoElement.appendChild(appId);
        QName clientInfoHeaderName = new QName("urn:messages.ws.rightnow.com/v1_2", "ClientInfoHeader");
        SoapHeader header = new SoapHeader(clientInfoHeaderName, (Object)clientInfoElement);
        header.setActor(null);
        header.setMustUnderstand(false);
        headers.add(header);
        document = builder.newDocument();
        QName headerNameSecurity = new QName("http://docs.oasis-open.org/wss/2004/01/oasis-200401-wss-wssecurity-secext-1.0.xsd", "Security");
        SoapHeader headerSecurity = new SoapHeader(headerNameSecurity, (Object)"Security");
        Element rootSecurity = document.createElement("wsse:Security");
        rootSecurity.setAttribute("xmlns:wsse", "http://docs.oasis-open.org/wss/2004/01/oasis-200401-wss-wssecurity-secext-1.0.xsd");
        document.appendChild(rootSecurity);
        Element userTokenSecurity = document.createElement("wsse:UsernameToken");
        userTokenSecurity.setAttribute("xmlns:wsu", "http://docs.oasis-open.org/wss/2004/01/oasis-200401-wss-wssecurity-utility-1.0.xsd");
        rootSecurity.appendChild(userTokenSecurity);
        Element usernameSecurity = document.createElement("wsse:Username");
        usernameSecurity.setTextContent(userName);
        userTokenSecurity.appendChild(usernameSecurity);
        Element pwdSecurity = document.createElement("wsse:Password");
        pwdSecurity.setAttribute("Type", "http://docs.oasis-open.org/wss/2004/01/oasis-200401-wss-username-token-profile-1.0#PasswordText");
        pwdSecurity.setTextContent(password);
        userTokenSecurity.appendChild(pwdSecurity);
        headerSecurity.setObject((Object)rootSecurity);
        headers.add(headerSecurity);
        provider.getRequestContext().put(Header.HEADER_LIST, headers);
    }

    public List<Map<String, Object>> create(String typeName, List<Map<String, Object>> objects) throws UnexpectedErrorFault, RequestErrorFault, ServerErrorFault, DatatypeConfigurationException, RightNowException {
        ArrayList<Map<String, Object>> createdObjects = new ArrayList<Map<String, Object>>();
        log.debug((Object)("Creating {" + (objects != null ? Integer.valueOf(objects.size()) : "null") + "} " + typeName + "objects."));
        List<RNObject> genericObjects = this.rightNowConverter.toGenericObjectList(typeName, objects);
        if (genericObjects != null && !genericObjects.isEmpty()) {
            List<RNObject> rnObjects = genericObjects;
            RNObjectsResult rnResult = this.createObjects(rnObjects);
            List<RNObject> resultObjects = rnResult.getRNObjects();
            log.debug((Object)"\nCreated RightNow objects:");
            for (RNObject resultObject : resultObjects) {
                GenericObject genericObject = (GenericObject)resultObject;
                log.debug((Object)this.rightNowConverter.toString(genericObject));
                createdObjects.add(this.rightNowConverter.toMap(genericObject));
            }
        } else {
            throw new RightNowException("Unable to create GenericObjects for Create.");
        }
        return createdObjects;
    }

    public void update(String typeName, List<Map<String, Object>> objects) throws UnexpectedErrorFault, RequestErrorFault, ServerErrorFault, DatatypeConfigurationException, RightNowException {
        log.debug((Object)("Updating {" + (objects != null ? Integer.valueOf(objects.size()) : "null") + "} " + typeName + "objects."));
        List<RNObject> genericObjects = this.rightNowConverter.toGenericObjectList(typeName, objects);
        if (genericObjects != null && !genericObjects.isEmpty()) {
            List<RNObject> rnObjects = genericObjects;
            try {
                this.updateObjects(rnObjects);
            }
            catch (RequestErrorFault e) {
                switch (e.getFaultInfo().exceptionCode) {
                    case BAD_ID: {
                        throw new ObjectNotFoundException(e.getMessage(), e);
                    }
                }
                throw new RightNowException(e.getMessage(), e);
            }
            catch (Exception e) {
                throw new RightNowException(e.getMessage(), e);
            }
        } else {
            throw new RightNowException("Unable to create GenericObjects for Update.");
        }
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public List<Map<String, Object>> get(String typeName, List<Long> ids) throws UnexpectedErrorFault, ServerErrorFault, RightNowException {
        log.debug((Object)("Getting {" + (ids != null ? Integer.valueOf(ids.size()) : "null") + "} " + typeName + "objects."));
        ArrayList<Map<String, Object>> objectMaps = new ArrayList<Map<String, Object>>();
        if (ids == null || ids.isEmpty()) throw new RightNowException(String.format("No IDs were provided to get %s objects; however, these are required.", typeName));
        ArrayList<RNObject> genericObjects = new ArrayList<RNObject>();
        for (Long id : ids) {
            GenericObject genericObject = this.rightNowConverter.toGenericObject(typeName, RightNowAction.GET);
            genericObject.setID(this.rightNowConverter.toID(id));
            genericObjects.add(genericObject);
        }
        if (genericObjects == null || genericObjects.isEmpty()) throw new RightNowException("Unable to create GenericObjects for Get.");
        try {
            ArrayList<RNObject> rnObjects = genericObjects;
            RNObjectsResult rnResult = this.getObjects(rnObjects);
            List<RNObject> resultObjects = rnResult.getRNObjects();
            for (RNObject resultObject : resultObjects) {
                GenericObject genericObject = (GenericObject)resultObject;
                objectMaps.add(this.rightNowConverter.toMap(genericObject));
            }
            return objectMaps;
        }
        catch (RequestErrorFault e) {
            switch (e.getFaultInfo().exceptionCode) {
                case BAD_ID: {
                    throw new ObjectNotFoundException(e.getMessage(), e);
                }
            }
            throw new RightNowException(e.getMessage(), e);
        }
    }

    public List<Map<String, Object>> upsert(String typeName, List<Map<String, Object>> objects) throws UnexpectedErrorFault, RequestErrorFault, ServerErrorFault, DatatypeConfigurationException, RightNowException {
        ArrayList<Map<String, Object>> createdObjects = new ArrayList();
        log.debug((Object)("Upserting {" + (objects != null ? Integer.valueOf(objects.size()) : "null") + "} " + typeName + "objects."));
        if (objects != null && !objects.isEmpty() && StringUtils.isNotBlank((String)typeName)) {
            ArrayList<Map<String, Object>> createObjects = new ArrayList<Map<String, Object>>();
            ArrayList<Map<String, Object>> updateObjects = new ArrayList<Map<String, Object>>();
            for (Map<String, Object> object : objects) {
                Map id = (Map)object.get("ID");
                if (id != null && id.get("id") != null && (Long)id.get("id") != 0L) {
                    updateObjects.add(object);
                    continue;
                }
                createObjects.add(object);
            }
            if (!createObjects.isEmpty()) {
                createdObjects = this.create(typeName, createObjects);
            } else {
                log.debug((Object)"Upsert: No objects to create");
            }
            if (!updateObjects.isEmpty()) {
                this.update(typeName, updateObjects);
            } else {
                log.debug((Object)"Upsert: No objects to create");
            }
        } else {
            throw new RightNowException("Upsert called with null objects parameters");
        }
        return createdObjects;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public void destroy(String typeName, List<Long> ids) throws UnexpectedErrorFault, RequestErrorFault, ServerErrorFault, RightNowException {
        log.debug((Object)("Deleting {" + (ids != null ? Integer.valueOf(ids.size()) : "null") + "} " + typeName + "objects."));
        if (ids == null || ids.isEmpty() || typeName == null || typeName.isEmpty()) throw new RightNowException("No IDs were provided; however, these are required.");
        ArrayList<RNObject> genericObjects = new ArrayList<RNObject>();
        for (Long id : ids) {
            GenericObject genericObject = this.rightNowConverter.toGenericObject(typeName, RightNowAction.DESTROY);
            genericObject.setID(this.rightNowConverter.toID(id));
            genericObjects.add(genericObject);
        }
        if (genericObjects == null || genericObjects.isEmpty()) throw new RightNowException("Unable to create GenericObjects for Destroy.");
        try {
            ArrayList<RNObject> rnObjects = genericObjects;
            this.destroyObjects(rnObjects);
            return;
        }
        catch (RequestErrorFault e) {
            switch (e.getFaultInfo().exceptionCode) {
                case BAD_ID: {
                    throw new ObjectNotFoundException(e.getMessage(), e);
                }
            }
            throw new RightNowException(e.getMessage(), e);
        }
    }

    public List<Map<String, Object>> query(String typeName, String query, int maxRecords) throws UnexpectedErrorFault, RequestErrorFault, ServerErrorFault, RightNowException {
        log.debug((Object)String.format("Querying RightNow for objects: %s", query));
        ArrayList<Map<String, Object>> fieldMaps = new ArrayList<Map<String, Object>>();
        GenericObject genericObjectTemplate = this.rightNowConverter.toGenericObject(typeName, RightNowAction.GET);
        ArrayList<RNObject> templates = new ArrayList<RNObject>();
        templates.add(genericObjectTemplate);
        List<QueryResultData> rnObjectsResult = this.queryObjects(query, templates, maxRecords);
        for (QueryResultData queryData : rnObjectsResult) {
            RNObjectsResult r = queryData.getRNObjectsResult();
            List<RNObject> rnObjects = r.getRNObjects();
            for (RNObject rnObject : rnObjects) {
                GenericObject genericObject = (GenericObject)rnObject;
                fieldMaps.add(this.rightNowConverter.toMap(genericObject));
            }
        }
        return fieldMaps;
    }

    public List<MetaDataKey> getMetaDataEntityKeys() {
        ArrayList<MetaDataKey> metaDataKeys = new ArrayList<MetaDataKey>();
        for (String typeName : this.rightNowConverter.getPrimaryObjectTypeNames()) {
            DefaultMetaDataKey key = new DefaultMetaDataKey(typeName, typeName);
            metaDataKeys.add((MetaDataKey)key);
        }
        return metaDataKeys;
    }

    public MetaData getMetaDataEntity(MetaDataKey entityKey) throws RightNowException {
        String typeName = null;
        String entityId = entityKey.getId();
        String entityName = entityKey.getDisplayName();
        if (entityId != null) {
            typeName = entityId;
        } else if (entityName != null) {
            typeName = entityName;
        } else {
            throw new RightNowException("No valid entity was provided");
        }
        MetaData muleMetaData = this.rightNowConverter.toMuleMetaData(typeName);
        if (muleMetaData == null) {
            throw new RightNowException(String.format("Unable to create DataSense for entity [id:%s, name:%s].", entityId, entityName));
        }
        return muleMetaData;
    }

    private RNObjectsResult createObjects(List<RNObject> objects) throws UnexpectedErrorFault, RequestErrorFault, ServerErrorFault {
        CreateProcessingOptions options = new CreateProcessingOptions();
        options.setSuppressExternalEvents(false);
        options.setSuppressRules(false);
        return this.syncPort.create(objects, options);
    }

    private RNObjectsResult getObjects(List<RNObject> objects) throws UnexpectedErrorFault, RequestErrorFault, ServerErrorFault {
        GetProcessingOptions options = new GetProcessingOptions();
        options.setFetchAllNames(true);
        return this.syncPort.get(objects, options);
    }

    private void updateObjects(List<RNObject> objects) throws UnexpectedErrorFault, RequestErrorFault, ServerErrorFault {
        UpdateProcessingOptions options = new UpdateProcessingOptions();
        options.setSuppressExternalEvents(false);
        options.setSuppressRules(false);
        this.syncPort.update(objects, options);
    }

    private void destroyObjects(List<RNObject> objects) throws UnexpectedErrorFault, RequestErrorFault, ServerErrorFault {
        DestroyProcessingOptions options = new DestroyProcessingOptions();
        options.setSuppressExternalEvents(false);
        options.setSuppressRules(false);
        this.syncPort.destroy(objects, options);
    }

    private List<QueryResultData> queryObjects(String query, List<RNObject> templates, int maxRecords) throws UnexpectedErrorFault, RequestErrorFault, ServerErrorFault {
        return this.syncPort.queryObjects(query, templates, maxRecords);
    }
}

