/*
 * Decompiled with CFR 0.152.
 */
package com.stonecobra.connectors.rightnow.config;

import com.stonecobra.connectors.rightnow.config.CreateDefinitionParser;
import com.stonecobra.connectors.rightnow.config.DeleteDefinitionParser;
import com.stonecobra.connectors.rightnow.config.GetDefinitionParser;
import com.stonecobra.connectors.rightnow.config.QueryDefinitionParser;
import com.stonecobra.connectors.rightnow.config.RightNowConnectorConfigDefinitionParser;
import com.stonecobra.connectors.rightnow.config.UpdateDefinitionParser;
import com.stonecobra.connectors.rightnow.config.UpsertDefinitionParser;
import org.mule.config.MuleManifest;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.FatalBeanException;
import org.springframework.beans.factory.xml.BeanDefinitionParser;
import org.springframework.beans.factory.xml.NamespaceHandlerSupport;

public class RightnowNamespaceHandler
extends NamespaceHandlerSupport {
    private static Logger logger = LoggerFactory.getLogger(RightnowNamespaceHandler.class);

    private void handleException(String beanName, String beanScope, NoClassDefFoundError noClassDefFoundError) {
        String muleVersion = "";
        try {
            muleVersion = MuleManifest.getProductVersion();
        }
        catch (Exception _x) {
            logger.error("Problem while reading mule version");
        }
        logger.error("Cannot launch the mule app, the  " + beanScope + " [" + beanName + "] within the connector [rightnow] is not supported in mule " + muleVersion);
        throw new FatalBeanException("Cannot launch the mule app, the  " + beanScope + " [" + beanName + "] within the connector [rightnow] is not supported in mule " + muleVersion, (Throwable)noClassDefFoundError);
    }

    public void init() {
        try {
            this.registerBeanDefinitionParser("config", (BeanDefinitionParser)new RightNowConnectorConfigDefinitionParser());
        }
        catch (NoClassDefFoundError ex) {
            this.handleException("config", "@Config", ex);
        }
        try {
            this.registerBeanDefinitionParser("get", (BeanDefinitionParser)new GetDefinitionParser());
        }
        catch (NoClassDefFoundError ex) {
            this.handleException("get", "@Processor", ex);
        }
        try {
            this.registerBeanDefinitionParser("query", (BeanDefinitionParser)new QueryDefinitionParser());
        }
        catch (NoClassDefFoundError ex) {
            this.handleException("query", "@Processor", ex);
        }
        try {
            this.registerBeanDefinitionParser("create", (BeanDefinitionParser)new CreateDefinitionParser());
        }
        catch (NoClassDefFoundError ex) {
            this.handleException("create", "@Processor", ex);
        }
        try {
            this.registerBeanDefinitionParser("upsert", (BeanDefinitionParser)new UpsertDefinitionParser());
        }
        catch (NoClassDefFoundError ex) {
            this.handleException("upsert", "@Processor", ex);
        }
        try {
            this.registerBeanDefinitionParser("update", (BeanDefinitionParser)new UpdateDefinitionParser());
        }
        catch (NoClassDefFoundError ex) {
            this.handleException("update", "@Processor", ex);
        }
        try {
            this.registerBeanDefinitionParser("delete", (BeanDefinitionParser)new DeleteDefinitionParser());
        }
        catch (NoClassDefFoundError ex) {
            this.handleException("delete", "@Processor", ex);
        }
    }
}

