/*
 * Decompiled with CFR 0.152.
 */
package com.stonecobra.connectors.rightnow.connectivity;

import com.stonecobra.connectors.rightnow.adapters.RightNowConnectorConnectionIdentifierAdapter;
import com.stonecobra.connectors.rightnow.connectivity.RightNowConnectorConnectionKey;
import com.stonecobra.connectors.rightnow.connectivity.RightNowConnectorConnectionManager;
import org.apache.commons.pool.KeyedPoolableObjectFactory;
import org.mule.api.context.MuleContextAware;
import org.mule.api.lifecycle.Disposable;
import org.mule.api.lifecycle.Initialisable;
import org.mule.api.lifecycle.Startable;
import org.mule.api.lifecycle.Stoppable;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class RightNowConnectorConnectionFactory
implements KeyedPoolableObjectFactory {
    private static Logger logger = LoggerFactory.getLogger(RightNowConnectorConnectionFactory.class);
    private RightNowConnectorConnectionManager connectionManager;

    public RightNowConnectorConnectionFactory(RightNowConnectorConnectionManager connectionManager) {
        this.connectionManager = connectionManager;
    }

    public Object makeObject(Object key) throws Exception {
        if (!(key instanceof RightNowConnectorConnectionKey)) {
            if (key == null) {
                logger.warn("Connection key is null");
            } else {
                logger.warn("Cannot cast key of type ".concat(key.getClass().getName().concat(" to ").concat("com.stonecobra.connectors.rightnow.connectivity.RightNowConnectorConnectionKey")));
            }
            throw new RuntimeException("Invalid key type ".concat(key.getClass().getName()));
        }
        RightNowConnectorConnectionIdentifierAdapter connector = new RightNowConnectorConnectionIdentifierAdapter();
        if (connector instanceof MuleContextAware) {
            ((MuleContextAware)connector).setMuleContext(this.connectionManager.getMuleContext());
        }
        if (connector instanceof Initialisable) {
            connector.initialise();
        }
        if (connector instanceof Startable) {
            connector.start();
        }
        if (!connector.isConnected()) {
            connector.connect(((RightNowConnectorConnectionKey)key).getUsername(), ((RightNowConnectorConnectionKey)key).getPassword(), ((RightNowConnectorConnectionKey)key).getUrl());
        }
        return connector;
    }

    public void destroyObject(Object key, Object obj) throws Exception {
        if (!(key instanceof RightNowConnectorConnectionKey)) {
            if (key == null) {
                logger.warn("Connection key is null");
            } else {
                logger.warn("Cannot cast key of type ".concat(key.getClass().getName().concat(" to ").concat("com.stonecobra.connectors.rightnow.connectivity.RightNowConnectorConnectionKey")));
            }
            throw new RuntimeException("Invalid key type ".concat(key.getClass().getName()));
        }
        if (!(obj instanceof RightNowConnectorConnectionIdentifierAdapter)) {
            if (obj == null) {
                logger.warn("Connector is null");
            } else {
                logger.warn("Cannot cast connector of type ".concat(obj.getClass().getName().concat(" to ").concat("com.stonecobra.connectors.rightnow.adapters.RightNowConnectorConnectionIdentifierAdapter")));
            }
            throw new RuntimeException("Invalid connector type ".concat(obj.getClass().getName()));
        }
        try {
            ((RightNowConnectorConnectionIdentifierAdapter)obj).disconnect();
        }
        catch (Exception e) {
            throw e;
        }
        finally {
            if ((RightNowConnectorConnectionIdentifierAdapter)obj instanceof Stoppable) {
                ((Stoppable)obj).stop();
            }
            if ((RightNowConnectorConnectionIdentifierAdapter)obj instanceof Disposable) {
                ((Disposable)obj).dispose();
            }
        }
    }

    public boolean validateObject(Object key, Object obj) {
        if (!(obj instanceof RightNowConnectorConnectionIdentifierAdapter)) {
            if (obj == null) {
                logger.warn("Connector is null");
            } else {
                logger.warn("Cannot cast connector of type ".concat(obj.getClass().getName().concat(" to ").concat("com.stonecobra.connectors.rightnow.adapters.RightNowConnectorConnectionIdentifierAdapter")));
            }
            throw new RuntimeException("Invalid connector type ".concat(obj.getClass().getName()));
        }
        try {
            return ((RightNowConnectorConnectionIdentifierAdapter)obj).isConnected();
        }
        catch (Exception e) {
            logger.error(e.getMessage(), (Throwable)e);
            return false;
        }
    }

    public void activateObject(Object key, Object obj) throws Exception {
        if (!(key instanceof RightNowConnectorConnectionKey)) {
            throw new RuntimeException("Invalid key type");
        }
        if (!(obj instanceof RightNowConnectorConnectionIdentifierAdapter)) {
            throw new RuntimeException("Invalid connector type");
        }
        if (!((RightNowConnectorConnectionIdentifierAdapter)obj).isConnected()) {
            ((RightNowConnectorConnectionIdentifierAdapter)obj).connect(((RightNowConnectorConnectionKey)key).getUsername(), ((RightNowConnectorConnectionKey)key).getPassword(), ((RightNowConnectorConnectionKey)key).getUrl());
        }
    }

    public void passivateObject(Object key, Object obj) throws Exception {
    }
}

