/*
 * Decompiled with CFR 0.152.
 */
package com.stoyanr.evictor.scheduler;

import com.stoyanr.evictor.EvictionQueue;
import com.stoyanr.evictor.map.EvictibleEntry;
import com.stoyanr.evictor.scheduler.AbstractQueueEvictionScheduler;

public class SingleThreadEvictionScheduler<K, V>
extends AbstractQueueEvictionScheduler<K, V> {
    private volatile boolean finished = false;
    private volatile boolean notified = false;
    private volatile long next = 0L;
    private final Thread evictionThread = new Thread(new EvictionThread());
    private final Object mutex = new Object();

    public SingleThreadEvictionScheduler() {
        this.evictionThread.start();
    }

    public SingleThreadEvictionScheduler(EvictionQueue<K, V> queue) {
        super(queue);
        this.evictionThread.start();
    }

    @Override
    public void shutdown() {
        this.finished = true;
        this.evictionThread.interrupt();
        try {
            this.evictionThread.join();
        }
        catch (InterruptedException interruptedException) {
            // empty catch block
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    protected void onScheduleEviction(EvictibleEntry<K, V> e) {
        if (this.getNextEvictionTime() != this.next) {
            Object object = this.mutex;
            synchronized (object) {
                this.notified = true;
                this.mutex.notifyAll();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    protected void onCancelEviction(EvictibleEntry<K, V> e) {
        if (this.getNextEvictionTime() != this.next) {
            Object object = this.mutex;
            synchronized (object) {
                this.notified = true;
                this.mutex.notifyAll();
            }
        }
    }

    @Override
    protected void onEvictEntries() {
    }

    final class EvictionThread
    implements Runnable {
        EvictionThread() {
        }

        @Override
        public void run() {
            while (!SingleThreadEvictionScheduler.this.finished) {
                SingleThreadEvictionScheduler.this.next = SingleThreadEvictionScheduler.this.getNextEvictionTime();
                long timeout = this.calcTimeout(SingleThreadEvictionScheduler.this.next);
                while (timeout >= 0L && !this.waitFor(timeout) && !SingleThreadEvictionScheduler.this.finished) {
                    SingleThreadEvictionScheduler.this.next = SingleThreadEvictionScheduler.this.getNextEvictionTime();
                    timeout = this.calcTimeout(SingleThreadEvictionScheduler.this.next);
                }
                SingleThreadEvictionScheduler.this.evictEntries();
            }
        }

        private long calcTimeout(long time) {
            if (time > 0L) {
                long x = time - System.nanoTime();
                return x != 0L ? x : -1L;
            }
            return 0L;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private boolean waitFor(long timeout) {
            boolean result = true;
            try {
                Object object = SingleThreadEvictionScheduler.this.mutex;
                synchronized (object) {
                    SingleThreadEvictionScheduler.this.notified = false;
                    SingleThreadEvictionScheduler.this.mutex.wait(timeout / 1000000L, (int)(timeout % 1000000L));
                    result = !SingleThreadEvictionScheduler.this.notified;
                }
            }
            catch (InterruptedException e) {
                result = false;
            }
            return result;
        }
    }
}

