/*
 * Licensed to STRATIO (C) under one or more contributor license agreements.
 * See the NOTICE file distributed with this work for additional information
 * regarding copyright ownership.  The STRATIO (C) licenses this file
 * to you under the Apache License, Version 2.0 (the
 * "License"); you may not use this file except in compliance
 * with the License.  You may obtain a copy of the License at
 *
 *   http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing,
 * software distributed under the License is distributed on an
 * "AS IS" BASIS, WITHOUT WARRANTIES OR CONDITIONS OF ANY
 * KIND, either express or implied.  See the License for the
 * specific language governing permissions and limitations
 * under the License.
 */

package com.stratio.cassandra.lucene.builder.index.schema.analysis;

import org.codehaus.jackson.annotate.JsonCreator;
import org.codehaus.jackson.annotate.JsonProperty;

/**
 * {@link Analyzer} using a Lucene's {@code Analyzer}s in classpath.
 *
 * It's uses the {@code Analyzer}'s default (no args) constructor.
 *
 * @author Andres de la Pena {@literal <adelapena@stratio.com>}
 */
public class ClasspathAnalyzer extends Analyzer {

    @JsonProperty("class")
    final String className;

    /**
     * Builds a new {@link Analyzer} using the specified {@code Analyzer} full class name.
     *
     * @param className An {@code Analyzer} full class name.
     */
    @JsonCreator
    public ClasspathAnalyzer(@JsonProperty("class") String className) {
        this.className = className;

    }
}
