/*
 * Decompiled with CFR 0.152.
 */
package com.stratio.cassandra.lucene.builder;

import com.stratio.cassandra.lucene.builder.BuilderException;
import com.stratio.cassandra.lucene.builder.common.GeoTransformation;
import com.stratio.cassandra.lucene.builder.index.Index;
import com.stratio.cassandra.lucene.builder.index.schema.Schema;
import com.stratio.cassandra.lucene.builder.index.schema.analysis.ClasspathAnalyzer;
import com.stratio.cassandra.lucene.builder.index.schema.analysis.SnowballAnalyzer;
import com.stratio.cassandra.lucene.builder.index.schema.mapping.BigDecimalMapper;
import com.stratio.cassandra.lucene.builder.index.schema.mapping.BigIntegerMapper;
import com.stratio.cassandra.lucene.builder.index.schema.mapping.BitemporalMapper;
import com.stratio.cassandra.lucene.builder.index.schema.mapping.BlobMapper;
import com.stratio.cassandra.lucene.builder.index.schema.mapping.BooleanMapper;
import com.stratio.cassandra.lucene.builder.index.schema.mapping.DateMapper;
import com.stratio.cassandra.lucene.builder.index.schema.mapping.DateRangeMapper;
import com.stratio.cassandra.lucene.builder.index.schema.mapping.DoubleMapper;
import com.stratio.cassandra.lucene.builder.index.schema.mapping.FloatMapper;
import com.stratio.cassandra.lucene.builder.index.schema.mapping.GeoPointMapper;
import com.stratio.cassandra.lucene.builder.index.schema.mapping.GeoShapeMapper;
import com.stratio.cassandra.lucene.builder.index.schema.mapping.InetMapper;
import com.stratio.cassandra.lucene.builder.index.schema.mapping.IntegerMapper;
import com.stratio.cassandra.lucene.builder.index.schema.mapping.LongMapper;
import com.stratio.cassandra.lucene.builder.index.schema.mapping.StringMapper;
import com.stratio.cassandra.lucene.builder.index.schema.mapping.TextMapper;
import com.stratio.cassandra.lucene.builder.index.schema.mapping.UUIDMapper;
import com.stratio.cassandra.lucene.builder.search.Search;
import com.stratio.cassandra.lucene.builder.search.condition.AllCondition;
import com.stratio.cassandra.lucene.builder.search.condition.BitemporalCondition;
import com.stratio.cassandra.lucene.builder.search.condition.BooleanCondition;
import com.stratio.cassandra.lucene.builder.search.condition.ContainsCondition;
import com.stratio.cassandra.lucene.builder.search.condition.DateRangeCondition;
import com.stratio.cassandra.lucene.builder.search.condition.FuzzyCondition;
import com.stratio.cassandra.lucene.builder.search.condition.GeoBBoxCondition;
import com.stratio.cassandra.lucene.builder.search.condition.GeoDistanceCondition;
import com.stratio.cassandra.lucene.builder.search.condition.GeoShapeCondition;
import com.stratio.cassandra.lucene.builder.search.condition.LuceneCondition;
import com.stratio.cassandra.lucene.builder.search.condition.MatchCondition;
import com.stratio.cassandra.lucene.builder.search.condition.NoneCondition;
import com.stratio.cassandra.lucene.builder.search.condition.PhraseCondition;
import com.stratio.cassandra.lucene.builder.search.condition.PrefixCondition;
import com.stratio.cassandra.lucene.builder.search.condition.RangeCondition;
import com.stratio.cassandra.lucene.builder.search.condition.RegexpCondition;
import com.stratio.cassandra.lucene.builder.search.condition.WildcardCondition;
import com.stratio.cassandra.lucene.builder.search.sort.GeoDistanceSortField;
import com.stratio.cassandra.lucene.builder.search.sort.SimpleSortField;
import java.io.IOException;
import org.codehaus.jackson.JsonGenerator;
import org.codehaus.jackson.JsonParser;
import org.codehaus.jackson.map.ObjectMapper;
import org.codehaus.jackson.map.SerializationConfig;
import org.codehaus.jackson.map.annotate.JsonSerialize;

public abstract class Builder {
    private static final ObjectMapper jsonMapper = new ObjectMapper();

    public String toString() {
        return this.build();
    }

    public String build() {
        try {
            return jsonMapper.writeValueAsString((Object)this);
        }
        catch (IOException e) {
            throw new BuilderException(e, "Error formatting JSON", new Object[0]);
        }
    }

    public static Index index(String table, String column) {
        return new Index(table, column);
    }

    public static Index index(String keyspace, String table, String column) {
        return new Index(table, column).keyspace(keyspace);
    }

    public static Schema schema() {
        return new Schema();
    }

    public static BigDecimalMapper bigDecimalMapper() {
        return new BigDecimalMapper();
    }

    public static BigIntegerMapper bigIntegerMapper() {
        return new BigIntegerMapper();
    }

    public static BitemporalMapper bitemporalMapper(String vtFrom, String vtTo, String ttFrom, String ttTo) {
        return new BitemporalMapper(vtFrom, vtTo, ttFrom, ttTo);
    }

    public static BlobMapper blobMapper() {
        return new BlobMapper();
    }

    public static BooleanMapper booleanMapper() {
        return new BooleanMapper();
    }

    public static DateMapper dateMapper() {
        return new DateMapper();
    }

    public static DateRangeMapper dateRangeMapper(String from, String to) {
        return new DateRangeMapper(from, to);
    }

    public static DoubleMapper doubleMapper() {
        return new DoubleMapper();
    }

    public static FloatMapper floatMapper() {
        return new FloatMapper();
    }

    public static GeoPointMapper geoPointMapper(String latitude, String longitude) {
        return new GeoPointMapper(latitude, longitude);
    }

    public static GeoShapeMapper geoShapeMapper() {
        return new GeoShapeMapper();
    }

    public static InetMapper inetMapper() {
        return new InetMapper();
    }

    public static IntegerMapper integerMapper() {
        return new IntegerMapper();
    }

    public static LongMapper longMapper() {
        return new LongMapper();
    }

    public static StringMapper stringMapper() {
        return new StringMapper();
    }

    public static TextMapper textMapper() {
        return new TextMapper();
    }

    public static UUIDMapper uuidMapper() {
        return new UUIDMapper();
    }

    public static ClasspathAnalyzer classpathAnalyzer(String className) {
        return new ClasspathAnalyzer(className);
    }

    public static SnowballAnalyzer snowballAnalyzer(String language) {
        return new SnowballAnalyzer(language);
    }

    public static Search search() {
        return new Search();
    }

    public static AllCondition all() {
        return new AllCondition();
    }

    public static BitemporalCondition bitemporal(String field) {
        return new BitemporalCondition(field);
    }

    public static BooleanCondition bool() {
        return new BooleanCondition();
    }

    public static ContainsCondition contains(String field, Object ... values) {
        return new ContainsCondition(field, values);
    }

    public static FuzzyCondition fuzzy(String field, String value) {
        return new FuzzyCondition(field, value);
    }

    public static LuceneCondition lucene(String query) {
        return new LuceneCondition(query);
    }

    public static MatchCondition match(String field, Object value) {
        return new MatchCondition(field, value);
    }

    public static NoneCondition none() {
        return new NoneCondition();
    }

    public static PhraseCondition phrase(String field, String value) {
        return new PhraseCondition(field, value);
    }

    public static PrefixCondition prefix(String field, String value) {
        return new PrefixCondition(field, value);
    }

    public static RangeCondition range(String field) {
        return new RangeCondition(field);
    }

    public static RegexpCondition regexp(String field, String value) {
        return new RegexpCondition(field, value);
    }

    public static WildcardCondition wildcard(String field, String value) {
        return new WildcardCondition(field, value);
    }

    public static GeoBBoxCondition geoBBox(String field, double minLongitude, double maxLongitude, double minLatitude, double maxLatitude) {
        return new GeoBBoxCondition(field, minLatitude, maxLatitude, minLongitude, maxLongitude);
    }

    public static GeoDistanceCondition geoDistance(String field, double latitude, double longitude, String maxDistance) {
        return new GeoDistanceCondition(field, latitude, longitude, maxDistance);
    }

    public static GeoShapeCondition geoShape(String field, String shape) {
        return new GeoShapeCondition(field, shape);
    }

    public static GeoTransformation.BBox bboxGeoTransformation() {
        return new GeoTransformation.BBox();
    }

    public static GeoTransformation.Buffer bufferGeoTransformation() {
        return new GeoTransformation.Buffer();
    }

    public static GeoTransformation.Centroid centroidGeoTransformation() {
        return new GeoTransformation.Centroid();
    }

    public static GeoTransformation.ConvexHull convexHullGeoTransformation() {
        return new GeoTransformation.ConvexHull();
    }

    public static GeoTransformation.Difference differenceGeoTransformation(String shape) {
        return new GeoTransformation.Difference(shape);
    }

    public static GeoTransformation.Intersection intersectionGeoTransformation(String shape) {
        return new GeoTransformation.Intersection(shape);
    }

    public static GeoTransformation.Union unionGeoTransformation(String shape) {
        return new GeoTransformation.Union(shape);
    }

    public static DateRangeCondition dateRange(String field) {
        return new DateRangeCondition(field);
    }

    public static SimpleSortField field(String field) {
        return new SimpleSortField(field);
    }

    public static GeoDistanceSortField geoDistanceSortField(String mapper, double latitude, double longitude) {
        return new GeoDistanceSortField(mapper, longitude, latitude);
    }

    static {
        jsonMapper.configure(JsonGenerator.Feature.QUOTE_FIELD_NAMES, true);
        jsonMapper.configure(JsonParser.Feature.ALLOW_UNQUOTED_FIELD_NAMES, true);
        jsonMapper.configure(SerializationConfig.Feature.AUTO_DETECT_IS_GETTERS, false);
        jsonMapper.setSerializationInclusion(JsonSerialize.Inclusion.NON_NULL);
    }
}

