/*
 * Decompiled with CFR 0.152.
 */
package com.stratio.cassandra.lucene;

import com.stratio.cassandra.lucene.IndexConfig;
import com.stratio.cassandra.lucene.IndexException;
import com.stratio.cassandra.lucene.IndexQueryHandler;
import com.stratio.cassandra.lucene.IndexSearcher;
import com.stratio.cassandra.lucene.service.RowService;
import java.io.File;
import java.lang.reflect.Field;
import java.nio.ByteBuffer;
import java.util.Set;
import org.apache.cassandra.config.CFMetaData;
import org.apache.cassandra.config.ColumnDefinition;
import org.apache.cassandra.config.DatabaseDescriptor;
import org.apache.cassandra.config.Schema;
import org.apache.cassandra.db.ColumnFamily;
import org.apache.cassandra.db.ColumnFamilyStore;
import org.apache.cassandra.db.DecoratedKey;
import org.apache.cassandra.db.composites.CellName;
import org.apache.cassandra.db.index.PerRowSecondaryIndex;
import org.apache.cassandra.db.index.SecondaryIndexSearcher;
import org.apache.cassandra.exceptions.ConfigurationException;
import org.apache.cassandra.exceptions.InvalidRequestException;
import org.apache.cassandra.io.util.FileUtils;
import org.apache.cassandra.service.ClientState;
import org.apache.cassandra.utils.concurrent.OpOrder;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class Index
extends PerRowSecondaryIndex {
    private static final Logger logger = LoggerFactory.getLogger(Index.class);
    private ColumnDefinition columnDefinition;
    private String indexName;
    private IndexConfig indexConfig;
    private String name;
    private RowService service;
    private boolean isExcluded;

    public ColumnDefinition getColumnDefinition() {
        return this.columnDefinition;
    }

    public String getIndexName() {
        return this.indexName;
    }

    public void init() {
        logger.info("Initializing Lucene index");
        try {
            this.columnDefinition = (ColumnDefinition)this.columnDefs.iterator().next();
            this.indexName = this.columnDefinition.getIndexName();
            this.indexConfig = this.newIndexConfig();
            this.name = this.indexConfig.getName();
            this.service = RowService.build(this.baseCfs, this.indexConfig);
            logger.info("Initialized index {}", (Object)this.name);
            this.isExcluded = this.indexConfig.getExcludedDataCenters().contains(DatabaseDescriptor.getLocalDataCenter());
            if (this.isExcluded) {
                logger.info("All writes to this index will be ignored");
            }
        }
        catch (Exception e) {
            logger.error("Error initializing Lucene index " + this.name, (Throwable)e);
        }
    }

    public void index(ByteBuffer key, ColumnFamily columnFamily) {
        if (!this.isExcluded) {
            logger.debug("Indexing row in Lucene index {}", (Object)this.name);
            try {
                long timestamp = System.currentTimeMillis();
                this.service.index(key, columnFamily, timestamp);
            }
            catch (Exception e) {
                logger.error("Error indexing row in Lucene index " + this.name, (Throwable)e);
            }
        } else {
            logger.debug("Ignoring excluded indexing in Lucene index {}", (Object)this.name);
        }
    }

    public void delete(DecoratedKey key, OpOrder.Group opGroup) {
        if (!this.isExcluded) {
            logger.debug("Removing row from Lucene index {}", (Object)this.name);
            try {
                this.service.delete(key);
            }
            catch (Exception e) {
                logger.error("Error deleting row in Lucene index " + this.name, (Throwable)e);
            }
        } else {
            logger.debug("Ignoring excluded deletion in Lucene index {}", (Object)this.name);
        }
    }

    public boolean indexes(CellName cellName) {
        return true;
    }

    public void validateOptions() throws ConfigurationException {
        logger.debug("Validating Lucene index options");
        try {
            this.newIndexConfig();
            logger.debug("Lucene index options are valid");
        }
        catch (IndexException e) {
            throw new ConfigurationException(e.getMessage(), (Throwable)e);
        }
    }

    public long estimateResultRows() {
        return 1L;
    }

    public ColumnFamilyStore getIndexCfs() {
        return null;
    }

    public void removeIndex(ByteBuffer columnName) {
        logger.info("Removing Lucene index {}", (Object)this.name);
        try {
            this.removeIndex();
            logger.info("Removed Lucene index {}", (Object)this.name);
        }
        catch (Exception e) {
            logger.error("Error removing Lucene index " + this.name, (Throwable)e);
        }
    }

    public void invalidate() {
        logger.info("Invalidating Lucene index {}", (Object)this.name);
        try {
            this.removeIndex();
            logger.info("Invalidated Lucene index {}", (Object)this.name);
        }
        catch (Exception e) {
            logger.error("Error invalidating Lucene index " + this.name, (Throwable)e);
        }
    }

    private void removeIndex() {
        try {
            this.service.delete();
        }
        catch (Exception e) {
            logger.error("Error while removing index", (Throwable)e);
            FileUtils.deleteRecursive((File)this.indexConfig.getPath().toFile());
        }
    }

    private IndexConfig newIndexConfig() {
        ColumnDefinition cfDef = (ColumnDefinition)this.columnDefs.iterator().next();
        String ksName = cfDef.ksName;
        String cfName = cfDef.cfName;
        CFMetaData metadata = Schema.instance.getCFMetaData(ksName, cfName);
        return new IndexConfig(metadata, cfDef);
    }

    public void truncateBlocking(long truncatedAt) {
        logger.info("Truncating Lucene index {}", (Object)this.name);
        try {
            this.service.truncate();
            logger.info("Truncated Lucene index {}", (Object)this.name);
        }
        catch (Exception e) {
            logger.error("Error truncating Lucene index " + this.name, (Throwable)e);
        }
    }

    public void reload() {
    }

    public void forceBlockingFlush() {
        logger.info("Flushing Lucene index {}", (Object)this.name);
        try {
            this.service.commit();
        }
        catch (Exception e) {
            logger.error("Error flushing Lucene index " + this.name, (Throwable)e);
        }
    }

    protected SecondaryIndexSearcher createSecondaryIndexSearcher(Set<ByteBuffer> columns) {
        return new IndexSearcher(this.baseCfs.indexManager, this, columns, this.service);
    }

    public String toString() {
        return this.name;
    }

    public void validate(ByteBuffer key, ColumnFamily columnFamily) throws InvalidRequestException {
        logger.debug("Validating row in Lucene index {}", (Object)this.name);
        try {
            this.service.validate(key, columnFamily);
        }
        catch (IndexException e) {
            logger.debug("Row validation failed in Lucene index {}", (Object)this.name);
            throw new InvalidRequestException(e.getMessage());
        }
    }

    static {
        try {
            Field field = ClientState.class.getDeclaredField("cqlQueryHandler");
            field.setAccessible(true);
            Field modifiersField = Field.class.getDeclaredField("modifiers");
            modifiersField.setAccessible(true);
            modifiersField.setInt(field, field.getModifiers() & 0xFFFFFFEF);
            field.set(null, new IndexQueryHandler());
        }
        catch (Exception e) {
            logger.error("Unable to set Lucene CQL query handler", (Throwable)e);
        }
    }
}

