/*
 * Decompiled with CFR 0.152.
 */
package com.stratio.cassandra.lucene;

import com.stratio.cassandra.lucene.IndexException;
import com.stratio.cassandra.lucene.IndexSearcher;
import com.stratio.cassandra.lucene.search.Search;
import com.stratio.cassandra.lucene.service.RowKeys;
import com.stratio.cassandra.lucene.service.RowMapper;
import com.stratio.cassandra.lucene.util.ByteBufferUtils;
import com.stratio.cassandra.lucene.util.TimeCounter;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.nio.ByteBuffer;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import org.apache.cassandra.cql3.BatchQueryOptions;
import org.apache.cassandra.cql3.CQLStatement;
import org.apache.cassandra.cql3.QueryHandler;
import org.apache.cassandra.cql3.QueryOptions;
import org.apache.cassandra.cql3.QueryProcessor;
import org.apache.cassandra.cql3.functions.Function;
import org.apache.cassandra.cql3.statements.BatchStatement;
import org.apache.cassandra.cql3.statements.ParsedStatement;
import org.apache.cassandra.cql3.statements.SelectStatement;
import org.apache.cassandra.db.ColumnFamilyStore;
import org.apache.cassandra.db.ConsistencyLevel;
import org.apache.cassandra.db.IndexExpression;
import org.apache.cassandra.db.Keyspace;
import org.apache.cassandra.db.Row;
import org.apache.cassandra.db.RowPosition;
import org.apache.cassandra.db.filter.IDiskAtomFilter;
import org.apache.cassandra.db.index.SecondaryIndexManager;
import org.apache.cassandra.db.index.SecondaryIndexSearcher;
import org.apache.cassandra.dht.AbstractBounds;
import org.apache.cassandra.exceptions.InvalidRequestException;
import org.apache.cassandra.exceptions.RequestExecutionException;
import org.apache.cassandra.exceptions.RequestValidationException;
import org.apache.cassandra.service.ClientState;
import org.apache.cassandra.service.LuceneStorageProxy;
import org.apache.cassandra.service.QueryState;
import org.apache.cassandra.service.pager.PagingState;
import org.apache.cassandra.transport.messages.ResultMessage;
import org.apache.cassandra.utils.MD5Digest;
import org.apache.cassandra.utils.Pair;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class IndexQueryHandler
implements QueryHandler {
    private static final Logger logger = LoggerFactory.getLogger(IndexQueryHandler.class);
    static QueryProcessor cqlProcessor = QueryProcessor.instance;

    private IDiskAtomFilter makeFilter(SelectStatement statement, QueryOptions options, int limit) throws IllegalAccessException, NoSuchMethodException, InvocationTargetException {
        Method method = SelectStatement.class.getDeclaredMethod("makeFilter", QueryOptions.class, Integer.TYPE);
        method.setAccessible(true);
        return (IDiskAtomFilter)method.invoke((Object)statement, options, limit);
    }

    private static boolean hasAnyAggregateFunctions(SelectStatement selectStatement) throws Exception {
        if (selectStatement.getFunctions() != null) {
            for (Function function : selectStatement.getFunctions()) {
                if (!function.isAggregate()) continue;
                return true;
            }
        }
        return false;
    }

    public ResultMessage.Prepared prepare(String query, QueryState state, Map<String, ByteBuffer> customPayload) throws RequestValidationException {
        return cqlProcessor.prepare(query, state);
    }

    public ParsedStatement.Prepared getPrepared(MD5Digest id) {
        return cqlProcessor.getPrepared(id);
    }

    public ParsedStatement.Prepared getPreparedForThrift(Integer id) {
        return cqlProcessor.getPreparedForThrift(id);
    }

    public ResultMessage processPrepared(CQLStatement statement, QueryState state, QueryOptions options, Map<String, ByteBuffer> customPayload) throws RequestExecutionException, RequestValidationException {
        QueryProcessor.metrics.preparedStatementsExecuted.inc();
        return this.process(statement, state, options);
    }

    public ResultMessage processBatch(BatchStatement statement, QueryState state, BatchQueryOptions options, Map<String, ByteBuffer> customPayload) throws RequestExecutionException, RequestValidationException {
        return cqlProcessor.processBatch(statement, state, options);
    }

    public ResultMessage process(String query, QueryState state, QueryOptions options, Map<String, ByteBuffer> customPayload) throws RequestExecutionException, RequestValidationException {
        ParsedStatement.Prepared p = QueryProcessor.getStatement((String)query, (ClientState)state.getClientState());
        options.prepare(p.boundNames);
        if (!state.getClientState().isInternal) {
            QueryProcessor.metrics.regularStatementsExecuted.inc();
        }
        return this.process(p.statement, state, options);
    }

    private ResultMessage process(CQLStatement statement, QueryState state, QueryOptions options) throws RequestExecutionException, RequestValidationException {
        if (statement.getBoundTerms() != options.getValues().size()) {
            throw new InvalidRequestException("Invalid amount of bind variables");
        }
        if (statement instanceof SelectStatement) {
            SelectStatement select = (SelectStatement)statement;
            List expressions = select.getValidatedIndexExpressions(options);
            ColumnFamilyStore cfs = Keyspace.open((String)select.keyspace()).getColumnFamilyStore(select.columnFamily());
            SecondaryIndexManager secondaryIndexManager = cfs.indexManager;
            SecondaryIndexSearcher searcher = secondaryIndexManager.getHighestSelectivityIndexSearcher(expressions);
            if (searcher instanceof IndexSearcher) {
                try {
                    TimeCounter time = TimeCounter.create().start();
                    IndexSearcher indexSearcher = (IndexSearcher)searcher;
                    Search search = indexSearcher.search(expressions);
                    ResultMessage msg = search.requiresFullScan() ? this.process((IndexSearcher)searcher, expressions, select, state, options) : cqlProcessor.processStatement(statement, state, options);
                    logger.debug("Total time : {}\n", (Object)time.stop());
                    return msg;
                }
                catch (RequestExecutionException | RequestValidationException e) {
                    throw e;
                }
                catch (Exception e) {
                    throw new IndexException(e);
                }
            }
        }
        return cqlProcessor.processStatement(statement, state, options);
    }

    private ResultMessage process(IndexSearcher searcher, List<IndexExpression> expressions, SelectStatement statement, QueryState state, QueryOptions options) throws Exception {
        int collectedRows;
        int remaining;
        ClientState clientState = state.getClientState();
        statement.checkAccess(clientState);
        statement.validate(clientState);
        int limit = statement.getLimit(options);
        int page = options.getPageSize();
        boolean isAggregateFunction = IndexQueryHandler.hasAnyAggregateFunctions(statement);
        String ks = statement.keyspace();
        String cf = statement.columnFamily();
        long now = System.currentTimeMillis();
        ConsistencyLevel cl = options.getConsistency();
        if (cl == null) {
            throw new InvalidRequestException("Invalid empty consistency level");
        }
        cl.validateForRead(ks);
        IDiskAtomFilter filter = this.makeFilter(statement, options, limit);
        AbstractBounds range = statement.getRestrictions().getPartitionKeyBounds(options);
        RowMapper mapper = searcher.mapper();
        PagingState pagingState = options.getPagingState();
        RowKeys rowKeys = null;
        if (pagingState != null) {
            limit = pagingState.remaining;
            ByteBuffer bb = pagingState.partitionKey;
            if (!ByteBufferUtils.isEmpty(bb)) {
                rowKeys = mapper.rowKeys(bb);
            }
        }
        int rowsPerCommand = page > 0 ? page : limit;
        ArrayList rows = new ArrayList();
        do {
            Pair<List<Row>, RowKeys> results = LuceneStorageProxy.getRangeSlice(searcher, ks, cf, now, filter, (AbstractBounds<RowPosition>)range, expressions, rowsPerCommand, cl, rowKeys, isAggregateFunction);
            collectedRows = ((List)results.left).size();
            rows.addAll((Collection)results.left);
            rowKeys = (RowKeys)results.right;
            remaining = limit - rows.size();
        } while (isAggregateFunction && remaining > 0 && collectedRows == rowsPerCommand);
        ResultMessage.Rows msg = statement.processResults(rows, options, limit, now);
        if (!isAggregateFunction && remaining > 0 && rows.size() == rowsPerCommand) {
            ByteBuffer bb = mapper.byteBuffer(rowKeys);
            pagingState = new PagingState(bb, null, remaining);
            msg.result.metadata.setHasMorePages(pagingState);
        }
        return msg;
    }
}

