/*
 * Decompiled with CFR 0.152.
 */
package com.stratio.cassandra.lucene;

import com.stratio.cassandra.lucene.Index;
import com.stratio.cassandra.lucene.IndexException;
import com.stratio.cassandra.lucene.schema.Schema;
import com.stratio.cassandra.lucene.search.Search;
import com.stratio.cassandra.lucene.search.SearchBuilder;
import com.stratio.cassandra.lucene.service.RowKey;
import com.stratio.cassandra.lucene.service.RowMapper;
import com.stratio.cassandra.lucene.service.RowService;
import com.stratio.cassandra.lucene.util.TimeCounter;
import java.nio.ByteBuffer;
import java.util.ArrayList;
import java.util.Comparator;
import java.util.List;
import java.util.Set;
import java.util.TreeSet;
import org.apache.cassandra.cql3.Operator;
import org.apache.cassandra.db.DataRange;
import org.apache.cassandra.db.IndexExpression;
import org.apache.cassandra.db.Row;
import org.apache.cassandra.db.filter.ExtendedFilter;
import org.apache.cassandra.db.filter.IDiskAtomFilter;
import org.apache.cassandra.db.filter.SliceQueryFilter;
import org.apache.cassandra.db.index.SecondaryIndexManager;
import org.apache.cassandra.db.index.SecondaryIndexSearcher;
import org.apache.cassandra.db.marshal.UTF8Type;
import org.apache.cassandra.exceptions.InvalidRequestException;
import org.apache.cassandra.utils.ByteBufferUtil;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class IndexSearcher
extends SecondaryIndexSearcher {
    private static final Logger logger = LoggerFactory.getLogger(IndexSearcher.class);
    public static final ByteBuffer AFTER = UTF8Type.instance.fromString("search_after_doc");
    private final RowService rowService;
    private final Schema schema;
    private final ByteBuffer indexedColumnName;

    public IndexSearcher(SecondaryIndexManager indexManager, Index index, Set<ByteBuffer> columns, RowService rowService) {
        super(indexManager, columns);
        this.rowService = rowService;
        this.schema = rowService.getSchema();
        this.indexedColumnName = index.getColumnDefinition().name.bytes;
    }

    public List<Row> search(ExtendedFilter extendedFilter) {
        try {
            boolean distinct = this.isDistinct(extendedFilter);
            RowKey after = this.after(extendedFilter.getClause());
            long timestamp = extendedFilter.timestamp;
            int limit = extendedFilter.currentLimit();
            DataRange dataRange = extendedFilter.dataRange;
            List clause = extendedFilter.getClause();
            List<IndexExpression> expressions = this.filteredExpressions(clause);
            Search search = this.search(clause);
            return this.rowService.search(search, expressions, dataRange, limit, timestamp, after, distinct);
        }
        catch (Exception e) {
            throw new IndexException(e, "Error while searching: %s", extendedFilter);
        }
    }

    private boolean isDistinct(ExtendedFilter extendedFilter) {
        IDiskAtomFilter filter = extendedFilter.columnFilter(ByteBufferUtil.EMPTY_BYTE_BUFFER);
        if (filter instanceof SliceQueryFilter) {
            int compositesToGroup = ((SliceQueryFilter)filter).compositesToGroup;
            return compositesToGroup == -2;
        }
        return false;
    }

    public boolean canHandleIndexClause(List<IndexExpression> clause) {
        for (IndexExpression expression : clause) {
            ByteBuffer columnName = expression.column;
            boolean sameName = this.indexedColumnName.equals(columnName);
            if (!expression.operator.equals((Object)Operator.EQ) || !sameName) continue;
            return true;
        }
        return false;
    }

    public IndexExpression highestSelectivityPredicate(List<IndexExpression> clause, boolean trace) {
        for (IndexExpression expression : clause) {
            ByteBuffer columnName = expression.column;
            boolean sameName = this.indexedColumnName.equals(columnName);
            if (!expression.operator.equals((Object)Operator.EQ) || !sameName) continue;
            return expression;
        }
        return null;
    }

    public void validate(IndexExpression indexExpression) throws InvalidRequestException {
        try {
            String json = (String)UTF8Type.instance.compose(indexExpression.value);
            SearchBuilder.fromJson(json).build().validate(this.schema);
        }
        catch (Exception e) {
            logger.error("Error while validating search", (Throwable)e);
            throw new InvalidRequestException(e.getMessage());
        }
    }

    public Search search(List<IndexExpression> clause) {
        IndexExpression indexedExpression = this.indexedExpression(clause);
        if (indexedExpression == null) {
            throw new IndexException("There is no index expression in the clause", new Object[0]);
        }
        String json = (String)UTF8Type.instance.compose(indexedExpression.value);
        return SearchBuilder.fromJson(json).build();
    }

    private IndexExpression indexedExpression(List<IndexExpression> clause) {
        for (IndexExpression indexExpression : clause) {
            ByteBuffer columnName = indexExpression.column;
            if (!this.indexedColumnName.equals(columnName)) continue;
            return indexExpression;
        }
        return null;
    }

    private List<IndexExpression> filteredExpressions(List<IndexExpression> clause) {
        ArrayList<IndexExpression> filteredExpressions = new ArrayList<IndexExpression>(clause.size());
        for (IndexExpression ie : clause) {
            ByteBuffer columnName = ie.column;
            if (this.indexedColumnName.equals(columnName) || AFTER.equals(columnName)) continue;
            filteredExpressions.add(ie);
        }
        return filteredExpressions;
    }

    public boolean requiresScanningAllRanges(List<IndexExpression> clause) {
        Search search = this.search(clause);
        return search.requiresFullScan();
    }

    public List<Row> postReconciliationProcessing(List<IndexExpression> clause, List<Row> rows) {
        TimeCounter sortTime = TimeCounter.create().start();
        int startSize = rows.size();
        Search search = this.search(clause);
        Comparator<Row> comparator = this.mapper().comparator(search);
        TreeSet<Row> set = new TreeSet<Row>(comparator);
        set.addAll(rows);
        ArrayList<Row> result = new ArrayList<Row>(set);
        int endSize = result.size();
        sortTime.stop();
        logger.debug("Processed {} rows to {} in {}", new Object[]{startSize, endSize, sortTime});
        return result;
    }

    private RowKey after(List<IndexExpression> expressions) {
        for (IndexExpression indexExpression : expressions) {
            ByteBuffer columnName = indexExpression.column;
            if (!AFTER.equals(columnName)) continue;
            return this.mapper().rowKey(indexExpression.value);
        }
        return null;
    }

    public RowMapper mapper() {
        return this.rowService.mapper();
    }
}

