/*
 * Decompiled with CFR 0.152.
 */
package com.stratio.cassandra.lucene.common;

import com.google.common.base.Objects;
import com.spatial4j.core.shape.Rectangle;
import com.spatial4j.core.shape.jts.JtsGeometry;
import com.stratio.cassandra.lucene.common.GeoDistance;
import com.stratio.cassandra.lucene.util.GeospatialUtilsJTS;
import com.vividsolutions.jts.geom.Geometry;
import com.vividsolutions.jts.geom.Point;
import org.codehaus.jackson.annotate.JsonCreator;
import org.codehaus.jackson.annotate.JsonProperty;
import org.codehaus.jackson.annotate.JsonSubTypes;
import org.codehaus.jackson.annotate.JsonTypeInfo;

@JsonTypeInfo(use=JsonTypeInfo.Id.NAME, include=JsonTypeInfo.As.PROPERTY, property="type")
@JsonSubTypes(value={@JsonSubTypes.Type(value=BBox.class, name="bbox"), @JsonSubTypes.Type(value=Buffer.class, name="buffer"), @JsonSubTypes.Type(value=Centroid.class, name="centroid"), @JsonSubTypes.Type(value=ConvexHull.class, name="convex_hull"), @JsonSubTypes.Type(value=Difference.class, name="difference"), @JsonSubTypes.Type(value=Intersection.class, name="intersection"), @JsonSubTypes.Type(value=Union.class, name="union")})
public interface GeoTransformation {
    public JtsGeometry apply(JtsGeometry var1);

    public static class Union
    implements GeoTransformation {
        @JsonProperty(value="shape")
        public final String other;

        @JsonCreator
        public Union(@JsonProperty(value="shape") String other) {
            this.other = other;
        }

        @Override
        public JtsGeometry apply(JtsGeometry shape) {
            Geometry geometry = GeospatialUtilsJTS.geometry(this.other).getGeom();
            Geometry union = shape.getGeom().union(geometry);
            return GeospatialUtilsJTS.CONTEXT.makeShape(union);
        }

        public String toString() {
            return Objects.toStringHelper((Object)this).add("other", (Object)this.other).toString();
        }
    }

    public static class Intersection
    implements GeoTransformation {
        @JsonProperty(value="shape")
        public final String other;

        @JsonCreator
        public Intersection(@JsonProperty(value="shape") String other) {
            this.other = other;
        }

        @Override
        public JtsGeometry apply(JtsGeometry shape) {
            Geometry geometry = GeospatialUtilsJTS.geometry(this.other).getGeom();
            Geometry intersection = shape.getGeom().intersection(geometry);
            return GeospatialUtilsJTS.CONTEXT.makeShape(intersection);
        }

        public String toString() {
            return Objects.toStringHelper((Object)this).add("other", (Object)this.other).toString();
        }
    }

    public static class Difference
    implements GeoTransformation {
        @JsonProperty(value="shape")
        public final String other;

        @JsonCreator
        public Difference(@JsonProperty(value="shape") String other) {
            this.other = other;
        }

        @Override
        public JtsGeometry apply(JtsGeometry shape) {
            Geometry geometry = GeospatialUtilsJTS.geometry(this.other).getGeom();
            Geometry difference = shape.getGeom().difference(geometry);
            return GeospatialUtilsJTS.CONTEXT.makeShape(difference);
        }

        public String toString() {
            return Objects.toStringHelper((Object)this).add("other", (Object)this.other).toString();
        }
    }

    public static class ConvexHull
    implements GeoTransformation {
        @Override
        public JtsGeometry apply(JtsGeometry shape) {
            Geometry centroid = shape.getGeom().convexHull();
            return GeospatialUtilsJTS.CONTEXT.makeShape(centroid);
        }

        public String toString() {
            return Objects.toStringHelper((Object)this).toString();
        }
    }

    public static class Centroid
    implements GeoTransformation {
        @Override
        public JtsGeometry apply(JtsGeometry shape) {
            Point centroid = shape.getGeom().getCentroid();
            return GeospatialUtilsJTS.CONTEXT.makeShape((Geometry)centroid);
        }

        public String toString() {
            return Objects.toStringHelper((Object)this).toString();
        }
    }

    public static class Buffer
    implements GeoTransformation {
        @JsonProperty(value="max_distance")
        public final GeoDistance maxDistance;
        @JsonProperty(value="min_distance")
        public final GeoDistance minDistance;

        @JsonCreator
        public Buffer(@JsonProperty(value="min_distance") GeoDistance minDistance, @JsonProperty(value="max_distance") GeoDistance maxDistance) {
            this.minDistance = minDistance;
            this.maxDistance = maxDistance;
        }

        @Override
        public JtsGeometry apply(JtsGeometry shape) {
            JtsGeometry max;
            JtsGeometry jtsGeometry = max = this.maxDistance == null ? GeospatialUtilsJTS.CONTEXT.makeShape(shape.getGeom()) : shape.getBuffered(this.maxDistance.getDegrees(), GeospatialUtilsJTS.CONTEXT);
            if (this.minDistance != null) {
                JtsGeometry min = shape.getBuffered(this.minDistance.getDegrees(), GeospatialUtilsJTS.CONTEXT);
                Geometry difference = max.getGeom().difference(min.getGeom());
                return GeospatialUtilsJTS.CONTEXT.makeShape(difference);
            }
            return max;
        }

        public String toString() {
            return Objects.toStringHelper((Object)this).add("minDistance", (Object)this.minDistance).add("maxDistance", (Object)this.maxDistance).toString();
        }
    }

    public static class BBox
    implements GeoTransformation {
        @Override
        public JtsGeometry apply(JtsGeometry shape) {
            Rectangle rectangle = shape.getBoundingBox();
            Geometry geometry = GeospatialUtilsJTS.CONTEXT.getGeometryFrom(rectangle);
            return GeospatialUtilsJTS.CONTEXT.makeShape(geometry);
        }

        public String toString() {
            return Objects.toStringHelper((Object)this).toString();
        }
    }
}

