/*
 * Decompiled with CFR 0.152.
 */
package com.stratio.cassandra.lucene.key;

import com.stratio.cassandra.lucene.key.KeyMapper;
import java.nio.ByteBuffer;
import java.util.Arrays;
import org.apache.cassandra.config.DatabaseDescriptor;
import org.apache.cassandra.db.DecoratedKey;
import org.apache.cassandra.db.RowPosition;
import org.apache.cassandra.db.composites.CBuilder;
import org.apache.cassandra.db.composites.Composite;
import org.apache.cassandra.db.marshal.UTF8Type;

class KeyEntry
implements Comparable<KeyEntry> {
    private final KeyMapper mapper;
    private final ByteBuffer[] components;

    KeyEntry(KeyMapper mapper, ByteBuffer[] components) {
        this.mapper = mapper;
        this.components = Arrays.copyOf(components, components.length);
    }

    ByteBuffer getCollatedToken() {
        return this.components[0];
    }

    public ByteBuffer getKey() {
        return this.components[1];
    }

    DecoratedKey getDecoratedKey() {
        return DatabaseDescriptor.getPartitioner().decorateKey(this.getKey());
    }

    Composite getComposite() {
        ByteBuffer[] bbs;
        CBuilder builder = this.mapper.clusteringComparator().builder();
        for (ByteBuffer bb : bbs = this.mapper.clusteringType().split(this.components[2])) {
            builder.add(bb);
        }
        return builder.build();
    }

    @Override
    public int compareTo(KeyEntry other) {
        int comp = UTF8Type.instance.compare(this.getCollatedToken(), other.getCollatedToken());
        if (comp == 0) {
            comp = this.getDecoratedKey().compareTo((RowPosition)other.getDecoratedKey());
        }
        if (comp == 0) {
            comp = this.mapper.clusteringComparator().compare(this.getComposite(), other.getComposite());
        }
        return comp;
    }
}

