/*
 * Decompiled with CFR 0.152.
 */
package com.stratio.cassandra.lucene.key;

import com.stratio.cassandra.lucene.key.KeyEntry;
import com.stratio.cassandra.lucene.key.KeyQuery;
import com.stratio.cassandra.lucene.key.KeySort;
import com.stratio.cassandra.lucene.key.TokenMapper;
import com.stratio.cassandra.lucene.schema.column.Column;
import com.stratio.cassandra.lucene.schema.column.Columns;
import com.stratio.cassandra.lucene.service.RowKey;
import com.stratio.cassandra.lucene.util.ByteBufferUtils;
import java.nio.ByteBuffer;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import org.apache.cassandra.config.CFMetaData;
import org.apache.cassandra.config.ColumnDefinition;
import org.apache.cassandra.config.DatabaseDescriptor;
import org.apache.cassandra.db.ArrayBackedSortedColumns;
import org.apache.cassandra.db.Cell;
import org.apache.cassandra.db.ColumnFamily;
import org.apache.cassandra.db.DecoratedKey;
import org.apache.cassandra.db.Row;
import org.apache.cassandra.db.composites.CBuilder;
import org.apache.cassandra.db.composites.CellName;
import org.apache.cassandra.db.composites.CellNameType;
import org.apache.cassandra.db.composites.Composite;
import org.apache.cassandra.db.filter.ColumnSlice;
import org.apache.cassandra.db.marshal.AbstractType;
import org.apache.cassandra.db.marshal.CompositeType;
import org.apache.cassandra.db.marshal.UTF8Type;
import org.apache.cassandra.utils.ByteBufferUtil;
import org.apache.lucene.document.Document;
import org.apache.lucene.document.Field;
import org.apache.lucene.document.FieldType;
import org.apache.lucene.index.DocValuesType;
import org.apache.lucene.index.IndexOptions;
import org.apache.lucene.index.Term;
import org.apache.lucene.search.Query;
import org.apache.lucene.search.SortField;
import org.apache.lucene.util.BytesRef;

public final class KeyMapper {
    public static final String FIELD_NAME = "_primary_key";
    private static final FieldType FIELD_TYPE = new FieldType();
    private final CompositeType type;
    private final CFMetaData metadata;
    private final CellNameType clusteringComparator;
    private final CompositeType clusteringType;

    public KeyMapper(CFMetaData metadata) {
        this.metadata = metadata;
        this.clusteringComparator = metadata.comparator;
        AbstractType[] subtypes = new AbstractType[this.clusteringComparator.size()];
        for (int i = 0; i < subtypes.length; ++i) {
            subtypes[i] = this.clusteringComparator.subtype(i);
        }
        this.clusteringType = CompositeType.getInstance((AbstractType[])subtypes);
        this.type = CompositeType.getInstance((AbstractType[])new AbstractType[]{UTF8Type.instance, metadata.getKeyValidator(), this.clusteringType});
    }

    public CompositeType clusteringType() {
        return this.clusteringType;
    }

    CellNameType clusteringComparator() {
        return this.clusteringComparator;
    }

    public ByteBuffer byteBuffer(DecoratedKey partitionKey, Composite clusteringKey) {
        return this.type.builder().add(TokenMapper.toCollated(partitionKey.getToken())).add(partitionKey.getKey()).add(clusteringKey.toByteBuffer()).build();
    }

    BytesRef seek(DecoratedKey key) {
        ByteBuffer token = TokenMapper.toCollated(key.getToken());
        return ByteBufferUtils.bytesRef(this.type.builder().add(token).add(ByteBufferUtil.EMPTY_BYTE_BUFFER).build());
    }

    public RowKey rowKey(ByteBuffer bb) {
        ByteBuffer[] bbs = ByteBufferUtils.split(bb, this.type);
        DecoratedKey partitionKey = DatabaseDescriptor.getPartitioner().decorateKey(bbs[1]);
        CellName clusteringKey = this.clusteringKey(bbs[2]);
        return new RowKey(partitionKey, clusteringKey);
    }

    public String hash(DecoratedKey partitionKey, CellName clusteringKey) {
        return ByteBufferUtil.bytesToHex((ByteBuffer)this.byteBuffer(partitionKey, (Composite)clusteringKey));
    }

    public void addFields(Document document, DecoratedKey partitionKey, CellName clusteringKey) {
        ByteBuffer bb = this.byteBuffer(partitionKey, (Composite)clusteringKey);
        BytesRef bytesRef = ByteBufferUtils.bytesRef(bb);
        document.add(new Field(FIELD_NAME, bytesRef, FIELD_TYPE));
    }

    public Term term(DecoratedKey partitionKey, CellName clusteringKey) {
        return new Term(FIELD_NAME, this.bytesRef(partitionKey, (Composite)clusteringKey));
    }

    BytesRef bytesRef(DecoratedKey key, Composite clusteringKey) {
        ByteBuffer bb = this.byteBuffer(key, clusteringKey);
        return ByteBufferUtils.bytesRef(bb);
    }

    public Columns columns(ColumnFamily columnFamily) {
        CellName cellName;
        int numClusteringColumns = this.metadata.clusteringColumns().size();
        Columns columns = new Columns();
        if (numClusteringColumns > 0 && (cellName = this.clusteringKey(columnFamily)) != null) {
            for (int i = 0; i < numClusteringColumns; ++i) {
                ByteBuffer value = cellName.get(i);
                ColumnDefinition columnDefinition = (ColumnDefinition)this.metadata.clusteringColumns().get(i);
                String name = columnDefinition.name.toString();
                AbstractType valueType = columnDefinition.type;
                columns.add(Column.builder(name).decomposedValue(value, valueType));
            }
        }
        return columns;
    }

    public CellName clusteringKey(ColumnFamily columnFamily) {
        for (Cell aColumnFamily : columnFamily) {
            CellName cellName = aColumnFamily.name();
            if (cellName.isStatic()) continue;
            return this.clusteringKey(cellName);
        }
        return null;
    }

    private CellName clusteringKey(CellName cellName) {
        CBuilder builder = this.clusteringComparator.builder();
        for (int i = 0; i < this.metadata.clusteringColumns().size(); ++i) {
            ByteBuffer component = cellName.get(i);
            builder.add(component);
        }
        Composite prefix = builder.build();
        return this.clusteringComparator.rowMarker(prefix);
    }

    public CellName clusteringKey(ByteBuffer bb) {
        return this.clusteringComparator.cellFromByteBuffer(bb);
    }

    ByteBuffer clusteringKey(Composite composite) {
        CBuilder builder = this.clusteringComparator.builder();
        ByteBuffer[] components = this.clusteringType.split(composite.toByteBuffer());
        for (int i = 0; i < this.metadata.clusteringColumns().size(); ++i) {
            ByteBuffer component = i < components.length ? components[i] : ByteBufferUtil.EMPTY_BYTE_BUFFER;
            builder.add(component != null ? component : ByteBufferUtil.EMPTY_BYTE_BUFFER);
        }
        return builder.build().toByteBuffer();
    }

    public Query query(DecoratedKey key, Composite start, Composite stop) {
        return new KeyQuery(this, key, start, stop);
    }

    KeyEntry entry(BytesRef bytesRef) {
        ByteBuffer bb = ByteBufferUtils.byteBuffer(bytesRef);
        ByteBuffer[] components = this.type.split(bb);
        return new KeyEntry(this, components);
    }

    public SortField sortField() {
        return new KeySort(this);
    }

    public CellName makeCellName(CellName cellName, ColumnDefinition columnDefinition) {
        return this.clusteringComparator.create(this.start(cellName), columnDefinition);
    }

    private Composite start(CellName cellName) {
        CBuilder builder = this.clusteringComparator.builder();
        for (int i = 0; i < cellName.clusteringSize(); ++i) {
            ByteBuffer component = cellName.get(i);
            builder.add(component);
        }
        return builder.build();
    }

    private Composite end(CellName cellName) {
        return this.start(cellName).withEOC(Composite.EOC.END);
    }

    public ColumnSlice[] columnSlices(List<CellName> clusteringKeys) {
        List<CellName> sortedClusteringKeys = this.sort(clusteringKeys);
        ColumnSlice[] columnSlices = new ColumnSlice[clusteringKeys.size()];
        int i = 0;
        for (CellName clusteringKey : sortedClusteringKeys) {
            Composite start = this.start(clusteringKey);
            Composite end = this.end(clusteringKey);
            ColumnSlice columnSlice = new ColumnSlice(start, end);
            columnSlices[i++] = columnSlice;
        }
        return columnSlices;
    }

    private List<CellName> sort(List<CellName> clusteringKeys) {
        ArrayList<CellName> result = new ArrayList<CellName>(clusteringKeys);
        Collections.sort(result, new Comparator<CellName>(){

            @Override
            public int compare(CellName o1, CellName o2) {
                return KeyMapper.this.clusteringComparator.compare((Composite)o1, (Composite)o2);
            }
        });
        return result;
    }

    public Map<CellName, ColumnFamily> splitRows(ColumnFamily columnFamily) {
        LinkedHashMap<CellName, ColumnFamily> columnFamilies = new LinkedHashMap<CellName, ColumnFamily>();
        ColumnFamily staticColumns = null;
        if (this.metadata.hasStaticColumns()) {
            staticColumns = ArrayBackedSortedColumns.factory.create(this.metadata);
            for (Cell cell : columnFamily) {
                if (!cell.name().isStatic()) continue;
                staticColumns.addColumn(cell);
            }
        }
        for (Cell cell : columnFamily) {
            if (cell.name().isStatic()) continue;
            CellName cellName = cell.name();
            CellName clusteringKey = this.clusteringKey(cellName);
            ColumnFamily rowColumnFamily = (ColumnFamily)columnFamilies.get(clusteringKey);
            if (rowColumnFamily == null) {
                rowColumnFamily = ArrayBackedSortedColumns.factory.create(this.metadata);
                if (staticColumns != null) {
                    rowColumnFamily.addAll(staticColumns);
                }
                columnFamilies.put(clusteringKey, rowColumnFamily);
            }
            rowColumnFamily.addColumn(cell);
        }
        return columnFamilies;
    }

    public CellName clusteringKey(Document document) {
        BytesRef bytesRef = document.getBinaryValue(FIELD_NAME);
        ByteBuffer bb = ByteBufferUtils.byteBuffer(bytesRef);
        ByteBuffer[] bbs = this.type.split(bb);
        return this.clusteringComparator.cellFromByteBuffer(bbs[2]);
    }

    public CellName clusteringKey(Row row) {
        return this.clusteringKey(row.cf);
    }

    public Comparator<Row> rowComparator() {
        return new Comparator<Row>(){

            @Override
            public int compare(Row row1, Row row2) {
                CellName name1 = KeyMapper.this.clusteringKey(row1);
                CellName name2 = KeyMapper.this.clusteringKey(row2);
                return KeyMapper.this.clusteringComparator.compare((Composite)name1, (Composite)name2);
            }
        };
    }

    public String toString(Composite composite) {
        return ByteBufferUtils.toString(composite.toByteBuffer(), this.clusteringType);
    }

    static {
        FIELD_TYPE.setOmitNorms(true);
        FIELD_TYPE.setIndexOptions(IndexOptions.DOCS);
        FIELD_TYPE.setTokenized(false);
        FIELD_TYPE.setStored(true);
        FIELD_TYPE.setDocValuesType(DocValuesType.SORTED);
        FIELD_TYPE.freeze();
    }
}

