/*
 * Decompiled with CFR 0.152.
 */
package com.stratio.cassandra.lucene.key;

import com.google.common.base.Objects;
import com.stratio.cassandra.lucene.key.KeyEntry;
import com.stratio.cassandra.lucene.key.KeyMapper;
import com.stratio.cassandra.lucene.key.TokenMapper;
import java.io.IOException;
import java.nio.ByteBuffer;
import org.apache.cassandra.db.DecoratedKey;
import org.apache.cassandra.db.RowPosition;
import org.apache.cassandra.db.composites.CellNameType;
import org.apache.cassandra.db.composites.Composite;
import org.apache.cassandra.db.marshal.UTF8Type;
import org.apache.lucene.index.FilteredTermsEnum;
import org.apache.lucene.index.Terms;
import org.apache.lucene.index.TermsEnum;
import org.apache.lucene.search.MultiTermQuery;
import org.apache.lucene.util.AttributeSource;
import org.apache.lucene.util.BytesRef;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

class KeyQuery
extends MultiTermQuery {
    private static final Logger logger = LoggerFactory.getLogger(KeyQuery.class);
    private final KeyMapper mapper;
    private final DecoratedKey key;
    private final ByteBuffer collatedToken;
    private final Composite start;
    private final Composite stop;
    private final CellNameType clusteringComparator;
    private final BytesRef seek;

    KeyQuery(KeyMapper mapper, DecoratedKey key, Composite start, Composite stop) {
        super("_primary_key");
        this.mapper = mapper;
        this.key = key;
        this.collatedToken = TokenMapper.toCollated(key.getToken());
        this.start = start;
        this.stop = stop;
        this.clusteringComparator = mapper.clusteringComparator();
        this.seek = mapper.seek(key);
    }

    @Override
    protected TermsEnum getTermsEnum(Terms terms, AttributeSource atts) throws IOException {
        return new FullKeyDataRangeFilteredTermsEnum(terms.iterator());
    }

    @Override
    public String toString(String field) {
        return Objects.toStringHelper((Object)this).add("field", (Object)field).add("key", (Object)this.key).add("start", this.start == null ? null : this.mapper.toString(this.start)).add("stop", this.stop == null ? null : this.mapper.toString(this.stop)).toString();
    }

    @Override
    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        if (!super.equals(o)) {
            return false;
        }
        KeyQuery keyQuery = (KeyQuery)o;
        if (!this.key.equals((Object)keyQuery.key)) {
            return false;
        }
        if (this.start != null ? !this.start.equals(keyQuery.start) : keyQuery.start != null) {
            return false;
        }
        return this.stop != null ? this.stop.equals(keyQuery.stop) : keyQuery.stop == null;
    }

    @Override
    public int hashCode() {
        int result = super.hashCode();
        result = 31 * result + this.key.hashCode();
        result = 31 * result + (this.start != null ? this.start.hashCode() : 0);
        result = 31 * result + (this.stop != null ? this.stop.hashCode() : 0);
        return result;
    }

    private class FullKeyDataRangeFilteredTermsEnum
    extends FilteredTermsEnum {
        FullKeyDataRangeFilteredTermsEnum(TermsEnum tenum) {
            super(tenum);
            this.setInitialSeekTerm(KeyQuery.this.seek);
        }

        @Override
        protected FilteredTermsEnum.AcceptStatus accept(BytesRef term) {
            KeyEntry entry = KeyQuery.this.mapper.entry(term);
            int tokenComparison = UTF8Type.instance.compare(entry.getCollatedToken(), KeyQuery.this.collatedToken);
            if (tokenComparison < 0) {
                return FilteredTermsEnum.AcceptStatus.NO;
            }
            if (tokenComparison > 0) {
                return FilteredTermsEnum.AcceptStatus.END;
            }
            Integer keyComparison = entry.getDecoratedKey().compareTo((RowPosition)KeyQuery.this.key);
            if (keyComparison < 0) {
                return FilteredTermsEnum.AcceptStatus.NO;
            }
            if (keyComparison > 0) {
                return FilteredTermsEnum.AcceptStatus.NO;
            }
            Composite clustering = entry.getComposite();
            if (KeyQuery.this.start != null && !KeyQuery.this.start.isEmpty() && KeyQuery.this.clusteringComparator.compare(KeyQuery.this.start, clustering) > 0) {
                return FilteredTermsEnum.AcceptStatus.NO;
            }
            if (KeyQuery.this.stop != null && !KeyQuery.this.stop.isEmpty() && KeyQuery.this.clusteringComparator.compare(KeyQuery.this.stop, clustering) < 0) {
                return FilteredTermsEnum.AcceptStatus.NO;
            }
            return FilteredTermsEnum.AcceptStatus.YES;
        }
    }
}

