/*
 * Decompiled with CFR 0.152.
 */
package com.stratio.cassandra.lucene.key;

import com.stratio.cassandra.lucene.key.KeyMapper;
import java.io.IOException;
import org.apache.lucene.search.FieldComparator;
import org.apache.lucene.search.FieldComparatorSource;
import org.apache.lucene.search.SortField;
import org.apache.lucene.util.BytesRef;

class KeySort
extends SortField {
    private static final String SORT_NAME = "<primary_key>";

    KeySort(final KeyMapper mapper) {
        super("_primary_key", new FieldComparatorSource(){

            @Override
            public FieldComparator<?> newComparator(String field, int hits, int sort, boolean reversed) throws IOException {
                return new FieldComparator.TermValComparator(hits, field, false){

                    @Override
                    public int compareValues(BytesRef val1, BytesRef val2) {
                        return mapper.entry(val1).compareTo(mapper.entry(val2));
                    }
                };
            }
        });
    }

    @Override
    public String toString() {
        return SORT_NAME;
    }

    @Override
    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof SortField)) {
            return false;
        }
        SortField other = (SortField)o;
        return this.toString().equals(other.toString());
    }
}

