/*
 * Decompiled with CFR 0.152.
 */
package com.stratio.cassandra.lucene.key;

import com.stratio.cassandra.lucene.key.PartitionSort;
import com.stratio.cassandra.lucene.schema.Schema;
import com.stratio.cassandra.lucene.schema.column.Column;
import com.stratio.cassandra.lucene.schema.column.Columns;
import com.stratio.cassandra.lucene.util.ByteBufferUtils;
import java.nio.ByteBuffer;
import java.util.List;
import org.apache.cassandra.config.CFMetaData;
import org.apache.cassandra.config.ColumnDefinition;
import org.apache.cassandra.config.DatabaseDescriptor;
import org.apache.cassandra.db.DecoratedKey;
import org.apache.cassandra.db.marshal.AbstractType;
import org.apache.cassandra.dht.IPartitioner;
import org.apache.lucene.document.Document;
import org.apache.lucene.document.Field;
import org.apache.lucene.document.FieldType;
import org.apache.lucene.index.DocValuesType;
import org.apache.lucene.index.IndexOptions;
import org.apache.lucene.index.Term;
import org.apache.lucene.search.Query;
import org.apache.lucene.search.SortField;
import org.apache.lucene.search.TermQuery;
import org.apache.lucene.util.BytesRef;

public final class PartitionMapper {
    public static final String FIELD_NAME = "_partition_key";
    private static final FieldType FIELD_TYPE = new FieldType();
    private final IPartitioner partitioner = DatabaseDescriptor.getPartitioner();
    private final CFMetaData metadata;
    private final Schema schema;
    private final AbstractType<?> type;

    public PartitionMapper(CFMetaData metadata, Schema schema) {
        this.metadata = metadata;
        this.schema = schema;
        this.type = metadata.getKeyValidator();
    }

    public AbstractType<?> getType() {
        return this.type;
    }

    public void addFields(Document document, DecoratedKey partitionKey) {
        ByteBuffer bb = partitionKey.getKey();
        BytesRef bytesRef = ByteBufferUtils.bytesRef(bb);
        document.add(new Field(FIELD_NAME, bytesRef, FIELD_TYPE));
    }

    public Term term(DecoratedKey partitionKey) {
        ByteBuffer bb = partitionKey.getKey();
        BytesRef bytesRef = ByteBufferUtils.bytesRef(bb);
        return new Term(FIELD_NAME, bytesRef);
    }

    public Query query(DecoratedKey partitionKey) {
        return new TermQuery(this.term(partitionKey));
    }

    public DecoratedKey partitionKey(Document document) {
        BytesRef bytesRef = document.getBinaryValue(FIELD_NAME);
        ByteBuffer bb = ByteBufferUtils.byteBuffer(bytesRef);
        return this.partitionKey(bb);
    }

    public DecoratedKey partitionKey(ByteBuffer partitionKey) {
        return this.partitioner.decorateKey(partitionKey);
    }

    public Columns columns(DecoratedKey partitionKey) {
        Columns columns = new Columns();
        AbstractType rawKeyType = this.metadata.getKeyValidator();
        List columnDefinitions = this.metadata.partitionKeyColumns();
        for (ColumnDefinition columnDefinition : columnDefinitions) {
            String name = columnDefinition.name.toString();
            if (!this.schema.maps(name)) continue;
            ByteBuffer[] components = ByteBufferUtils.split(partitionKey.getKey(), rawKeyType);
            int position = columnDefinition.position();
            ByteBuffer value = components[position];
            AbstractType valueType = (AbstractType)rawKeyType.getComponents().get(position);
            columns.add(Column.builder(name).decomposedValue(value, valueType));
        }
        return columns;
    }

    public SortField sortField() {
        return new PartitionSort(this);
    }

    static {
        FIELD_TYPE.setOmitNorms(true);
        FIELD_TYPE.setIndexOptions(IndexOptions.DOCS);
        FIELD_TYPE.setTokenized(false);
        FIELD_TYPE.setStored(true);
        FIELD_TYPE.setDocValuesType(DocValuesType.SORTED);
        FIELD_TYPE.freeze();
    }
}

