/*
 * Decompiled with CFR 0.152.
 */
package com.stratio.cassandra.lucene.key;

import com.stratio.cassandra.lucene.key.PartitionMapper;
import com.stratio.cassandra.lucene.util.ByteBufferUtils;
import java.io.IOException;
import java.nio.ByteBuffer;
import org.apache.lucene.search.FieldComparator;
import org.apache.lucene.search.FieldComparatorSource;
import org.apache.lucene.search.SortField;
import org.apache.lucene.util.BytesRef;

class PartitionSort
extends SortField {
    private static final String SORT_NAME = "<partition_key>";

    PartitionSort(final PartitionMapper mapper) {
        super("_partition_key", new FieldComparatorSource(){

            @Override
            public FieldComparator<?> newComparator(String field, int hits, int sort, boolean reversed) throws IOException {
                return new FieldComparator.TermValComparator(hits, field, false){

                    @Override
                    public int compareValues(BytesRef val1, BytesRef val2) {
                        ByteBuffer bb1 = ByteBufferUtils.byteBuffer(val1);
                        ByteBuffer bb2 = ByteBufferUtils.byteBuffer(val2);
                        return mapper.getType().compare((Object)bb1, (Object)bb2);
                    }
                };
            }
        });
    }

    @Override
    public String toString() {
        return SORT_NAME;
    }

    @Override
    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof SortField)) {
            return false;
        }
        SortField other = (SortField)o;
        return this.toString().equals(other.toString());
    }
}

