/*
 * Decompiled with CFR 0.152.
 */
package com.stratio.cassandra.lucene.key;

import com.stratio.cassandra.lucene.IndexException;
import java.math.BigInteger;
import java.nio.ByteBuffer;
import java.util.Comparator;
import org.apache.cassandra.config.DatabaseDescriptor;
import org.apache.cassandra.db.DecoratedKey;
import org.apache.cassandra.db.Row;
import org.apache.cassandra.db.RowPosition;
import org.apache.cassandra.db.marshal.UTF8Type;
import org.apache.cassandra.dht.Murmur3Partitioner;
import org.apache.cassandra.dht.Token;
import org.apache.lucene.document.Document;
import org.apache.lucene.document.FieldType;
import org.apache.lucene.document.LongField;
import org.apache.lucene.index.DocValuesType;
import org.apache.lucene.index.IndexOptions;
import org.apache.lucene.index.Term;
import org.apache.lucene.search.DocValuesRangeQuery;
import org.apache.lucene.search.NumericRangeQuery;
import org.apache.lucene.search.Query;
import org.apache.lucene.search.SortField;
import org.apache.lucene.search.TermQuery;
import org.apache.lucene.util.BytesRef;
import org.apache.lucene.util.BytesRefBuilder;
import org.apache.lucene.util.NumericUtils;

public final class TokenMapper {
    public static final String FIELD_NAME = "_token";
    private static final FieldType FIELD_TYPE = new FieldType();
    private static final BigInteger OFFSET;

    public TokenMapper() {
        if (!(DatabaseDescriptor.getPartitioner() instanceof Murmur3Partitioner)) {
            throw new IndexException("Only Murmur3 partitioner is supported", new Object[0]);
        }
    }

    public static Long value(Token token) {
        return (Long)token.getTokenValue();
    }

    public void addFields(Document document, DecoratedKey partitionKey) {
        Token token = partitionKey.getToken();
        Long value = TokenMapper.value(token);
        document.add(new LongField(FIELD_NAME, (long)value, FIELD_TYPE));
    }

    public Query query(Token lower, Token upper, boolean includeLower, boolean includeUpper) {
        if (lower != null && upper != null && this.isMinimum(lower) && this.isMinimum(upper) && (includeLower || includeUpper)) {
            return null;
        }
        return this.doQuery(lower, upper, includeLower, includeUpper);
    }

    public boolean isMinimum(Token token) {
        Token minimum = DatabaseDescriptor.getPartitioner().getMinimumToken();
        return token.compareTo((Object)minimum) == 0;
    }

    private static BytesRef bytesRef(Token token) {
        Long value = TokenMapper.value(token);
        BytesRefBuilder bytesRef = new BytesRefBuilder();
        NumericUtils.longToPrefixCoded(value, 0, bytesRef);
        return bytesRef.get();
    }

    public Query query(Token token) {
        return new TermQuery(new Term(FIELD_NAME, TokenMapper.bytesRef(token)));
    }

    private static boolean docValues(Long start, Long stop) {
        long threshold = 1222337203685480000L;
        long min = (start == null ? Long.MIN_VALUE : start) / 10L;
        long max = (stop == null ? Long.MAX_VALUE : stop) / 10L;
        return max - min > 1222337203685480000L;
    }

    private Query doQuery(Token lower, Token upper, boolean includeLower, boolean includeUpper) {
        Long start = lower == null || lower.isMinimum() ? null : TokenMapper.value(lower);
        Long stop = upper == null || upper.isMinimum() ? null : TokenMapper.value(upper);
        return TokenMapper.docValues(start, stop) ? DocValuesRangeQuery.newLongRange(FIELD_NAME, start, stop, includeLower, includeUpper) : NumericRangeQuery.newLongRange(FIELD_NAME, start, stop, includeLower, includeUpper);
    }

    public SortField sortField() {
        return new SortField(FIELD_NAME, SortField.Type.LONG);
    }

    public boolean includeStart(RowPosition rowPosition) {
        return rowPosition.kind() != RowPosition.Kind.MAX_BOUND;
    }

    public boolean includeStop(RowPosition rowPosition) {
        return rowPosition.kind() != RowPosition.Kind.MIN_BOUND;
    }

    public Comparator<Row> comparator() {
        return new Comparator<Row>(){

            @Override
            public int compare(Row row1, Row row2) {
                Token t1 = row1.key.getToken();
                Token t2 = row2.key.getToken();
                return t1.compareTo((Object)t2);
            }
        };
    }

    static ByteBuffer toCollated(Token token) {
        long value = TokenMapper.value(token);
        BigInteger afterOffset = BigInteger.valueOf(value).add(OFFSET);
        String text = String.format("%016x", afterOffset);
        return UTF8Type.instance.decompose((Object)text);
    }

    static Token fromCollated(ByteBuffer bb) {
        String text = (String)UTF8Type.instance.compose(bb);
        BigInteger beforeOffset = new BigInteger(text, 16);
        long value = beforeOffset.subtract(OFFSET).longValue();
        return new Murmur3Partitioner.LongToken(value);
    }

    static {
        FIELD_TYPE.setTokenized(true);
        FIELD_TYPE.setOmitNorms(true);
        FIELD_TYPE.setIndexOptions(IndexOptions.DOCS);
        FIELD_TYPE.setNumericType(FieldType.NumericType.LONG);
        FIELD_TYPE.setDocValuesType(DocValuesType.NUMERIC);
        FIELD_TYPE.freeze();
        OFFSET = BigInteger.valueOf(Long.MIN_VALUE).negate();
    }
}

