/*
 * Decompiled with CFR 0.152.
 */
package com.stratio.cassandra.lucene.schema;

import com.google.common.base.Objects;
import com.stratio.cassandra.lucene.IndexException;
import com.stratio.cassandra.lucene.schema.SchemaAnalyzer;
import com.stratio.cassandra.lucene.schema.column.Column;
import com.stratio.cassandra.lucene.schema.column.Columns;
import com.stratio.cassandra.lucene.schema.mapping.Mapper;
import com.stratio.cassandra.lucene.schema.mapping.SingleColumnMapper;
import java.io.Closeable;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import org.apache.cassandra.config.CFMetaData;
import org.apache.lucene.analysis.Analyzer;
import org.apache.lucene.document.Document;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class Schema
implements Closeable {
    private static final Logger logger = LoggerFactory.getLogger(Schema.class);
    private final Map<String, Mapper> mappers;
    private final SchemaAnalyzer analyzer;
    private final Set<String> mappedColumns;

    public Schema(Analyzer defaultAnalyzer, Map<String, Mapper> mappers, Map<String, Analyzer> analyzers) {
        this.mappers = mappers;
        this.analyzer = new SchemaAnalyzer(defaultAnalyzer, analyzers, mappers);
        this.mappedColumns = new HashSet<String>();
        for (Mapper mapper : this.mappers.values()) {
            this.mappedColumns.addAll(mapper.mappedColumns);
        }
    }

    public Analyzer getAnalyzer() {
        return this.analyzer;
    }

    public Analyzer getDefaultAnalyzer() {
        return this.analyzer.getDefaultAnalyzer().getAnalyzer();
    }

    public Analyzer getAnalyzer(String fieldName) {
        return this.analyzer.getAnalyzer(fieldName).getAnalyzer();
    }

    public Mapper getMapper(String field) {
        String mapperName = Column.getMapperName(field);
        return this.mappers.get(mapperName);
    }

    public SingleColumnMapper getSingleColumnMapper(String field) {
        Mapper mapper = this.getMapper(field);
        return mapper == null ? null : (SingleColumnMapper)mapper;
    }

    public void validate(Columns columns) {
        for (Mapper mapper : this.mappers.values()) {
            mapper.validate(columns);
        }
    }

    public void addFields(Document document, Columns columns) {
        for (Mapper mapper : this.mappers.values()) {
            try {
                mapper.addFields(document, columns);
            }
            catch (IndexException e) {
                logger.error("Error in Lucene index:\n\twhile mapping : {}\n\twith mapper   : {}\n\tcaused by     : {}", new Object[]{columns, mapper, e.getMessage()});
            }
        }
    }

    public void validate(CFMetaData metadata) {
        for (Mapper mapper : this.mappers.values()) {
            mapper.validate(metadata);
        }
    }

    public boolean maps(String column) {
        for (String mappedColumn : this.mappedColumns) {
            String name = mappedColumn.contains(".") ? mappedColumn.substring(0, mappedColumn.indexOf(".")) : mappedColumn;
            if (!column.equals(name)) continue;
            return true;
        }
        return false;
    }

    public boolean mapsAll(Columns columns) {
        for (Mapper mapper : this.mappers.values()) {
            if (mapper.maps(columns)) continue;
            return false;
        }
        return true;
    }

    @Override
    public void close() {
        this.analyzer.close();
    }

    public String toString() {
        return Objects.toStringHelper((Object)this).add("mappers", this.mappers).add("analyzer", (Object)this.analyzer).toString();
    }
}

