/*
 * Decompiled with CFR 0.152.
 */
package com.stratio.cassandra.lucene.schema;

import com.stratio.cassandra.lucene.schema.SchemaBuilder;
import com.stratio.cassandra.lucene.schema.analysis.AnalyzerBuilder;
import com.stratio.cassandra.lucene.schema.analysis.ClasspathAnalyzerBuilder;
import com.stratio.cassandra.lucene.schema.analysis.SnowballAnalyzerBuilder;
import com.stratio.cassandra.lucene.schema.mapping.builder.BigDecimalMapperBuilder;
import com.stratio.cassandra.lucene.schema.mapping.builder.BigIntegerMapperBuilder;
import com.stratio.cassandra.lucene.schema.mapping.builder.BitemporalMapperBuilder;
import com.stratio.cassandra.lucene.schema.mapping.builder.BlobMapperBuilder;
import com.stratio.cassandra.lucene.schema.mapping.builder.BooleanMapperBuilder;
import com.stratio.cassandra.lucene.schema.mapping.builder.DateMapperBuilder;
import com.stratio.cassandra.lucene.schema.mapping.builder.DateRangeMapperBuilder;
import com.stratio.cassandra.lucene.schema.mapping.builder.DoubleMapperBuilder;
import com.stratio.cassandra.lucene.schema.mapping.builder.FloatMapperBuilder;
import com.stratio.cassandra.lucene.schema.mapping.builder.GeoPointMapperBuilder;
import com.stratio.cassandra.lucene.schema.mapping.builder.GeoShapeMapperBuilder;
import com.stratio.cassandra.lucene.schema.mapping.builder.InetMapperBuilder;
import com.stratio.cassandra.lucene.schema.mapping.builder.IntegerMapperBuilder;
import com.stratio.cassandra.lucene.schema.mapping.builder.LongMapperBuilder;
import com.stratio.cassandra.lucene.schema.mapping.builder.StringMapperBuilder;
import com.stratio.cassandra.lucene.schema.mapping.builder.TextMapperBuilder;
import com.stratio.cassandra.lucene.schema.mapping.builder.UUIDMapperBuilder;
import java.util.LinkedHashMap;

public final class SchemaBuilders {
    private SchemaBuilders() {
    }

    public static SchemaBuilder schema() {
        return new SchemaBuilder(null, new LinkedHashMap<String, AnalyzerBuilder>(), new LinkedHashMap());
    }

    public static BigDecimalMapperBuilder bigDecimalMapper() {
        return new BigDecimalMapperBuilder();
    }

    public static BigIntegerMapperBuilder bigIntegerMapper() {
        return new BigIntegerMapperBuilder();
    }

    public static BitemporalMapperBuilder bitemporalMapper(String vtFrom, String vtTo, String ttFrom, String ttTo) {
        return new BitemporalMapperBuilder(vtFrom, vtTo, ttFrom, ttTo);
    }

    public static BlobMapperBuilder blobMapper() {
        return new BlobMapperBuilder();
    }

    public static BooleanMapperBuilder booleanMapper() {
        return new BooleanMapperBuilder();
    }

    public static DateMapperBuilder dateMapper() {
        return new DateMapperBuilder();
    }

    public static DateRangeMapperBuilder dateRangeMapper(String from, String to) {
        return new DateRangeMapperBuilder(from, to);
    }

    public static DoubleMapperBuilder doubleMapper() {
        return new DoubleMapperBuilder();
    }

    public static FloatMapperBuilder floatMapper() {
        return new FloatMapperBuilder();
    }

    public static GeoPointMapperBuilder geoPointMapper(String latitude, String longitude) {
        return new GeoPointMapperBuilder(latitude, longitude);
    }

    public static GeoShapeMapperBuilder geoShapeMapper() {
        return new GeoShapeMapperBuilder();
    }

    public static InetMapperBuilder inetMapper() {
        return new InetMapperBuilder();
    }

    public static IntegerMapperBuilder integerMapper() {
        return new IntegerMapperBuilder();
    }

    public static LongMapperBuilder longMapper() {
        return new LongMapperBuilder();
    }

    public static StringMapperBuilder stringMapper() {
        return new StringMapperBuilder();
    }

    public static TextMapperBuilder textMapper() {
        return new TextMapperBuilder();
    }

    public static UUIDMapperBuilder uuidMapper() {
        return new UUIDMapperBuilder();
    }

    public static ClasspathAnalyzerBuilder classpathAnalyzer(String className) {
        return new ClasspathAnalyzerBuilder(className);
    }

    public static SnowballAnalyzerBuilder snowballAnalyzer(String language, String stopwords) {
        return new SnowballAnalyzerBuilder(language, stopwords);
    }
}

