/*
 * Decompiled with CFR 0.152.
 */
package com.stratio.cassandra.lucene.schema.analysis;

import com.stratio.cassandra.lucene.IndexException;
import com.stratio.cassandra.lucene.schema.analysis.AnalyzerBuilder;
import java.lang.reflect.Constructor;
import org.apache.lucene.analysis.Analyzer;
import org.codehaus.jackson.annotate.JsonCreator;
import org.codehaus.jackson.annotate.JsonProperty;

public class ClasspathAnalyzerBuilder
extends AnalyzerBuilder {
    @JsonProperty(value="class")
    private final String className;

    @JsonCreator
    public ClasspathAnalyzerBuilder(@JsonProperty(value="class") String className) {
        this.className = className;
    }

    @Override
    public Analyzer analyzer() {
        try {
            Class<?> analyzerClass = Class.forName(this.className);
            Constructor<?> constructor = analyzerClass.getConstructor(new Class[0]);
            return (Analyzer)constructor.newInstance(new Object[0]);
        }
        catch (Exception e) {
            throw new IndexException(e, "Not found analyzer '%s'", this.className);
        }
    }
}

