/*
 * Decompiled with CFR 0.152.
 */
package com.stratio.cassandra.lucene.schema.analysis;

import com.stratio.cassandra.lucene.IndexException;
import com.stratio.cassandra.lucene.schema.analysis.AnalyzerBuilder;
import com.stratio.cassandra.lucene.schema.analysis.StandardStopwords;
import java.util.ArrayList;
import org.apache.commons.lang3.StringUtils;
import org.apache.lucene.analysis.Analyzer;
import org.apache.lucene.analysis.TokenFilter;
import org.apache.lucene.analysis.TokenStream;
import org.apache.lucene.analysis.core.LowerCaseFilter;
import org.apache.lucene.analysis.core.StopFilter;
import org.apache.lucene.analysis.snowball.SnowballFilter;
import org.apache.lucene.analysis.standard.StandardFilter;
import org.apache.lucene.analysis.standard.StandardTokenizer;
import org.apache.lucene.analysis.util.CharArraySet;
import org.codehaus.jackson.annotate.JsonCreator;
import org.codehaus.jackson.annotate.JsonProperty;

public class SnowballAnalyzerBuilder
extends AnalyzerBuilder {
    @JsonProperty(value="language")
    private final String language;
    @JsonProperty(value="stopwords")
    private final String stopwords;

    @JsonCreator
    public SnowballAnalyzerBuilder(@JsonProperty(value="language") String language, @JsonProperty(value="stopwords") String stopwords) {
        if (StringUtils.isBlank((CharSequence)language)) {
            throw new IndexException("Language must be specified", new Object[0]);
        }
        this.language = language;
        this.stopwords = stopwords;
    }

    @Override
    public Analyzer analyzer() {
        CharArraySet stops = this.stopwords == null ? SnowballAnalyzerBuilder.getDefaultStopwords(this.language) : SnowballAnalyzerBuilder.getStopwords(this.stopwords);
        return SnowballAnalyzerBuilder.buildAnalyzer(this.language, stops);
    }

    private static Analyzer buildAnalyzer(String language, CharArraySet stopwords) {
        return new SnowballAnalyzer(language, stopwords);
    }

    private static CharArraySet getStopwords(String stopwords) {
        ArrayList<String> stopwordsList = new ArrayList<String>();
        for (String stop : stopwords.split(",")) {
            stopwordsList.add(stop.trim());
        }
        return new CharArraySet(stopwordsList, true);
    }

    private static CharArraySet getDefaultStopwords(String language) {
        return StandardStopwords.get(language);
    }

    public static class SnowballAnalyzer
    extends Analyzer {
        private final String language;
        private final CharArraySet stopwords;

        public SnowballAnalyzer(String language, CharArraySet stopwords) {
            this.language = language;
            this.stopwords = stopwords;
        }

        @Override
        protected Analyzer.TokenStreamComponents createComponents(String fieldName) {
            StandardTokenizer source = new StandardTokenizer();
            TokenFilter result = new StandardFilter(source);
            result = new LowerCaseFilter(result);
            result = new StopFilter(result, this.stopwords);
            result = new SnowballFilter((TokenStream)result, this.language);
            return new Analyzer.TokenStreamComponents(source, result);
        }
    }
}

