/*
 * Decompiled with CFR 0.152.
 */
package com.stratio.cassandra.lucene.schema.analysis;

import java.util.Locale;
import org.apache.lucene.analysis.ca.CatalanAnalyzer;
import org.apache.lucene.analysis.da.DanishAnalyzer;
import org.apache.lucene.analysis.de.GermanAnalyzer;
import org.apache.lucene.analysis.en.EnglishAnalyzer;
import org.apache.lucene.analysis.es.SpanishAnalyzer;
import org.apache.lucene.analysis.eu.BasqueAnalyzer;
import org.apache.lucene.analysis.fi.FinnishAnalyzer;
import org.apache.lucene.analysis.fr.FrenchAnalyzer;
import org.apache.lucene.analysis.ga.IrishAnalyzer;
import org.apache.lucene.analysis.hu.HungarianAnalyzer;
import org.apache.lucene.analysis.hy.ArmenianAnalyzer;
import org.apache.lucene.analysis.it.ItalianAnalyzer;
import org.apache.lucene.analysis.nl.DutchAnalyzer;
import org.apache.lucene.analysis.no.NorwegianAnalyzer;
import org.apache.lucene.analysis.pt.PortugueseAnalyzer;
import org.apache.lucene.analysis.ru.RussianAnalyzer;
import org.apache.lucene.analysis.sv.SwedishAnalyzer;
import org.apache.lucene.analysis.tr.TurkishAnalyzer;
import org.apache.lucene.analysis.util.CharArraySet;

public enum StandardStopwords {
    ENGLISH{

        @Override
        protected CharArraySet build() {
            return EnglishAnalyzer.getDefaultStopSet();
        }
    }
    ,
    FRENCH{

        @Override
        protected CharArraySet build() {
            return FrenchAnalyzer.getDefaultStopSet();
        }
    }
    ,
    SPANISH{

        @Override
        protected CharArraySet build() {
            return SpanishAnalyzer.getDefaultStopSet();
        }
    }
    ,
    PORTUGUESE{

        @Override
        protected CharArraySet build() {
            return PortugueseAnalyzer.getDefaultStopSet();
        }
    }
    ,
    ITALIAN{

        @Override
        protected CharArraySet build() {
            return ItalianAnalyzer.getDefaultStopSet();
        }
    }
    ,
    GERMAN{

        @Override
        protected CharArraySet build() {
            return GermanAnalyzer.getDefaultStopSet();
        }
    }
    ,
    DUTCH{

        @Override
        protected CharArraySet build() {
            return DutchAnalyzer.getDefaultStopSet();
        }
    }
    ,
    SWEDISH{

        @Override
        protected CharArraySet build() {
            return SwedishAnalyzer.getDefaultStopSet();
        }
    }
    ,
    NORWEGIAN{

        @Override
        protected CharArraySet build() {
            return NorwegianAnalyzer.getDefaultStopSet();
        }
    }
    ,
    DANISH{

        @Override
        protected CharArraySet build() {
            return DanishAnalyzer.getDefaultStopSet();
        }
    }
    ,
    RUSSIAN{

        @Override
        protected CharArraySet build() {
            return RussianAnalyzer.getDefaultStopSet();
        }
    }
    ,
    FINNISH{

        @Override
        protected CharArraySet build() {
            return FinnishAnalyzer.getDefaultStopSet();
        }
    }
    ,
    IRISH{

        @Override
        protected CharArraySet build() {
            return IrishAnalyzer.getDefaultStopSet();
        }
    }
    ,
    HUNGARIAN{

        @Override
        protected CharArraySet build() {
            return HungarianAnalyzer.getDefaultStopSet();
        }
    }
    ,
    TURKISH{

        @Override
        protected CharArraySet build() {
            return TurkishAnalyzer.getDefaultStopSet();
        }
    }
    ,
    ARMENIAN{

        @Override
        protected CharArraySet build() {
            return ArmenianAnalyzer.getDefaultStopSet();
        }
    }
    ,
    BASQUE{

        @Override
        protected CharArraySet build() {
            return BasqueAnalyzer.getDefaultStopSet();
        }
    }
    ,
    CATALAN{

        @Override
        protected CharArraySet build() {
            return CatalanAnalyzer.getDefaultStopSet();
        }
    };


    abstract CharArraySet build();

    public static CharArraySet get(String name) {
        try {
            return StandardStopwords.valueOf(name.toUpperCase(Locale.ROOT)).get();
        }
        catch (IllegalArgumentException e) {
            return CharArraySet.EMPTY_SET;
        }
    }

    public CharArraySet get() {
        return this.build();
    }
}

