/*
 * Decompiled with CFR 0.152.
 */
package com.stratio.cassandra.lucene.schema.column;

import com.google.common.base.Objects;
import com.stratio.cassandra.lucene.IndexException;
import com.stratio.cassandra.lucene.schema.column.ColumnBuilder;
import java.nio.ByteBuffer;
import java.util.List;
import java.util.regex.Pattern;
import org.apache.cassandra.db.marshal.AbstractType;

public final class Column<T> {
    public static final String MAP_SEPARATOR = "$";
    public static final String UDT_SEPARATOR = ".";
    public static final String UDT_PATTERN = Pattern.quote(".");
    public static final String MAP_PATTERN = Pattern.quote("$");
    private static final Pattern NAME_PATTERN = Pattern.compile("[^(\\$|\\.)]*[\\.[^(\\$|\\.)]]*[\\$[^(\\$|\\.)]]*");
    private final String cellName;
    private final List<String> udtNames;
    private final List<String> mapNames;
    private final T composedValue;
    private final ByteBuffer decomposedValue;
    private final AbstractType<T> type;
    private final boolean isMultiCell;
    private final int localDeletionTime;

    Column(String cellName, List<String> udtNames, List<String> mapNames, ByteBuffer decomposedValue, T composedValue, AbstractType<T> type, boolean isMultiCell, int localDeletionTime) {
        this.cellName = cellName;
        this.udtNames = udtNames;
        this.mapNames = mapNames;
        this.composedValue = composedValue;
        this.decomposedValue = decomposedValue;
        this.type = type;
        this.isMultiCell = isMultiCell;
        this.localDeletionTime = localDeletionTime;
    }

    public static ColumnBuilder builder(String cellName) {
        return new ColumnBuilder(cellName);
    }

    public static boolean isTuple(String name) {
        return name.contains(UDT_SEPARATOR);
    }

    public static String check(String name) {
        if (!NAME_PATTERN.matcher(name).matches()) {
            throw new IndexException("Name %s doesn't satisfy the mandatory pattern %s", name, NAME_PATTERN.pattern());
        }
        return name;
    }

    public static String getMapperName(String field) {
        return field.split(MAP_PATTERN)[0];
    }

    public String getMapperName() {
        return this.cellName + this.getUDTSuffix();
    }

    public static String getCellName(String field) {
        return field.split(UDT_PATTERN)[0].split(MAP_PATTERN)[0];
    }

    public String getCellName() {
        return this.cellName;
    }

    public String getFullName() {
        return this.cellName + this.getUDTSuffix() + this.getMapSuffix();
    }

    private String getUDTSuffix() {
        String result = "";
        for (String udtName : this.udtNames) {
            result = result + UDT_SEPARATOR + udtName;
        }
        return result;
    }

    private String getMapSuffix() {
        String result = "";
        for (String mapName : this.mapNames) {
            result = result + MAP_SEPARATOR + mapName;
        }
        return result;
    }

    public boolean isLive(long now) {
        return (int)(now / 1000L) < this.localDeletionTime;
    }

    public String getFieldName(String field) {
        return field + this.getMapSuffix();
    }

    public ByteBuffer getDecomposedValue() {
        return this.decomposedValue;
    }

    public T getComposedValue() {
        return this.composedValue;
    }

    public AbstractType<T> getType() {
        return this.type;
    }

    public boolean isMultiCell() {
        return this.isMultiCell;
    }

    public String toString() {
        return Objects.toStringHelper((Object)this).add("fullName", (Object)this.getFullName()).add("composedValue", this.getComposedValue()).add("type", (Object)this.type.getClass().getSimpleName()).toString();
    }
}

