/*
 * Decompiled with CFR 0.152.
 */
package com.stratio.cassandra.lucene.schema.column;

import com.stratio.cassandra.lucene.schema.column.Column;
import java.nio.ByteBuffer;
import java.util.ArrayList;
import java.util.List;
import org.apache.cassandra.db.marshal.AbstractType;

public class ColumnBuilder {
    private final String cellName;
    private final List<String> udtNames;
    private final List<String> mapNames;
    private boolean isMultiCell = false;
    private int localDeletionTime = Integer.MAX_VALUE;

    public ColumnBuilder(String cellName) {
        this.cellName = cellName;
        this.udtNames = new ArrayList<String>();
        this.mapNames = new ArrayList<String>();
    }

    public <T> Column<T> composedValue(T composedValue, AbstractType<T> type) {
        ByteBuffer decomposedValue = type.decompose(composedValue);
        return new Column<T>(this.cellName, this.udtNames, this.mapNames, decomposedValue, composedValue, type, this.isMultiCell, this.localDeletionTime);
    }

    public <T> Column<T> decomposedValue(ByteBuffer decomposedValue, AbstractType<T> type) {
        Object composedValue = type.compose(decomposedValue);
        return new Column<Object>(this.cellName, this.udtNames, this.mapNames, decomposedValue, composedValue, type, this.isMultiCell, this.localDeletionTime);
    }

    public ColumnBuilder multiCell(boolean isMultiCell) {
        this.isMultiCell = isMultiCell;
        return this;
    }

    public ColumnBuilder udtName(String name) {
        this.udtNames.add(name);
        return this;
    }

    public ColumnBuilder mapName(String name) {
        this.mapNames.add(name);
        return this;
    }

    public ColumnBuilder localDeletionTime(int localDeletionTime) {
        this.localDeletionTime = localDeletionTime;
        return this;
    }

    public ColumnBuilder clone() {
        ColumnBuilder clone = new ColumnBuilder(this.cellName);
        clone.isMultiCell = this.isMultiCell;
        clone.localDeletionTime = this.localDeletionTime;
        for (String udtName : this.udtNames) {
            clone.udtNames.add(udtName);
        }
        for (String mapName : this.mapNames) {
            clone.mapNames.add(mapName);
        }
        return clone;
    }
}

