/*
 * Decompiled with CFR 0.152.
 */
package com.stratio.cassandra.lucene.schema.column;

import com.google.common.base.Objects;
import com.stratio.cassandra.lucene.schema.column.Column;
import java.util.Arrays;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;

public class Columns
implements Iterable<Column<?>> {
    private final List<Column<?>> columns;

    public Columns() {
        this.columns = new LinkedList();
    }

    public Columns(Column<?> ... columns) {
        this.columns = Arrays.asList(columns);
    }

    public Columns add(Column<?> column) {
        this.columns.add(column);
        return this;
    }

    public Columns add(Columns columns) {
        for (Column<?> column : columns) {
            this.columns.add(column);
        }
        return this;
    }

    @Override
    public Iterator<Column<?>> iterator() {
        return this.columns.iterator();
    }

    public int size() {
        return this.columns.size();
    }

    public boolean isEmpty() {
        return this.columns.isEmpty();
    }

    public Columns getColumnsByFullName(String name) {
        Column.check(name);
        Columns result = new Columns();
        for (Column<?> column : this.columns) {
            if (!column.getFullName().equals(name)) continue;
            result.add(column);
        }
        return result;
    }

    public Columns getColumnsByCellName(String name) {
        Column.check(name);
        String cellName = Column.getCellName(name);
        Columns result = new Columns();
        for (Column<?> column : this.columns) {
            if (!column.getCellName().equals(cellName)) continue;
            result.add(column);
        }
        return result;
    }

    public Columns getColumnsByMapperName(String name) {
        Column.check(name);
        String mapperName = Column.getMapperName(name);
        Columns result = new Columns();
        for (Column<?> column : this.columns) {
            if (!column.getMapperName().equals(mapperName)) continue;
            result.add(column);
        }
        return result;
    }

    public Columns cleanExpired(long now) {
        Columns result = new Columns();
        for (Column<?> column : this.columns) {
            if (!column.isLive(now)) continue;
            result.add(column);
        }
        return result;
    }

    public Column<?> getFirst() {
        return this.columns.isEmpty() ? null : this.columns.get(0);
    }

    public String toString() {
        Objects.ToStringHelper helper = Objects.toStringHelper((Object)this);
        for (Column<?> column : this.columns) {
            helper.add(column.getFullName(), column.getComposedValue());
        }
        return helper.toString();
    }
}

