/*
 * Decompiled with CFR 0.152.
 */
package com.stratio.cassandra.lucene.schema.mapping;

import com.stratio.cassandra.lucene.IndexException;
import com.stratio.cassandra.lucene.schema.mapping.KeywordMapper;
import java.math.BigInteger;
import org.apache.cassandra.db.marshal.AbstractType;
import org.apache.cassandra.db.marshal.ByteType;
import org.apache.cassandra.db.marshal.Int32Type;
import org.apache.cassandra.db.marshal.IntegerType;
import org.apache.cassandra.db.marshal.LongType;
import org.apache.cassandra.db.marshal.ShortType;
import org.apache.cassandra.db.marshal.UTF8Type;
import org.apache.commons.lang3.StringUtils;

public class BigIntegerMapper
extends KeywordMapper {
    public static final int DEFAULT_DIGITS = 32;
    private static final int BASE = 10;
    public final int digits;
    private final BigInteger complement;
    private final int hexDigits;

    public BigIntegerMapper(String field, String column, Boolean validated, Integer digits) {
        super(field, column, validated, new AbstractType[]{ByteType.instance, IntegerType.instance, Int32Type.instance, LongType.instance, ShortType.instance, UTF8Type.instance});
        if (digits != null && digits <= 0) {
            throw new IndexException("Positive digits required", new Object[0]);
        }
        this.digits = digits == null ? 32 : digits;
        this.complement = BigInteger.valueOf(10L).pow(this.digits).subtract(BigInteger.valueOf(1L));
        BigInteger maxValue = this.complement.multiply(BigInteger.valueOf(2L));
        this.hexDigits = BigIntegerMapper.encode(maxValue).length();
    }

    private static String encode(BigInteger bi) {
        return bi.toString(36);
    }

    @Override
    protected String doBase(String name, Object value) {
        BigInteger bi;
        String svalue = value.toString();
        try {
            bi = new BigInteger(svalue);
        }
        catch (NumberFormatException e) {
            throw new IndexException("Field '%s' requires a base 10 integer, but found '%s'", name, svalue);
        }
        if (bi.abs().toString().length() > this.digits) {
            throw new IndexException("Field '%s' with value '%s' has more than %d digits", name, value, this.digits);
        }
        bi = bi.add(this.complement);
        String bis = BigIntegerMapper.encode(bi);
        return StringUtils.leftPad((String)bis, (int)(this.hexDigits + 1), (char)'0');
    }

    @Override
    public String toString() {
        return this.toStringHelper(this).add("digits", this.digits).toString();
    }
}

