/*
 * Decompiled with CFR 0.152.
 */
package com.stratio.cassandra.lucene.schema.mapping;

import com.google.common.base.Objects;
import com.stratio.cassandra.lucene.IndexException;
import com.stratio.cassandra.lucene.schema.column.Column;
import com.stratio.cassandra.lucene.schema.column.Columns;
import com.stratio.cassandra.lucene.schema.mapping.Mapper;
import com.stratio.cassandra.lucene.util.DateParser;
import java.util.Arrays;
import java.util.Date;
import org.apache.cassandra.db.marshal.AbstractType;
import org.apache.cassandra.db.marshal.AsciiType;
import org.apache.cassandra.db.marshal.Int32Type;
import org.apache.cassandra.db.marshal.IntegerType;
import org.apache.cassandra.db.marshal.LongType;
import org.apache.cassandra.db.marshal.SimpleDateType;
import org.apache.cassandra.db.marshal.TimeUUIDType;
import org.apache.cassandra.db.marshal.TimestampType;
import org.apache.cassandra.db.marshal.UTF8Type;
import org.apache.commons.lang3.StringUtils;
import org.apache.lucene.document.Document;
import org.apache.lucene.document.LongField;
import org.apache.lucene.search.SortField;

public class BitemporalMapper
extends Mapper {
    public static final String VT_FROM_FIELD_SUFFIX = ".vtFrom";
    public static final String VT_TO_FIELD_SUFFIX = ".vtTo";
    public static final String TT_FROM_FIELD_SUFFIX = ".ttFrom";
    public static final String TT_TO_FIELD_SUFFIX = ".ttTo";
    public final String pattern;
    public final String vtFrom;
    public final String vtTo;
    public final String ttFrom;
    public final String ttTo;
    public final Long nowValue;
    private final DateParser dateParser;

    public BitemporalMapper(String field, Boolean validated, String vtFrom, String vtTo, String ttFrom, String ttTo, String pattern, Object nowValue) {
        super(field, false, validated, null, Arrays.asList(vtFrom, vtTo, ttFrom, ttTo), new AbstractType[]{AsciiType.instance, UTF8Type.instance, Int32Type.instance, LongType.instance, IntegerType.instance, SimpleDateType.instance, TimestampType.instance, TimeUUIDType.instance});
        if (StringUtils.isBlank((CharSequence)vtFrom)) {
            throw new IndexException("vt_from column name is required", new Object[0]);
        }
        if (StringUtils.isBlank((CharSequence)vtTo)) {
            throw new IndexException("vt_to column name is required", new Object[0]);
        }
        if (StringUtils.isBlank((CharSequence)ttFrom)) {
            throw new IndexException("tt_from column name is required", new Object[0]);
        }
        if (StringUtils.isBlank((CharSequence)ttTo)) {
            throw new IndexException("tt_to column name is required", new Object[0]);
        }
        this.pattern = pattern == null ? "yyyy/MM/dd HH:mm:ss.SSS Z" : pattern;
        this.dateParser = new DateParser(this.pattern);
        this.vtFrom = vtFrom;
        this.vtTo = vtTo;
        this.ttFrom = ttFrom;
        this.ttTo = ttTo;
        this.nowValue = nowValue == null ? Long.MAX_VALUE : this.dateParser.parse(nowValue).getTime();
    }

    @Override
    public void addFields(Document document, Columns columns) {
        BitemporalDateTime vtFrom = this.readBitemporalDate(columns, this.vtFrom);
        BitemporalDateTime vtTo = this.readBitemporalDate(columns, this.vtTo);
        BitemporalDateTime ttFrom = this.readBitemporalDate(columns, this.ttFrom);
        BitemporalDateTime ttTo = this.readBitemporalDate(columns, this.ttTo);
        if (vtFrom == null && vtTo == null && ttFrom == null && ttTo == null) {
            return;
        }
        this.validate(vtFrom, vtTo, ttFrom, ttTo);
        document.add(new LongField(this.field + VT_FROM_FIELD_SUFFIX, vtFrom.toDate().getTime(), STORE));
        document.add(new LongField(this.field + VT_TO_FIELD_SUFFIX, vtTo.toDate().getTime(), STORE));
        document.add(new LongField(this.field + TT_FROM_FIELD_SUFFIX, ttFrom.toDate().getTime(), STORE));
        document.add(new LongField(this.field + TT_TO_FIELD_SUFFIX, ttTo.toDate().getTime(), STORE));
    }

    private void validate(BitemporalDateTime vtFrom, BitemporalDateTime vtTo, BitemporalDateTime ttFrom, BitemporalDateTime ttTo) {
        if (vtFrom == null) {
            throw new IndexException("vt_from column required", new Object[0]);
        }
        if (vtTo == null) {
            throw new IndexException("vt_to column required", new Object[0]);
        }
        if (ttFrom == null) {
            throw new IndexException("tt_from column required", new Object[0]);
        }
        if (ttTo == null) {
            throw new IndexException("tt_to column required", new Object[0]);
        }
        if (vtFrom.after(vtTo)) {
            throw new IndexException("vt_from:'%s' is after vt_to:'%s'", vtTo.toString(this.dateParser), vtFrom.toString(this.dateParser));
        }
        if (ttFrom.after(ttTo)) {
            throw new IndexException("tt_from:'%s' is after tt_to:'%s'", ttTo.toString(this.dateParser), ttFrom.toString(this.dateParser));
        }
    }

    BitemporalDateTime readBitemporalDate(Columns columns, String fieldName) {
        Column<?> column = columns.getColumnsByFullName(fieldName).getFirst();
        if (column == null) {
            return null;
        }
        return this.parseBitemporalDate(column);
    }

    private BitemporalDateTime checkIfNow(Long in) {
        if (in > this.nowValue) {
            throw new IndexException("BitemporalDateTime value '%s' exceeds Max Value: '%s'", in, this.nowValue);
        }
        if (in < this.nowValue) {
            return new BitemporalDateTime(in);
        }
        return new BitemporalDateTime(Long.MAX_VALUE);
    }

    public BitemporalDateTime parseBitemporalDate(Object value) {
        Date opt = this.dateParser.parse(value);
        if (opt != null) {
            return this.checkIfNow(opt.getTime());
        }
        return null;
    }

    private <T> BitemporalDateTime parseBitemporalDate(Column<T> column) {
        Date date = this.dateParser.parse(column);
        return date == null ? null : this.checkIfNow(date.getTime());
    }

    @Override
    public SortField sortField(String name, boolean reverse) {
        throw new IndexException("Bitemporal mapper '{}' does not support sorting", name);
    }

    @Override
    public String toString() {
        return Objects.toStringHelper((Object)this).add("field", (Object)this.field).add("validated", (Object)this.validated).add("vtFrom", (Object)this.vtFrom).add("vtTo", (Object)this.vtTo).add("ttFrom", (Object)this.ttFrom).add("ttTo", (Object)this.ttTo).add("pattern", (Object)this.pattern).add("nowValue", (Object)this.nowValue).toString();
    }

    public static class BitemporalDateTime
    implements Comparable<BitemporalDateTime> {
        public static final BitemporalDateTime MAX = new BitemporalDateTime(Long.MAX_VALUE);
        public static final BitemporalDateTime MIN = new BitemporalDateTime(0L);
        private final Long timestamp;
        private final Date date;

        public BitemporalDateTime(Date date) {
            this.timestamp = date.getTime();
            this.date = date;
        }

        public BitemporalDateTime(Long timestamp) {
            if (timestamp < 0L) {
                throw new IndexException("Cannot build a BitemporalDateTime with a negative unix time", new Object[0]);
            }
            this.timestamp = timestamp;
            this.date = new Date(timestamp);
        }

        public boolean isNow() {
            return this.timestamp.equals(BitemporalDateTime.MAX.timestamp);
        }

        public boolean isMax() {
            return this.timestamp.equals(BitemporalDateTime.MAX.timestamp);
        }

        public boolean isMin() {
            return this.timestamp.equals(0L);
        }

        public Date toDate() {
            return this.date;
        }

        public boolean after(BitemporalDateTime time) {
            return this.date.after(time.date);
        }

        @Override
        public int compareTo(BitemporalDateTime other) {
            return this.timestamp.compareTo(other.timestamp);
        }

        public static BitemporalDateTime max(BitemporalDateTime bt1, BitemporalDateTime bt2) {
            int result = bt1.compareTo(bt2);
            return result <= 0 ? bt2 : bt1;
        }

        public String toString() {
            return this.timestamp.toString();
        }

        public String toString(DateParser dateParser) {
            return dateParser.toString(this.date);
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || this.getClass() != o.getClass()) {
                return false;
            }
            BitemporalDateTime that = (BitemporalDateTime)o;
            return this.timestamp.equals(that.timestamp);
        }

        public int hashCode() {
            return this.timestamp.hashCode();
        }
    }
}

