/*
 * Decompiled with CFR 0.152.
 */
package com.stratio.cassandra.lucene.schema.mapping;

import com.stratio.cassandra.lucene.IndexException;
import com.stratio.cassandra.lucene.schema.mapping.KeywordMapper;
import com.stratio.cassandra.lucene.util.ByteBufferUtils;
import java.nio.ByteBuffer;
import org.apache.cassandra.db.marshal.AbstractType;
import org.apache.cassandra.db.marshal.BytesType;
import org.apache.cassandra.db.marshal.UTF8Type;
import org.apache.cassandra.utils.Hex;

public class BlobMapper
extends KeywordMapper {
    public BlobMapper(String field, String column, Boolean validated) {
        super(field, column, validated, new AbstractType[]{UTF8Type.instance, BytesType.instance});
    }

    @Override
    protected String doBase(String name, Object value) {
        if (value instanceof ByteBuffer) {
            return this.base((ByteBuffer)value);
        }
        if (value instanceof byte[]) {
            return this.base((byte[])value);
        }
        if (value instanceof String) {
            return this.base((String)value);
        }
        throw new IndexException("Field '%s' requires a byte array, but found '%s'", this.field, value);
    }

    private String base(ByteBuffer value) {
        return ByteBufferUtils.toHex(value);
    }

    private String base(byte[] value) {
        return ByteBufferUtils.toHex(value);
    }

    private String base(String value) {
        try {
            byte[] bytes = Hex.hexToBytes((String)value.replaceFirst("0x", ""));
            return Hex.bytesToHex((byte[])bytes);
        }
        catch (NumberFormatException e) {
            throw new IndexException(e, "Field '%s' requires an hex string, but found '%s'", this.field, value);
        }
    }
}

