/*
 * Decompiled with CFR 0.152.
 */
package com.stratio.cassandra.lucene.schema.mapping;

import com.stratio.cassandra.lucene.IndexException;
import com.stratio.cassandra.lucene.schema.mapping.KeywordMapper;
import org.apache.cassandra.db.marshal.AbstractType;
import org.apache.cassandra.db.marshal.BooleanType;
import org.apache.cassandra.db.marshal.UTF8Type;

public class BooleanMapper
extends KeywordMapper {
    private static final String TRUE = "true";
    private static final String FALSE = "false";

    public BooleanMapper(String field, String column, Boolean validated) {
        super(field, column, validated, new AbstractType[]{UTF8Type.instance, BooleanType.instance});
    }

    @Override
    protected String doBase(String name, Object value) {
        if (value instanceof Boolean) {
            return (Boolean)value != false ? TRUE : FALSE;
        }
        if (value instanceof String) {
            return this.base(name, (String)value);
        }
        throw new IndexException("Field '%s' requires a boolean, but found '%s'", name, value);
    }

    private String base(String name, String value) {
        if (value.equalsIgnoreCase(TRUE)) {
            return TRUE;
        }
        if (value.equalsIgnoreCase(FALSE)) {
            return FALSE;
        }
        throw new IndexException("Boolean field '%s' requires either '%s' or '%s', but found '%s'", name, TRUE, FALSE, value);
    }
}

