/*
 * Decompiled with CFR 0.152.
 */
package com.stratio.cassandra.lucene.schema.mapping;

import com.stratio.cassandra.lucene.schema.column.Column;
import com.stratio.cassandra.lucene.schema.mapping.SingleColumnMapper;
import com.stratio.cassandra.lucene.util.DateParser;
import java.util.Date;
import org.apache.cassandra.db.marshal.AbstractType;
import org.apache.cassandra.db.marshal.AsciiType;
import org.apache.cassandra.db.marshal.Int32Type;
import org.apache.cassandra.db.marshal.IntegerType;
import org.apache.cassandra.db.marshal.LongType;
import org.apache.cassandra.db.marshal.SimpleDateType;
import org.apache.cassandra.db.marshal.TimeUUIDType;
import org.apache.cassandra.db.marshal.TimestampType;
import org.apache.cassandra.db.marshal.UTF8Type;
import org.apache.lucene.document.Field;
import org.apache.lucene.document.LongField;
import org.apache.lucene.document.SortedNumericDocValuesField;
import org.apache.lucene.search.SortField;
import org.apache.lucene.search.SortedNumericSortField;

public class DateMapper
extends SingleColumnMapper.SingleFieldMapper<Long> {
    public final String pattern;
    private final DateParser dateParser;

    public DateMapper(String field, String column, Boolean validated, String pattern) {
        super(field, column, (Boolean)true, validated, null, Long.class, new AbstractType[]{AsciiType.instance, UTF8Type.instance, Int32Type.instance, LongType.instance, IntegerType.instance, SimpleDateType.instance, TimestampType.instance, TimeUUIDType.instance});
        this.pattern = pattern == null ? "yyyy/MM/dd HH:mm:ss.SSS Z" : pattern;
        this.dateParser = new DateParser(this.pattern);
    }

    @Override
    protected Long doBase(String name, Object value) {
        Date date = this.dateParser.parse(value);
        return date == null ? null : Long.valueOf(date.getTime());
    }

    @Override
    protected <K> Long doBase(Column<K> column) {
        Date date = this.dateParser.parse(column);
        return date == null ? null : Long.valueOf(date.getTime());
    }

    @Override
    public Field indexedField(String name, Long value) {
        return new LongField(name, (long)value, STORE);
    }

    @Override
    public Field sortedField(String name, Long value) {
        return new SortedNumericDocValuesField(name, value);
    }

    @Override
    public SortField sortField(String name, boolean reverse) {
        return new SortedNumericSortField(name, SortField.Type.LONG, reverse);
    }

    @Override
    public String toString() {
        return this.toStringHelper(this).add("pattern", (Object)this.pattern).toString();
    }
}

