/*
 * Decompiled with CFR 0.152.
 */
package com.stratio.cassandra.lucene.schema.mapping;

import com.google.common.base.Objects;
import com.stratio.cassandra.lucene.IndexException;
import com.stratio.cassandra.lucene.schema.column.Column;
import com.stratio.cassandra.lucene.schema.column.Columns;
import com.stratio.cassandra.lucene.schema.mapping.Mapper;
import com.stratio.cassandra.lucene.util.DateParser;
import java.util.Arrays;
import java.util.Date;
import org.apache.cassandra.db.marshal.AbstractType;
import org.apache.cassandra.db.marshal.AsciiType;
import org.apache.cassandra.db.marshal.Int32Type;
import org.apache.cassandra.db.marshal.IntegerType;
import org.apache.cassandra.db.marshal.LongType;
import org.apache.cassandra.db.marshal.SimpleDateType;
import org.apache.cassandra.db.marshal.TimeUUIDType;
import org.apache.cassandra.db.marshal.TimestampType;
import org.apache.cassandra.db.marshal.UTF8Type;
import org.apache.commons.lang3.StringUtils;
import org.apache.lucene.document.Document;
import org.apache.lucene.document.Field;
import org.apache.lucene.search.SortField;
import org.apache.lucene.spatial.prefix.NumberRangePrefixTreeStrategy;
import org.apache.lucene.spatial.prefix.tree.DateRangePrefixTree;
import org.apache.lucene.spatial.prefix.tree.NumberRangePrefixTree;

public class DateRangeMapper
extends Mapper {
    public final String from;
    public final String to;
    public final String pattern;
    private final DateParser dateParser;
    private final DateRangePrefixTree tree;
    public final NumberRangePrefixTreeStrategy strategy;

    public DateRangeMapper(String field, Boolean validated, String from, String to, String pattern) {
        super(field, false, validated, null, Arrays.asList(from, to), new AbstractType[]{AsciiType.instance, UTF8Type.instance, Int32Type.instance, LongType.instance, IntegerType.instance, SimpleDateType.instance, TimestampType.instance, TimeUUIDType.instance});
        if (StringUtils.isBlank((CharSequence)from)) {
            throw new IndexException("from column name is required", new Object[0]);
        }
        if (StringUtils.isBlank((CharSequence)to)) {
            throw new IndexException("to column name is required", new Object[0]);
        }
        this.from = from;
        this.to = to;
        this.tree = DateRangePrefixTree.INSTANCE;
        this.strategy = new NumberRangePrefixTreeStrategy(this.tree, field);
        this.pattern = pattern == null ? "yyyy/MM/dd HH:mm:ss.SSS Z" : pattern;
        this.dateParser = new DateParser(this.pattern);
    }

    @Override
    public void addFields(Document document, Columns columns) {
        Date fromDate = this.readFrom(columns);
        Date toDate = this.readTo(columns);
        if (fromDate == null && toDate == null) {
            return;
        }
        this.validate(fromDate, toDate);
        NumberRangePrefixTree.NRShape shape = this.makeShape(fromDate, toDate);
        for (Field field : this.strategy.createIndexableFields(shape)) {
            document.add(field);
        }
    }

    private void validate(Date from, Date to) {
        if (from == null) {
            throw new IndexException("From column required", new Object[0]);
        }
        if (to == null) {
            throw new IndexException("To column required", new Object[0]);
        }
        if (from.after(to)) {
            throw new IndexException("From:'%s' is after To:'%s'", this.dateParser.toString(to), this.dateParser.toString(from));
        }
    }

    @Override
    public SortField sortField(String name, boolean reverse) {
        throw new IndexException("Date range mapper '%s' does not support sorting", name);
    }

    public NumberRangePrefixTree.NRShape makeShape(Date from, Date to) {
        NumberRangePrefixTree.UnitNRShape fromShape = this.tree.toUnitShape(from);
        NumberRangePrefixTree.UnitNRShape toShape = this.tree.toUnitShape(to);
        return this.tree.toRangeShape(fromShape, toShape);
    }

    Date readFrom(Columns columns) {
        Column<?> column = columns.getColumnsByFullName(this.from).getFirst();
        if (column == null) {
            return null;
        }
        Date fromDate = this.base(column);
        if (this.to == null) {
            throw new IndexException("From date required", new Object[0]);
        }
        return fromDate;
    }

    Date readTo(Columns columns) {
        Column<?> column = columns.getColumnsByFullName(this.to).getFirst();
        if (column == null) {
            return null;
        }
        Date toDate = this.base(column);
        if (toDate == null) {
            throw new IndexException("To date required", new Object[0]);
        }
        return toDate;
    }

    public Date base(Object value) {
        return this.dateParser.parse(value);
    }

    private <T> Date base(Column<T> column) {
        return this.dateParser.parse(column);
    }

    @Override
    public String toString() {
        return Objects.toStringHelper((Object)this).add("field", (Object)this.field).add("validated", (Object)this.validated).add("from", (Object)this.from).add("to", (Object)this.to).add("pattern", (Object)this.pattern).toString();
    }
}

