/*
 * Decompiled with CFR 0.152.
 */
package com.stratio.cassandra.lucene.schema.mapping;

import com.stratio.cassandra.lucene.IndexException;
import com.stratio.cassandra.lucene.schema.mapping.SingleColumnMapper;
import org.apache.cassandra.db.marshal.AbstractType;
import org.apache.cassandra.db.marshal.AsciiType;
import org.apache.cassandra.db.marshal.ByteType;
import org.apache.cassandra.db.marshal.DecimalType;
import org.apache.cassandra.db.marshal.DoubleType;
import org.apache.cassandra.db.marshal.FloatType;
import org.apache.cassandra.db.marshal.Int32Type;
import org.apache.cassandra.db.marshal.IntegerType;
import org.apache.cassandra.db.marshal.LongType;
import org.apache.cassandra.db.marshal.ShortType;
import org.apache.cassandra.db.marshal.UTF8Type;
import org.apache.lucene.document.DoubleField;
import org.apache.lucene.document.Field;
import org.apache.lucene.document.SortedNumericDocValuesField;
import org.apache.lucene.search.SortField;
import org.apache.lucene.search.SortedNumericSortField;
import org.apache.lucene.util.NumericUtils;

public class DoubleMapper
extends SingleColumnMapper.SingleFieldMapper<Double> {
    public static final float DEFAULT_BOOST = 1.0f;
    public final Float boost;

    public DoubleMapper(String field, String column, Boolean validated, Float boost) {
        super(field, column, (Boolean)true, validated, null, Double.class, new AbstractType[]{AsciiType.instance, ByteType.instance, DecimalType.instance, DoubleType.instance, FloatType.instance, IntegerType.instance, Int32Type.instance, LongType.instance, UTF8Type.instance, ShortType.instance, UTF8Type.instance});
        this.boost = Float.valueOf(boost == null ? 1.0f : boost.floatValue());
    }

    @Override
    protected Double doBase(String name, Object value) {
        if (value instanceof Number) {
            return ((Number)value).doubleValue();
        }
        if (value instanceof String) {
            try {
                return Double.valueOf((String)value);
            }
            catch (NumberFormatException e) {
                throw new IndexException("Field '%s' with value '%s' can not be parsed as double", name, value);
            }
        }
        throw new IndexException("Field '%s' requires a double, but found '%s'", name, value);
    }

    @Override
    public Field indexedField(String name, Double value) {
        DoubleField field = new DoubleField(name, (double)value, STORE);
        field.setBoost(this.boost.floatValue());
        return field;
    }

    @Override
    public Field sortedField(String name, Double value) {
        long sortable = NumericUtils.doubleToSortableLong(value);
        return new SortedNumericDocValuesField(name, sortable);
    }

    @Override
    public SortField sortField(String name, boolean reverse) {
        return new SortedNumericSortField(name, SortField.Type.DOUBLE, reverse);
    }

    @Override
    public String toString() {
        return this.toStringHelper(this).add("boost", (Object)this.boost).toString();
    }
}

