/*
 * Decompiled with CFR 0.152.
 */
package com.stratio.cassandra.lucene.schema.mapping;

import com.stratio.cassandra.lucene.IndexException;
import com.stratio.cassandra.lucene.schema.mapping.SingleColumnMapper;
import org.apache.cassandra.db.marshal.AbstractType;
import org.apache.cassandra.db.marshal.AsciiType;
import org.apache.cassandra.db.marshal.ByteType;
import org.apache.cassandra.db.marshal.DecimalType;
import org.apache.cassandra.db.marshal.DoubleType;
import org.apache.cassandra.db.marshal.FloatType;
import org.apache.cassandra.db.marshal.Int32Type;
import org.apache.cassandra.db.marshal.IntegerType;
import org.apache.cassandra.db.marshal.LongType;
import org.apache.cassandra.db.marshal.ShortType;
import org.apache.cassandra.db.marshal.UTF8Type;
import org.apache.lucene.document.Field;
import org.apache.lucene.document.FloatField;
import org.apache.lucene.document.SortedNumericDocValuesField;
import org.apache.lucene.search.SortField;
import org.apache.lucene.search.SortedNumericSortField;
import org.apache.lucene.util.NumericUtils;
import org.codehaus.jackson.annotate.JsonCreator;

public class FloatMapper
extends SingleColumnMapper.SingleFieldMapper<Float> {
    public static final Float DEFAULT_BOOST = Float.valueOf(1.0f);
    public final Float boost;

    @JsonCreator
    public FloatMapper(String field, String column, Boolean validated, Float boost) {
        super(field, column, (Boolean)true, validated, null, Float.class, new AbstractType[]{AsciiType.instance, ByteType.instance, DecimalType.instance, DoubleType.instance, FloatType.instance, IntegerType.instance, Int32Type.instance, LongType.instance, ShortType.instance, UTF8Type.instance});
        this.boost = boost == null ? DEFAULT_BOOST : boost;
    }

    @Override
    protected Float doBase(String name, Object value) {
        if (value instanceof Number) {
            return Float.valueOf(((Number)value).floatValue());
        }
        if (value instanceof String) {
            try {
                return Float.valueOf(Double.valueOf((String)value).floatValue());
            }
            catch (NumberFormatException e) {
                throw new IndexException("Field '%s' with value '%s' can not be parsed as float", name, value);
            }
        }
        throw new IndexException("Field '%s' requires a float, but found '%s'", name, value);
    }

    @Override
    public Field indexedField(String name, Float value) {
        FloatField field = new FloatField(name, value.floatValue(), STORE);
        field.setBoost(this.boost.floatValue());
        return field;
    }

    @Override
    public Field sortedField(String name, Float value) {
        int sortable = NumericUtils.floatToSortableInt(value.floatValue());
        return new SortedNumericDocValuesField(name, sortable);
    }

    @Override
    public SortField sortField(String name, boolean reverse) {
        return new SortedNumericSortField(name, SortField.Type.FLOAT, reverse);
    }

    @Override
    public String toString() {
        return this.toStringHelper(this).add("boost", (Object)this.boost).toString();
    }
}

