/*
 * Decompiled with CFR 0.152.
 */
package com.stratio.cassandra.lucene.schema.mapping;

import com.google.common.base.Objects;
import com.spatial4j.core.shape.Point;
import com.stratio.cassandra.lucene.IndexException;
import com.stratio.cassandra.lucene.schema.column.Column;
import com.stratio.cassandra.lucene.schema.column.Columns;
import com.stratio.cassandra.lucene.schema.mapping.Mapper;
import com.stratio.cassandra.lucene.util.GeospatialUtils;
import java.util.Arrays;
import org.apache.cassandra.db.marshal.AbstractType;
import org.apache.cassandra.db.marshal.AsciiType;
import org.apache.cassandra.db.marshal.DecimalType;
import org.apache.cassandra.db.marshal.DoubleType;
import org.apache.cassandra.db.marshal.FloatType;
import org.apache.cassandra.db.marshal.Int32Type;
import org.apache.cassandra.db.marshal.IntegerType;
import org.apache.cassandra.db.marshal.LongType;
import org.apache.cassandra.db.marshal.ShortType;
import org.apache.cassandra.db.marshal.UTF8Type;
import org.apache.commons.lang3.StringUtils;
import org.apache.lucene.document.Document;
import org.apache.lucene.document.Field;
import org.apache.lucene.document.StoredField;
import org.apache.lucene.search.SortField;
import org.apache.lucene.spatial.SpatialStrategy;
import org.apache.lucene.spatial.bbox.BBoxStrategy;
import org.apache.lucene.spatial.prefix.RecursivePrefixTreeStrategy;
import org.apache.lucene.spatial.prefix.tree.GeohashPrefixTree;

public class GeoPointMapper
extends Mapper {
    private static final double MIN_LATITUDE = -90.0;
    private static final double MAX_LATITUDE = 90.0;
    private static final double MIN_LONGITUDE = -180.0;
    private static final double MAX_LONGITUDE = 180.0;
    public final String latitude;
    public final String longitude;
    public final int maxLevels;
    public final SpatialStrategy distanceStrategy;
    public final SpatialStrategy bboxStrategy;

    public GeoPointMapper(String field, Boolean validated, String latitude, String longitude, Integer maxLevels) {
        super(field, false, validated, null, Arrays.asList(latitude, longitude), new AbstractType[]{AsciiType.instance, DecimalType.instance, DoubleType.instance, FloatType.instance, IntegerType.instance, Int32Type.instance, LongType.instance, ShortType.instance, UTF8Type.instance});
        if (StringUtils.isBlank((CharSequence)latitude)) {
            throw new IndexException("latitude column name is required", new Object[0]);
        }
        if (StringUtils.isBlank((CharSequence)longitude)) {
            throw new IndexException("longitude column name is required", new Object[0]);
        }
        this.latitude = latitude;
        this.longitude = longitude;
        this.maxLevels = GeospatialUtils.validateGeohashMaxLevels(maxLevels);
        GeohashPrefixTree grid = new GeohashPrefixTree(GeospatialUtils.CONTEXT, this.maxLevels);
        this.distanceStrategy = new RecursivePrefixTreeStrategy(grid, field + ".dist");
        this.bboxStrategy = new BBoxStrategy(GeospatialUtils.CONTEXT, field + ".bbox");
    }

    public static Double checkLatitude(String name, Double latitude) {
        if (latitude == null) {
            throw new IndexException("%s required", name);
        }
        if (latitude < -90.0 || latitude > 90.0) {
            throw new IndexException("%s must be in range [%s, %s], but found %s", name, -90.0, 90.0, latitude);
        }
        return latitude;
    }

    public static Double checkLongitude(String name, Double longitude) {
        if (longitude == null) {
            throw new IndexException("%s required", name);
        }
        if (longitude < -180.0 || longitude > 180.0) {
            throw new IndexException("%s must be in range [%s, %s], but found %s", name, -180.0, 180.0, longitude);
        }
        return longitude;
    }

    @Override
    public void addFields(Document document, Columns columns) {
        Double lon = this.readLongitude(columns);
        Double lat = this.readLatitude(columns);
        if (lon == null && lat == null) {
            return;
        }
        if (lat == null) {
            throw new IndexException("Latitude column required if there is a longitude", new Object[0]);
        }
        if (lon == null) {
            throw new IndexException("Longitude column required if there is a latitude", new Object[0]);
        }
        Point point = GeospatialUtils.CONTEXT.makePoint(lon, lat);
        for (Field field : this.distanceStrategy.createIndexableFields(point)) {
            document.add(field);
        }
        for (Field field : this.bboxStrategy.createIndexableFields(point)) {
            document.add(field);
        }
        document.add(new StoredField(this.distanceStrategy.getFieldName(), point.getX() + " " + point.getY()));
    }

    @Override
    public SortField sortField(String name, boolean reverse) {
        throw new IndexException("GeoPoint mapper '%s' does not support simple sorting", name);
    }

    public Double readLatitude(Columns columns) {
        Column<?> column = columns.getColumnsByFullName(this.latitude).getFirst();
        return column == null ? null : this.readLatitude(column.getComposedValue());
    }

    public Double readLongitude(Columns columns) {
        Column<?> column = columns.getColumnsByFullName(this.longitude).getFirst();
        return column == null ? null : GeoPointMapper.readLongitude(column.getComposedValue());
    }

    private Double readLatitude(Object o) {
        Double value;
        if (o == null) {
            return null;
        }
        if (o instanceof Number) {
            value = ((Number)o).doubleValue();
        } else {
            try {
                value = Double.valueOf(o.toString());
            }
            catch (NumberFormatException e) {
                throw new IndexException("Unparseable latitude: %s", o);
            }
        }
        return GeoPointMapper.checkLatitude("latitude", value);
    }

    private static Double readLongitude(Object o) {
        Double value;
        if (o == null) {
            return null;
        }
        if (o instanceof Number) {
            value = ((Number)o).doubleValue();
        } else {
            try {
                value = Double.valueOf(o.toString());
            }
            catch (NumberFormatException e) {
                throw new IndexException("Unparseable longitude: %s", o);
            }
        }
        return GeoPointMapper.checkLongitude("longitude", value);
    }

    @Override
    public String toString() {
        return Objects.toStringHelper((Object)this).add("field", (Object)this.field).add("validated", (Object)this.validated).add("latitude", (Object)this.latitude).add("longitude", (Object)this.longitude).add("maxLevels", this.maxLevels).toString();
    }
}

