/*
 * Decompiled with CFR 0.152.
 */
package com.stratio.cassandra.lucene.schema.mapping;

import com.google.common.base.Objects;
import com.spatial4j.core.shape.jts.JtsGeometry;
import com.stratio.cassandra.lucene.IndexException;
import com.stratio.cassandra.lucene.common.GeoTransformation;
import com.stratio.cassandra.lucene.schema.mapping.SingleColumnMapper;
import com.stratio.cassandra.lucene.util.GeospatialUtils;
import com.stratio.cassandra.lucene.util.GeospatialUtilsJTS;
import java.util.Collections;
import java.util.List;
import org.apache.cassandra.db.marshal.AbstractType;
import org.apache.cassandra.db.marshal.AsciiType;
import org.apache.cassandra.db.marshal.UTF8Type;
import org.apache.commons.lang3.StringUtils;
import org.apache.lucene.document.Document;
import org.apache.lucene.document.Field;
import org.apache.lucene.search.SortField;
import org.apache.lucene.spatial.prefix.RecursivePrefixTreeStrategy;
import org.apache.lucene.spatial.prefix.tree.GeohashPrefixTree;

public class GeoShapeMapper
extends SingleColumnMapper<String> {
    public final String column;
    public final int maxLevels;
    public final RecursivePrefixTreeStrategy strategy;
    public final List<GeoTransformation> transformations;

    public GeoShapeMapper(String field, String column, Boolean validated, Integer maxLevels, List<GeoTransformation> transformations) {
        super(field, column, (Boolean)false, validated, null, String.class, new AbstractType[]{AsciiType.instance, UTF8Type.instance});
        String string = this.column = column == null ? field : column;
        if (StringUtils.isWhitespace((CharSequence)column)) {
            throw new IndexException("Column must not be whitespace, but found '%s'", column);
        }
        this.maxLevels = GeospatialUtils.validateGeohashMaxLevels(maxLevels);
        GeohashPrefixTree grid = new GeohashPrefixTree(GeospatialUtilsJTS.CONTEXT, this.maxLevels);
        this.strategy = new RecursivePrefixTreeStrategy(grid, field);
        this.transformations = transformations == null ? Collections.emptyList() : transformations;
    }

    @Override
    public void addIndexedFields(Document document, String name, String value) {
        JtsGeometry shape = GeospatialUtilsJTS.geometry(value);
        if (this.transformations != null) {
            for (GeoTransformation transformation : this.transformations) {
                shape = transformation.apply(shape);
            }
        }
        for (Field field : this.strategy.createIndexableFields(shape)) {
            document.add(field);
        }
    }

    @Override
    public void addSortedFields(Document document, String name, String value) {
    }

    @Override
    public SortField sortField(String name, boolean reverse) {
        throw new IndexException("GeoShape mapper '%s' does not support simple sorting", name);
    }

    @Override
    protected String doBase(String field, Object value) {
        return value.toString();
    }

    @Override
    public String toString() {
        return Objects.toStringHelper((Object)this).add("field", (Object)this.field).add("column", (Object)this.column).add("validated", (Object)this.validated).add("maxLevels", this.maxLevels).add("transformations", this.transformations).toString();
    }
}

