/*
 * Decompiled with CFR 0.152.
 */
package com.stratio.cassandra.lucene.schema.mapping;

import com.stratio.cassandra.lucene.IndexException;
import com.stratio.cassandra.lucene.schema.mapping.KeywordMapper;
import java.net.InetAddress;
import java.net.UnknownHostException;
import java.util.regex.Pattern;
import org.apache.cassandra.db.marshal.AbstractType;
import org.apache.cassandra.db.marshal.InetAddressType;
import org.apache.cassandra.db.marshal.UTF8Type;

public class InetMapper
extends KeywordMapper {
    private static final Pattern IPV4_PATTERN = Pattern.compile("(([01]?\\d\\d?|2[0-4]\\d|25[0-5])\\.){3}([01]?\\d\\d?|2[0-4]\\d|25[0-5])");
    private static final Pattern IPV6_PATTERN = Pattern.compile("^(?:[0-9a-fA-F]{1,4}:){7}[0-9a-fA-F]{1,4}$");
    private static final Pattern IPV6_COMPRESSED_PATTERN = Pattern.compile("^((?:[0-9A-Fa-f]{1,4}(?::[0-9A-Fa-f]{1,4})*)?)::((?:[0-9A-Fa-f]{1,4}(?::[0-9A-Fa-f]{1,4})*)?)$");

    public InetMapper(String field, String column, Boolean validated) {
        super(field, column, validated, new AbstractType[]{UTF8Type.instance, InetAddressType.instance});
    }

    @Override
    protected String doBase(String name, Object value) {
        if (value instanceof InetAddress) {
            return ((InetAddress)value).getHostAddress();
        }
        if (value instanceof String) {
            return this.doBase(name, (String)value);
        }
        throw new IndexException("Field '%s' requires an inet address, but found '%s'", name, value);
    }

    private String doBase(String name, String value) {
        if (IPV4_PATTERN.matcher(value).matches() || IPV6_PATTERN.matcher(value).matches() || IPV6_COMPRESSED_PATTERN.matcher(value).matches()) {
            try {
                return InetAddress.getByName(value).getHostAddress();
            }
            catch (UnknownHostException e) {
                throw new IndexException(e, "Unknown host exception for field '%s' with value '%s'", name, value);
            }
        }
        throw new IndexException("Field '%s' with value '%s' can not be parsed as an inet address", name, value);
    }
}

